/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.loginFailure;

import java.util.function.Function;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureAdapter;
import org.keycloak.models.map.loginFailure.MapUserLoginFailureEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;

public class MapUserLoginFailureProvider<K>
implements UserLoginFailureProvider {
    private static final Logger LOG = Logger.getLogger(MapUserLoginFailureProvider.class);
    private final KeycloakSession session;
    protected final MapKeycloakTransaction<K, MapUserLoginFailureEntity<K>, UserLoginFailureModel> userLoginFailureTx;
    private final MapStorage<K, MapUserLoginFailureEntity<K>, UserLoginFailureModel> userLoginFailureStore;

    public MapUserLoginFailureProvider(KeycloakSession session, MapStorage<K, MapUserLoginFailureEntity<K>, UserLoginFailureModel> userLoginFailureStore) {
        this.session = session;
        this.userLoginFailureStore = userLoginFailureStore;
        this.userLoginFailureTx = userLoginFailureStore.createTransaction(session);
        session.getTransactionManager().enlistAfterCompletion(this.userLoginFailureTx);
    }

    private Function<MapUserLoginFailureEntity<K>, UserLoginFailureModel> userLoginFailureEntityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapUserLoginFailureAdapter<K>(this.session, realm, MapStorageUtils.registerEntityForChanges(this.userLoginFailureTx, origEntity)){

            public String getId() {
                return MapUserLoginFailureProvider.this.userLoginFailureStore.getKeyConvertor().keyToString(((MapUserLoginFailureEntity)this.entity).getId());
            }
        };
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder<UserLoginFailureModel> mcb = this.userLoginFailureStore.createCriteriaBuilder().compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, userId);
        LOG.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        return this.userLoginFailureTx.read(mcb).findFirst().map(this.userLoginFailureEntityToAdapterFunc(realm)).orElse(null);
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder<UserLoginFailureModel> mcb = this.userLoginFailureStore.createCriteriaBuilder().compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, userId);
        LOG.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        MapUserLoginFailureEntity<K> userLoginFailureEntity = this.userLoginFailureTx.read(mcb).findFirst().orElse(null);
        if (userLoginFailureEntity == null) {
            userLoginFailureEntity = new MapUserLoginFailureEntity<K>(this.userLoginFailureStore.getKeyConvertor().yieldNewUniqueKey(), realm.getId(), userId);
            this.userLoginFailureTx.create(userLoginFailureEntity.getId(), userLoginFailureEntity);
        }
        return this.userLoginFailureEntityToAdapterFunc(realm).apply(userLoginFailureEntity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        ModelCriteriaBuilder<UserLoginFailureModel> mcb = this.userLoginFailureStore.createCriteriaBuilder().compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId()).compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.USER_ID, ModelCriteriaBuilder.Operator.EQ, userId);
        LOG.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        this.userLoginFailureTx.delete(this.userLoginFailureStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        ModelCriteriaBuilder<UserLoginFailureModel> mcb = this.userLoginFailureStore.createCriteriaBuilder().compare((SearchableModelField<UserLoginFailureModel>)UserLoginFailureModel.SearchableFields.REALM_ID, ModelCriteriaBuilder.Operator.EQ, realm.getId());
        LOG.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.userLoginFailureTx.delete(this.userLoginFailureStore.getKeyConvertor().yieldNewUniqueKey(), mcb);
    }

    public void close() {
    }
}

