/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.common;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.Provider;

public abstract class AbstractMapProviderFactory<T extends Provider, K, V extends AbstractEntity<K>, M>
implements AmphibianProviderFactory<T>,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "map";
    public static final String CONFIG_STORAGE = "storage";
    protected final Logger LOG = Logger.getLogger(this.getClass());
    protected final Class<M> modelType;
    protected final Class<V> entityType;
    private Config.Scope storageConfigScope;

    protected AbstractMapProviderFactory(Class<? extends AbstractEntity> entityType, Class<M> modelType) {
        this.modelType = modelType;
        this.entityType = entityType;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected MapStorage<K, V, M> getStorage(KeycloakSession session) {
        MapStorageProviderFactory storageProviderFactory = (MapStorageProviderFactory)KeycloakModelUtils.getComponentFactory((KeycloakSessionFactory)session.getKeycloakSessionFactory(), MapStorageProvider.class, (Config.Scope)this.storageConfigScope, (String)"mapStorage");
        MapStorageProvider factory = (MapStorageProvider)storageProviderFactory.create(session);
        return factory.getStorage(this.entityType, this.modelType, new MapStorageProviderFactory.Flag[0]);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void init(Config.Scope config) {
        this.storageConfigScope = config.scope(new String[]{CONFIG_STORAGE});
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

