/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapScopeAdapter;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapScopeStore<K>
implements ScopeStore {
    private static final Logger LOG = Logger.getLogger(MapScopeStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<K, MapScopeEntity<K>, Scope> tx;
    private final MapStorage<K, MapScopeEntity<K>, Scope> scopeStore;

    public MapScopeStore(KeycloakSession session, MapStorage<K, MapScopeEntity<K>, Scope> scopeStore, AuthorizationProvider provider) {
        this.authorizationProvider = provider;
        this.scopeStore = scopeStore;
        this.tx = scopeStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
    }

    private Scope entityToAdapter(MapScopeEntity<K> origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapScopeAdapter<K>(MapStorageUtils.registerEntityForChanges(this.tx, origEntity), this.authorizationProvider.getStoreFactory()){

            public String getId() {
                return MapScopeStore.this.scopeStore.getKeyConvertor().keyToString(((MapScopeEntity)this.entity).getId());
            }
        };
    }

    private ModelCriteriaBuilder<Scope> forResourceServer(String resourceServerId) {
        ModelCriteriaBuilder<Scope> mcb = this.scopeStore.createCriteriaBuilder();
        return resourceServerId == null ? mcb : mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, resourceServerId);
    }

    public Scope create(String id, String name, ResourceServer resourceServer) {
        LOG.tracef("create(%s, %s, %s)%s", new Object[]{id, name, resourceServer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Scope> mcb = this.forResourceServer(resourceServer.getId()).compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name);
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Scope with name '" + name + "' for " + resourceServer.getId() + " already exists");
        }
        K uid = id == null ? this.scopeStore.getKeyConvertor().yieldNewUniqueKey() : this.scopeStore.getKeyConvertor().fromString(id);
        MapScopeEntity<K> entity = new MapScopeEntity<K>(uid);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        this.tx.create(uid, entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(this.scopeStore.getKeyConvertor().fromString(id));
    }

    public Scope findById(String id, String resourceServerId) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Scope>)Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, id)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public Scope findByName(String name, String resourceServerId) {
        LOG.tracef("findByName(%s, %s)%s", (Object)name, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public List<Scope> findByResourceServer(String id) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(id)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Scope> findByResourceServer(Map<Scope.FilterOption, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        ModelCriteriaBuilder<Scope> mcb = this.forResourceServer(resourceServerId);
        block4: for (Scope.FilterOption filterOption : attributes.keySet()) {
            String[] value = attributes.get(filterOption);
            switch (filterOption) {
                case ID: {
                    mcb = mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.ID, ModelCriteriaBuilder.Operator.IN, Arrays.asList(value));
                    continue block4;
                }
                case NAME: {
                    mcb = mcb.compare((SearchableModelField<Scope>)Scope.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + value[0] + "%");
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unsupported filter [" + filterOption + "]");
        }
        return StreamsUtil.paginatedStream(this.tx.read(mcb).map(this::entityToAdapter), (Integer)firstResult, (Integer)maxResult).collect(Collectors.toList());
    }
}

