/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.map.authorization.adapter.MapResourceAdapter;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.common.MapStorageUtils;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.storage.SearchableModelField;
import org.keycloak.utils.StreamsUtil;

public class MapResourceStore<K extends Comparable<K>>
implements ResourceStore {
    private static final Logger LOG = Logger.getLogger(MapResourceStore.class);
    private final AuthorizationProvider authorizationProvider;
    final MapKeycloakTransaction<K, MapResourceEntity<K>, Resource> tx;
    private final MapStorage<K, MapResourceEntity<K>, Resource> resourceStore;

    public MapResourceStore(KeycloakSession session, MapStorage<K, MapResourceEntity<K>, Resource> resourceStore, AuthorizationProvider provider) {
        this.resourceStore = resourceStore;
        this.tx = resourceStore.createTransaction(session);
        session.getTransactionManager().enlist(this.tx);
        this.authorizationProvider = provider;
    }

    private Resource entityToAdapter(MapResourceEntity<K> origEntity) {
        if (origEntity == null) {
            return null;
        }
        return new MapResourceAdapter<K>(MapStorageUtils.registerEntityForChanges(this.tx, origEntity), this.authorizationProvider.getStoreFactory()){

            public String getId() {
                return MapResourceStore.this.resourceStore.getKeyConvertor().keyToString(((MapResourceEntity)this.entity).getId());
            }
        };
    }

    private ModelCriteriaBuilder<Resource> forResourceServer(String resourceServerId) {
        ModelCriteriaBuilder<Resource> mcb = this.resourceStore.createCriteriaBuilder();
        return resourceServerId == null ? mcb : mcb.compare((SearchableModelField<Resource>)Resource.SearchableFields.RESOURCE_SERVER_ID, ModelCriteriaBuilder.Operator.EQ, resourceServerId);
    }

    public Resource create(String id, String name, ResourceServer resourceServer, String owner) {
        LOG.tracef("create(%s, %s, %s, %s)%s", new Object[]{id, name, resourceServer, owner, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Resource> mcb = this.forResourceServer(resourceServer.getId()).compare((SearchableModelField<Resource>)Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name).compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, owner);
        if (this.tx.getCount(mcb) > 0L) {
            throw new ModelDuplicateException("Resource with name '" + name + "' for " + resourceServer.getId() + " already exists for request owner " + owner);
        }
        Comparable uid = id == null ? (Comparable)this.resourceStore.getKeyConvertor().yieldNewUniqueKey() : (Comparable)this.resourceStore.getKeyConvertor().fromString(id);
        MapResourceEntity<Comparable> entity = new MapResourceEntity<Comparable>(uid);
        entity.setName(name);
        entity.setResourceServerId(resourceServer.getId());
        entity.setOwner(owner);
        this.tx.create(uid, entity);
        return this.entityToAdapter(entity);
    }

    public void delete(String id) {
        LOG.tracef("delete(%s)%s", (Object)id, StackUtil.getShortStackTrace());
        this.tx.delete(this.resourceStore.getKeyConvertor().fromString(id));
    }

    public Resource findById(String id, String resourceServerId) {
        LOG.tracef("findById(%s, %s)%s", (Object)id, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.ID, ModelCriteriaBuilder.Operator.EQ, id)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public void findByOwner(String ownerId, String resourceServerId, Consumer<Resource> consumer) {
        this.findByOwnerFilter(ownerId, resourceServerId, consumer, -1, -1);
    }

    private void findByOwnerFilter(String ownerId, String resourceServerId, Consumer<Resource> consumer, int firstResult, int maxResult) {
        LOG.tracef("findByOwnerFilter(%s, %s, %s, %d, %d)%s", new Object[]{ownerId, resourceServerId, consumer, firstResult, maxResult, StackUtil.getShortStackTrace()});
        Comparator<MapResourceEntity> c = Comparator.comparing(MapResourceEntity::getId);
        StreamsUtil.paginatedStream(this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, ownerId)).sorted(c), (Integer)firstResult, (Integer)maxResult).map(this::entityToAdapter).forEach(consumer);
    }

    public List<Resource> findByOwner(String ownerId, String resourceServerId, int first, int max) {
        LinkedList<Resource> resourceList = new LinkedList<Resource>();
        this.findByOwnerFilter(ownerId, resourceServerId, resourceList::add, first, max);
        return resourceList;
    }

    public List<Resource> findByUri(String uri, String resourceServerId) {
        LOG.tracef("findByUri(%s, %s)%s", (Object)uri, (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.URI, ModelCriteriaBuilder.Operator.EQ, uri)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(String resourceServerId) {
        LOG.tracef("findByResourceServer(%s)%s", (Object)resourceServerId, StackUtil.getShortStackTrace());
        return this.tx.read(this.forResourceServer(resourceServerId)).map(this::entityToAdapter).collect(Collectors.toList());
    }

    public List<Resource> findByResourceServer(Map<Resource.FilterOption, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        LOG.tracef("findByResourceServer(%s, %s, %d, %d)%s", new Object[]{attributes, resourceServerId, firstResult, maxResult, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Resource> mcb = this.forResourceServer(resourceServerId).and((ModelCriteriaBuilder[])attributes.entrySet().stream().map(this::filterEntryToModelCriteriaBuilder).toArray(ModelCriteriaBuilder[]::new));
        return StreamsUtil.paginatedStream(this.tx.read(mcb).sorted(MapResourceEntity.COMPARE_BY_NAME), (Integer)firstResult, (Integer)maxResult).map(this::entityToAdapter).collect(Collectors.toList());
    }

    private ModelCriteriaBuilder<Resource> filterEntryToModelCriteriaBuilder(Map.Entry<Resource.FilterOption, String[]> entry) {
        Resource.FilterOption name = entry.getKey();
        String[] value = entry.getValue();
        switch (name) {
            case ID: 
            case SCOPE_ID: 
            case OWNER: 
            case URI: {
                return this.resourceStore.createCriteriaBuilder().compare((SearchableModelField<Resource>)name.getSearchableModelField(), ModelCriteriaBuilder.Operator.IN, Arrays.asList(value));
            }
            case URI_NOT_NULL: {
                return this.resourceStore.createCriteriaBuilder().compare((SearchableModelField<Resource>)Resource.SearchableFields.URI, ModelCriteriaBuilder.Operator.EXISTS, new Object[0]);
            }
            case OWNER_MANAGED_ACCESS: {
                return this.resourceStore.createCriteriaBuilder().compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER_MANAGED_ACCESS, ModelCriteriaBuilder.Operator.EQ, Boolean.valueOf(value[0]));
            }
            case EXACT_NAME: {
                return this.resourceStore.createCriteriaBuilder().compare((SearchableModelField<Resource>)Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, value[0]);
            }
            case NAME: {
                return this.resourceStore.createCriteriaBuilder().compare((SearchableModelField<Resource>)Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.ILIKE, "%" + value[0] + "%");
            }
        }
        throw new IllegalArgumentException("Unsupported filter [" + name + "]");
    }

    public void findByScope(List<String> scopes, String resourceServerId, Consumer<Resource> consumer) {
        LOG.tracef("findByScope(%s, %s, %s)%s", new Object[]{scopes, resourceServerId, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.SCOPE_ID, ModelCriteriaBuilder.Operator.IN, scopes)).map(this::entityToAdapter).forEach(consumer);
    }

    public Resource findByName(String name, String resourceServerId) {
        return this.findByName(name, resourceServerId, resourceServerId);
    }

    public Resource findByName(String name, String ownerId, String resourceServerId) {
        LOG.tracef("findByName(%s, %s, %s)%s", new Object[]{name, ownerId, resourceServerId, StackUtil.getShortStackTrace()});
        return this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, ownerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, name)).findFirst().map(this::entityToAdapter).orElse(null);
    }

    public void findByType(String type, String resourceServerId, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s)%s", new Object[]{type, resourceServerId, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, type)).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByType(String type, String owner, String resourceServerId, Consumer<Resource> consumer) {
        LOG.tracef("findByType(%s, %s, %s, %s)%s", new Object[]{type, owner, resourceServerId, consumer, StackUtil.getShortStackTrace()});
        ModelCriteriaBuilder<Resource> mcb = this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, type);
        if (owner != null) {
            mcb = mcb.compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.EQ, owner);
        }
        this.tx.read(mcb).map(this::entityToAdapter).forEach(consumer);
    }

    public void findByTypeInstance(String type, String resourceServerId, Consumer<Resource> consumer) {
        LOG.tracef("findByTypeInstance(%s, %s, %s)%s", new Object[]{type, resourceServerId, consumer, StackUtil.getShortStackTrace()});
        this.tx.read(this.forResourceServer(resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.OWNER, ModelCriteriaBuilder.Operator.NE, resourceServerId).compare((SearchableModelField<Resource>)Resource.SearchableFields.TYPE, ModelCriteriaBuilder.Operator.EQ, type)).map(this::entityToAdapter).forEach(consumer);
    }
}

