/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.chm;

import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.StringKeyConvertor;
import org.keycloak.models.map.storage.chm.ConcurrentHashMapStorage;
import org.keycloak.models.map.userSession.MapAuthenticatedClientSessionEntity;
import org.keycloak.models.map.userSession.MapUserSessionEntity;

public class UserSessionConcurrentHashMapStorage<K>
extends ConcurrentHashMapStorage<K, MapUserSessionEntity<K>, UserSessionModel> {
    private final ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity<K>, AuthenticatedClientSessionModel> clientSessionStore;

    public UserSessionConcurrentHashMapStorage(ConcurrentHashMapStorage<K, MapAuthenticatedClientSessionEntity<K>, AuthenticatedClientSessionModel> clientSessionStore, StringKeyConvertor<K> keyConvertor) {
        super(UserSessionModel.class, keyConvertor);
        this.clientSessionStore = clientSessionStore;
    }

    @Override
    public MapKeycloakTransaction<K, MapUserSessionEntity<K>, UserSessionModel> createTransaction(KeycloakSession session) {
        MapKeycloakTransaction sessionTransaction = (MapKeycloakTransaction)session.getAttribute("map-transaction-" + this.hashCode(), MapKeycloakTransaction.class);
        return sessionTransaction == null ? new Transaction(this.clientSessionStore.createTransaction(session)) : sessionTransaction;
    }

    private class Transaction
    extends MapKeycloakTransaction<K, MapUserSessionEntity<K>, UserSessionModel> {
        private final MapKeycloakTransaction<K, MapAuthenticatedClientSessionEntity<K>, AuthenticatedClientSessionModel> clientSessionTr;

        public Transaction(MapKeycloakTransaction<K, MapAuthenticatedClientSessionEntity<K>, AuthenticatedClientSessionModel> clientSessionTr) {
            super(UserSessionConcurrentHashMapStorage.this);
            this.clientSessionTr = clientSessionTr;
        }

        @Override
        public long delete(K artificialKey, ModelCriteriaBuilder<UserSessionModel> mcb) {
            Set ids = this.getUpdatedNotRemoved(mcb).map(AbstractEntity::getId).collect(Collectors.toSet());
            ModelCriteriaBuilder csMcb = UserSessionConcurrentHashMapStorage.this.clientSessionStore.createCriteriaBuilder().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.IN, ids);
            this.clientSessionTr.delete(artificialKey, csMcb);
            return super.delete(artificialKey, mcb);
        }

        @Override
        public void delete(K key) {
            ModelCriteriaBuilder csMcb = UserSessionConcurrentHashMapStorage.this.clientSessionStore.createCriteriaBuilder().compare(AuthenticatedClientSessionModel.SearchableFields.USER_SESSION_ID, ModelCriteriaBuilder.Operator.EQ, key);
            this.clientSessionTr.delete(key, csMcb);
            super.delete(key);
        }
    }
}

