/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.loginFailure;

import java.util.Objects;
import org.keycloak.models.map.common.AbstractEntity;

public class MapUserLoginFailureEntity<K>
implements AbstractEntity<K> {
    private K id;
    private String realmId;
    private String userId;
    protected boolean updated;
    private int failedLoginNotBefore;
    private int numFailures;
    private long lastFailure;
    private String lastIPFailure;

    public MapUserLoginFailureEntity() {
        this.id = null;
        this.realmId = null;
        this.userId = null;
    }

    public MapUserLoginFailureEntity(K id, String realmId, String userId) {
        this.id = id;
        this.realmId = realmId;
        this.userId = userId;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.updated |= !Objects.equals(this.userId, userId);
        this.userId = userId;
    }

    public int getFailedLoginNotBefore() {
        return this.failedLoginNotBefore;
    }

    public void setFailedLoginNotBefore(int failedLoginNotBefore) {
        this.updated |= this.failedLoginNotBefore != failedLoginNotBefore;
        this.failedLoginNotBefore = failedLoginNotBefore;
    }

    public int getNumFailures() {
        return this.numFailures;
    }

    public void setNumFailures(int numFailures) {
        this.updated |= this.numFailures != numFailures;
        this.numFailures = numFailures;
    }

    public long getLastFailure() {
        return this.lastFailure;
    }

    public void setLastFailure(long lastFailure) {
        this.updated |= this.lastFailure != lastFailure;
        this.lastFailure = lastFailure;
    }

    public String getLastIPFailure() {
        return this.lastIPFailure;
    }

    public void setLastIPFailure(String lastIPFailure) {
        this.updated |= !Objects.equals(this.lastIPFailure, lastIPFailure);
        this.lastIPFailure = lastIPFailure;
    }

    public void clearFailures() {
        this.updated |= this.failedLoginNotBefore != 0 || this.numFailures != 0 || this.lastFailure != 0L || this.lastIPFailure != null;
        this.numFailures = 0;
        this.failedLoginNotBefore = 0;
        this.lastFailure = 0L;
        this.lastIPFailure = null;
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), this.hashCode());
    }
}

