/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import java.security.SecureRandom;
import java.util.UUID;

public interface StringKeyConvertor<K> {
    default public String keyToString(K key) {
        return key == null ? null : key.toString();
    }

    public K yieldNewUniqueKey();

    public K fromString(String var1);

    default public K fromStringSafe(String key) {
        try {
            return this.fromString(key);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static class ULongKey
    implements StringKeyConvertor<Long> {
        public static final ULongKey INSTANCE = new ULongKey();

        @Override
        public Long fromString(String key) {
            return key == null ? null : Long.valueOf(Long.parseUnsignedLong(key));
        }

        @Override
        public Long yieldNewUniqueKey() {
            return Holder.numberGenerator.nextLong();
        }

        private static class Holder {
            static final SecureRandom numberGenerator = new SecureRandom();

            private Holder() {
            }
        }
    }

    public static class StringKey
    implements StringKeyConvertor<String> {
        public static final StringKey INSTANCE = new StringKey();

        @Override
        public String fromString(String key) {
            return key;
        }

        @Override
        public String yieldNewUniqueKey() {
            return this.fromString(UUID.randomUUID().toString());
        }
    }

    public static class UUIDKey
    implements StringKeyConvertor<UUID> {
        public static final UUIDKey INSTANCE = new UUIDKey();

        @Override
        public UUID yieldNewUniqueKey() {
            return UUID.randomUUID();
        }

        @Override
        public UUID fromString(String key) {
            return UUID.fromString(key);
        }
    }
}

