/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.clientscope;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.clientscope.AbstractClientScopeModel;
import org.keycloak.models.map.clientscope.MapClientScopeEntity;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RoleUtils;

public abstract class MapClientScopeAdapter<K>
extends AbstractClientScopeModel<MapClientScopeEntity<K>>
implements ClientScopeModel {
    public MapClientScopeAdapter(KeycloakSession session, RealmModel realm, MapClientScopeEntity<K> entity) {
        super(session, realm, entity);
    }

    public String getName() {
        return ((MapClientScopeEntity)this.entity).getName();
    }

    public void setName(String name) {
        ((MapClientScopeEntity)this.entity).setName(KeycloakModelUtils.convertClientScopeName((String)name));
    }

    public String getDescription() {
        return ((MapClientScopeEntity)this.entity).getDescription();
    }

    public void setDescription(String description) {
        ((MapClientScopeEntity)this.entity).setDescription(description);
    }

    public String getProtocol() {
        return ((MapClientScopeEntity)this.entity).getProtocol();
    }

    public void setProtocol(String protocol) {
        ((MapClientScopeEntity)this.entity).setProtocol(protocol);
    }

    public void setAttribute(String name, String value) {
        ((MapClientScopeEntity)this.entity).setAttribute(name, value);
    }

    public void removeAttribute(String name) {
        ((MapClientScopeEntity)this.entity).removeAttribute(name);
    }

    public String getAttribute(String name) {
        return ((MapClientScopeEntity)this.entity).getAttribute(name);
    }

    public Map<String, String> getAttributes() {
        return ((MapClientScopeEntity)this.entity).getAttributes();
    }

    public RealmModel getRealm() {
        return this.realm;
    }

    public Stream<ProtocolMapperModel> getProtocolMappersStream() {
        return ((MapClientScopeEntity)this.entity).getProtocolMappers().distinct();
    }

    public ProtocolMapperModel addProtocolMapper(ProtocolMapperModel model) {
        if (model == null) {
            return null;
        }
        ProtocolMapperModel pm = new ProtocolMapperModel();
        pm.setId(KeycloakModelUtils.generateId());
        pm.setName(model.getName());
        pm.setProtocol(model.getProtocol());
        pm.setProtocolMapper(model.getProtocolMapper());
        if (model.getConfig() != null) {
            pm.setConfig(new HashMap(model.getConfig()));
        } else {
            pm.setConfig(new HashMap());
        }
        return ((MapClientScopeEntity)this.entity).addProtocolMapper(pm);
    }

    public void removeProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).removeProtocolMapper(id);
        }
    }

    public void updateProtocolMapper(ProtocolMapperModel mapping) {
        String id;
        String string = id = mapping == null ? null : mapping.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).updateProtocolMapper(id, mapping);
        }
    }

    public ProtocolMapperModel getProtocolMapperById(String id) {
        return ((MapClientScopeEntity)this.entity).getProtocolMapperById(id);
    }

    public ProtocolMapperModel getProtocolMapperByName(String protocol, String name) {
        return ((MapClientScopeEntity)this.entity).getProtocolMappers().filter(pm -> Objects.equals(pm.getProtocol(), protocol) && Objects.equals(pm.getName(), name)).findAny().orElse(null);
    }

    public Stream<RoleModel> getScopeMappingsStream() {
        return ((MapClientScopeEntity)this.entity).getScopeMappings().map(arg_0 -> ((RealmModel)this.realm).getRoleById(arg_0)).filter(Objects::nonNull);
    }

    public Stream<RoleModel> getRealmScopeMappingsStream() {
        return this.getScopeMappingsStream().filter(r -> RoleUtils.isRealmRole((RoleModel)r, (RealmModel)this.realm));
    }

    public void addScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).addScopeMapping(id);
        }
    }

    public void deleteScopeMapping(RoleModel role) {
        String id;
        String string = id = role == null ? null : role.getId();
        if (id != null) {
            ((MapClientScopeEntity)this.entity).deleteScopeMapping(id);
        }
    }

    public boolean hasScope(RoleModel role) {
        return RoleUtils.hasRole(this.getScopeMappingsStream(), (RoleModel)role);
    }

    public String toString() {
        return String.format("%s@%08x", this.getId(), System.identityHashCode(this));
    }
}

