/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authorization;

import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.PermissionTicket;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.AuthorizationStoreFactory;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.common.Profile;
import org.keycloak.component.AmphibianProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.authorization.MapAuthorizationStore;
import org.keycloak.models.map.authorization.entity.MapPermissionTicketEntity;
import org.keycloak.models.map.authorization.entity.MapPolicyEntity;
import org.keycloak.models.map.authorization.entity.MapResourceEntity;
import org.keycloak.models.map.authorization.entity.MapResourceServerEntity;
import org.keycloak.models.map.authorization.entity.MapScopeEntity;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.models.map.storage.MapStorageProviderFactory;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;

public class MapAuthorizationStoreFactory<K>
implements AmphibianProviderFactory<StoreFactory>,
AuthorizationStoreFactory,
EnvironmentDependentProviderFactory {
    public static final String PROVIDER_ID = "map";
    private Config.Scope storageConfigScope;

    public StoreFactory create(KeycloakSession session) {
        MapStorageProviderFactory storageProviderFactory = (MapStorageProviderFactory)KeycloakModelUtils.getComponentFactory((KeycloakSessionFactory)session.getKeycloakSessionFactory(), MapStorageProvider.class, (Config.Scope)this.storageConfigScope, (String)"mapStorage");
        MapStorageProvider mapStorageProvider = (MapStorageProvider)storageProviderFactory.create(session);
        AuthorizationProvider provider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        MapStorage permissionTicketStore = mapStorageProvider.getStorage(MapPermissionTicketEntity.class, PermissionTicket.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage policyStore = mapStorageProvider.getStorage(MapPolicyEntity.class, Policy.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage resourceServerStore = mapStorageProvider.getStorage(MapResourceServerEntity.class, ResourceServer.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage resourceStore = mapStorageProvider.getStorage(MapResourceEntity.class, Resource.class, new MapStorageProviderFactory.Flag[0]);
        MapStorage scopeStore = mapStorageProvider.getStorage(MapScopeEntity.class, Scope.class, new MapStorageProviderFactory.Flag[0]);
        return new MapAuthorizationStore(session, permissionTicketStore, policyStore, resourceServerStore, resourceStore, scopeStore, provider);
    }

    public void init(Config.Scope config) {
        this.storageConfigScope = config.scope(new String[]{"storage"});
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getHelpText() {
        return "Authorization store provider";
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MAP_STORAGE);
    }
}

