/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.common.AbstractEntity;

public class MapRootAuthenticationSessionEntity<K>
implements AbstractEntity<K> {
    private K id;
    private String realmId;
    protected boolean updated;
    private int timestamp;
    private Map<String, MapAuthenticationSessionEntity> authenticationSessions = new ConcurrentHashMap<String, MapAuthenticationSessionEntity>();

    protected MapRootAuthenticationSessionEntity() {
        this.id = null;
        this.realmId = null;
    }

    public MapRootAuthenticationSessionEntity(K id, String realmId) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.updated |= !Objects.equals(this.timestamp, timestamp);
        this.timestamp = timestamp;
    }

    public Map<String, MapAuthenticationSessionEntity> getAuthenticationSessions() {
        return this.authenticationSessions;
    }

    public void setAuthenticationSessions(Map<String, MapAuthenticationSessionEntity> authenticationSessions) {
        this.updated |= !Objects.equals(this.authenticationSessions, authenticationSessions);
        this.authenticationSessions = authenticationSessions;
    }

    public MapAuthenticationSessionEntity removeAuthenticationSession(String tabId) {
        MapAuthenticationSessionEntity entity = this.authenticationSessions.remove(tabId);
        this.updated |= entity != null;
        return entity;
    }

    public void addAuthenticationSession(String tabId, MapAuthenticationSessionEntity entity) {
        this.updated |= !Objects.equals(this.authenticationSessions.put(tabId, entity), entity);
    }

    public void clearAuthenticationSessions() {
        this.updated |= !this.authenticationSessions.isEmpty();
        this.authenticationSessions.clear();
    }
}

