/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.models.map.common.AbstractEntity;

public abstract class AbstractRoleEntity<K>
implements AbstractEntity<K> {
    private K id;
    private String realmId;
    private String name;
    private String description;
    private boolean clientRole;
    private String clientId;
    private Set<String> compositeRoles = new HashSet<String>();
    private Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    protected boolean updated;

    protected AbstractRoleEntity() {
        this.id = null;
        this.realmId = null;
    }

    public AbstractRoleEntity(K id, String realmId) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(realmId, "realmId");
        this.id = id;
        this.realmId = realmId;
    }

    @Override
    public K getId() {
        return this.id;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.name, name);
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.description, description);
        this.description = description;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.updated |= !Objects.equals(this.attributes, attributes);
        this.attributes = attributes;
    }

    public void setAttribute(String name, List<String> values) {
        this.updated |= !Objects.equals(this.attributes.put(name, values), values);
    }

    public void removeAttribute(String name) {
        this.updated |= this.attributes.remove(name) != null;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.updated |= !Objects.equals(this.realmId, realmId);
        this.realmId = realmId;
    }

    public boolean isClientRole() {
        return this.clientRole;
    }

    public void setClientRole(boolean clientRole) {
        this.updated |= !Objects.equals(this.clientRole, clientRole);
        this.clientRole = clientRole;
    }

    public boolean isComposite() {
        return this.compositeRoles != null && !this.compositeRoles.isEmpty();
    }

    public Set<String> getCompositeRoles() {
        return this.compositeRoles;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.updated |= !Objects.equals(this.clientId, clientId);
        this.clientId = clientId;
    }

    public void setCompositeRoles(Set<String> compositeRoles) {
        this.updated |= !Objects.equals(this.compositeRoles, compositeRoles);
        this.compositeRoles.clear();
        this.compositeRoles.addAll(compositeRoles);
    }

    public void addCompositeRole(String roleId) {
        this.updated |= this.compositeRoles.add(roleId);
    }

    public void removeCompositeRole(String roleId) {
        this.updated |= this.compositeRoles.remove(roleId);
    }
}

