/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;
import org.keycloak.sessions.AuthenticationSessionProvider;
import org.keycloak.sessions.AuthenticationSessionProviderFactory;

public class MapRootAuthenticationSessionProviderFactory
extends AbstractMapProviderFactory<AuthenticationSessionProvider>
implements AuthenticationSessionProviderFactory {
    private MapStorage<UUID, MapRootAuthenticationSessionEntity> store;

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        MapStorageProvider sp = (MapStorageProvider)factory.getProviderFactory(MapStorageProvider.class);
        this.store = sp.getStorage("sessions", UUID.class, MapRootAuthenticationSessionEntity.class, new MapStorageProvider.Flag[0]);
    }

    public AuthenticationSessionProvider create(KeycloakSession session) {
        return new MapRootAuthenticationSessionProvider(session, this.store);
    }
}

