/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.role;

import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RoleProvider;
import org.keycloak.models.RoleProviderFactory;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleProvider;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;

public class MapRoleProviderFactory
extends AbstractMapProviderFactory<RoleProvider>
implements RoleProviderFactory {
    private MapStorage<UUID, MapRoleEntity> store;

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        MapStorageProvider sp = (MapStorageProvider)factory.getProviderFactory(MapStorageProvider.class);
        this.store = sp.getStorage("roles", UUID.class, MapRoleEntity.class, new MapStorageProvider.Flag[0]);
    }

    public RoleProvider create(KeycloakSession session) {
        return new MapRoleProvider(session, this.store);
    }
}

