/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.group;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.GroupModel;
import org.keycloak.models.GroupProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.group.AbstractGroupEntity;
import org.keycloak.models.map.group.MapGroupAdapter;
import org.keycloak.models.map.group.MapGroupEntity;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.provider.ProviderEvent;

public class MapGroupProvider
implements GroupProvider {
    private static final Logger LOG = Logger.getLogger(MapGroupProvider.class);
    private static final Predicate<MapGroupEntity> ALWAYS_FALSE = c -> false;
    private final KeycloakSession session;
    final MapKeycloakTransaction<UUID, MapGroupEntity> tx;
    private final MapStorage<UUID, MapGroupEntity> groupStore;

    public MapGroupProvider(KeycloakSession session, MapStorage<UUID, MapGroupEntity> groupStore) {
        this.session = session;
        this.groupStore = groupStore;
        this.tx = new MapKeycloakTransaction<UUID, MapGroupEntity>(groupStore);
        session.getTransactionManager().enlist(this.tx);
    }

    private MapGroupEntity registerEntityForChanges(MapGroupEntity origEntity) {
        MapGroupEntity res = Serialization.from(origEntity);
        this.tx.putIfChanged((UUID)origEntity.getId(), res, AbstractGroupEntity::isUpdated);
        return res;
    }

    private Function<MapGroupEntity, GroupModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapGroupAdapter(this.session, realm, this.registerEntityForChanges((MapGroupEntity)origEntity));
    }

    private Predicate<MapGroupEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return ALWAYS_FALSE;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public GroupModel getGroupById(RealmModel realm, String id) {
        UUID uid;
        if (id == null) {
            return null;
        }
        LOG.tracef("getGroupById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        try {
            uid = UUID.fromString(id);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
        MapGroupEntity entity = this.tx.get(uid, this.groupStore::get);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    private Stream<MapGroupEntity> getNotRemovedUpdatedGroupsStream() {
        Stream<MapGroupEntity> updatedAndNotRemovedGroupsStream = this.groupStore.entrySet().stream().map(this.tx::getUpdated).filter(Objects::nonNull);
        return Stream.concat(this.tx.createdValuesStream(), updatedAndNotRemovedGroupsStream);
    }

    private Stream<MapGroupEntity> getUnsortedGroupEntitiesStream(RealmModel realm) {
        return this.getNotRemovedUpdatedGroupsStream().filter(this.entityRealmFilter(realm));
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm) {
        LOG.tracef("getGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getUnsortedGroupEntitiesStream(realm).map(this.entityToAdapterFunc(realm)).sorted(GroupModel.COMPARE_BY_NAME);
    }

    public Stream<GroupModel> getGroupsStream(RealmModel realm, Stream<String> ids, String search, Integer first, Integer max) {
        Stream<GroupModel> groupModelStream = ids.map(id -> this.session.groups().getGroupById(realm, id)).sorted(Comparator.comparing(GroupModel::getName));
        if (search != null) {
            String s = search.toLowerCase();
            groupModelStream = groupModelStream.filter(groupModel -> groupModel.getName().toLowerCase().contains(s));
        }
        if (first != null && first > 0) {
            groupModelStream = groupModelStream.skip(first.intValue());
        }
        if (max != null && max >= 0) {
            groupModelStream = groupModelStream.limit(max.intValue());
        }
        return groupModelStream;
    }

    public Long getGroupsCount(RealmModel realm, Boolean onlyTopGroups) {
        LOG.tracef("getGroupsCount(%s, %s)%s", (Object)realm, (Object)onlyTopGroups, StackUtil.getShortStackTrace());
        Stream<MapGroupEntity> groupModelStream = this.getUnsortedGroupEntitiesStream(realm);
        if (onlyTopGroups.booleanValue()) {
            groupModelStream = groupModelStream.filter(groupEntity -> Objects.isNull(groupEntity.getParentId()));
        }
        return groupModelStream.count();
    }

    public Long getGroupsCountByNameContaining(RealmModel realm, String search) {
        return this.searchForGroupByNameStream(realm, search, null, null).count();
    }

    public Stream<GroupModel> getGroupsByRoleStream(RealmModel realm, RoleModel role, Integer firstResult, Integer maxResults) {
        LOG.tracef("getGroupsByRole(%s, %s, %d, %d)%s", new Object[]{realm, role, firstResult, maxResults, StackUtil.getShortStackTrace()});
        Stream<GroupModel> groupModelStream = this.getGroupsStream(realm).filter(groupModel -> groupModel.hasRole(role));
        if (firstResult != null && firstResult > 0) {
            groupModelStream = groupModelStream.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            groupModelStream = groupModelStream.limit(maxResults.intValue());
        }
        return groupModelStream;
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm) {
        LOG.tracef("getTopLevelGroupsStream(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        return this.getGroupsStream(realm).filter(groupModel -> Objects.isNull(groupModel.getParentId()));
    }

    public Stream<GroupModel> getTopLevelGroupsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        Stream<GroupModel> groupModelStream = this.getTopLevelGroupsStream(realm);
        if (firstResult != null && firstResult > 0) {
            groupModelStream = groupModelStream.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            groupModelStream = groupModelStream.limit(maxResults.intValue());
        }
        return groupModelStream;
    }

    public Stream<GroupModel> searchForGroupByNameStream(RealmModel realm, String search, Integer firstResult, Integer maxResults) {
        LOG.tracef("searchForGroupByNameStream(%s, %s, %d, %d)%s", new Object[]{realm, search, firstResult, maxResults, StackUtil.getShortStackTrace()});
        Stream<GroupModel> groupModelStream = this.getGroupsStream(realm).filter(groupModel -> groupModel.getName().contains(search));
        if (firstResult != null && firstResult > 0) {
            groupModelStream = groupModelStream.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            groupModelStream = groupModelStream.limit(maxResults.intValue());
        }
        return groupModelStream;
    }

    public GroupModel createGroup(RealmModel realm, String id, String name, GroupModel toParent) {
        UUID entityId;
        LOG.tracef("createGroup(%s, %s, %s, %s)%s", new Object[]{realm, id, name, toParent, StackUtil.getShortStackTrace()});
        UUID uUID = entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        if (this.getUnsortedGroupEntitiesStream(realm).anyMatch(groupEntity -> Objects.equals(groupEntity.getParentId(), toParent == null ? null : toParent.getId()) && Objects.equals(groupEntity.getName(), name))) {
            throw new ModelDuplicateException("Group with name '" + name + "' in realm " + realm.getName() + " already exists for requested parent");
        }
        MapGroupEntity entity = new MapGroupEntity(entityId, realm.getId());
        entity.setName(name);
        entity.setParentId(toParent == null ? null : toParent.getId());
        if (this.tx.get((UUID)entity.getId(), this.groupStore::get) != null) {
            throw new ModelDuplicateException("Group exists: " + entityId);
        }
        this.tx.putIfAbsent((UUID)entity.getId(), entity);
        return this.entityToAdapterFunc(realm).apply(entity);
    }

    public boolean removeGroup(final RealmModel realm, final GroupModel group) {
        LOG.tracef("removeGroup(%s, %s)%s", (Object)realm, (Object)group, StackUtil.getShortStackTrace());
        if (group == null) {
            return false;
        }
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new GroupModel.GroupRemovedEvent(){

            public RealmModel getRealm() {
                return realm;
            }

            public GroupModel getGroup() {
                return group;
            }

            public KeycloakSession getKeycloakSession() {
                return MapGroupProvider.this.session;
            }
        });
        this.session.users().preRemove(realm, group);
        realm.removeDefaultGroup(group);
        group.getSubGroupsStream().forEach(subGroup -> this.session.groups().removeGroup(realm, subGroup));
        this.tx.remove(UUID.fromString(group.getId()));
        return true;
    }

    public void moveGroup(RealmModel realm, GroupModel group, GroupModel toParent) {
        LOG.tracef("moveGroup(%s, %s, %s)%s", new Object[]{realm, group, toParent, StackUtil.getShortStackTrace()});
        if (toParent != null && group.getId().equals(toParent.getId())) {
            return;
        }
        String parentId = toParent == null ? null : toParent.getId();
        Stream<MapGroupEntity> possibleSiblings = this.getUnsortedGroupEntitiesStream(realm).filter(mapGroupEntity -> Objects.equals(mapGroupEntity.getParentId(), parentId));
        if (possibleSiblings.map(AbstractGroupEntity::getName).anyMatch(Predicate.isEqual(group.getName()))) {
            throw new ModelDuplicateException("Parent already contains subgroup named '" + group.getName() + "'");
        }
        if (group.getParentId() != null) {
            group.getParent().removeChild(group);
        }
        group.setParent(toParent);
        if (toParent != null) {
            toParent.addChild(group);
        }
    }

    public void addTopLevelGroup(RealmModel realm, GroupModel subGroup) {
        LOG.tracef("addTopLevelGroup(%s, %s)%s", (Object)realm, (Object)subGroup, StackUtil.getShortStackTrace());
        Stream<MapGroupEntity> possibleSiblings = this.getUnsortedGroupEntitiesStream(realm).filter(mapGroupEntity -> mapGroupEntity.getParentId() == null);
        if (possibleSiblings.map(AbstractGroupEntity::getName).anyMatch(Predicate.isEqual(subGroup.getName()))) {
            throw new ModelDuplicateException("There is already a top level group named '" + subGroup.getName() + "'");
        }
        subGroup.setParent(null);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        LOG.tracef("preRemove(%s, %s)%s", (Object)realm, (Object)role, StackUtil.getShortStackTrace());
        String roleId = role.getId();
        this.getUnsortedGroupEntitiesStream(realm).filter(groupEntity -> groupEntity.getGrantedRoles().contains(roleId)).map(groupEntity -> this.session.groups().getGroupById(realm, ((UUID)groupEntity.getId()).toString())).forEach(groupModel -> groupModel.deleteRoleMapping(role));
    }

    public void close() {
    }
}

