/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.client.MapClientProvider;
import org.keycloak.models.map.common.AbstractMapProviderFactory;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;

public class MapClientProviderFactory
extends AbstractMapProviderFactory<ClientProvider>
implements ClientProviderFactory {
    private final ConcurrentHashMap<UUID, ConcurrentMap<String, Integer>> REGISTERED_NODES_STORE = new ConcurrentHashMap();
    private MapStorage<UUID, MapClientEntity> store;

    @Override
    public void postInit(KeycloakSessionFactory factory) {
        MapStorageProvider sp = (MapStorageProvider)factory.getProviderFactory(MapStorageProvider.class);
        this.store = sp.getStorage("clients", UUID.class, MapClientEntity.class, new MapStorageProvider.Flag[0]);
    }

    public ClientProvider create(KeycloakSession session) {
        return new MapClientProvider(session, this.store, this.REGISTERED_NODES_STORE);
    }
}

