/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.client;

import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.map.client.AbstractClientEntity;
import org.keycloak.models.map.client.MapClientAdapter;
import org.keycloak.models.map.client.MapClientEntity;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.storage.MapKeycloakTransaction;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.provider.ProviderEvent;

public class MapClientProvider
implements ClientProvider {
    private static final Logger LOG = Logger.getLogger(MapClientProvider.class);
    private static final Predicate<MapClientEntity> ALWAYS_FALSE = c -> false;
    private final KeycloakSession session;
    final MapKeycloakTransaction<UUID, MapClientEntity> tx;
    private final MapStorage<UUID, MapClientEntity> clientStore;
    private final ConcurrentMap<UUID, ConcurrentMap<String, Integer>> clientRegisteredNodesStore;
    private static final Comparator<MapClientEntity> COMPARE_BY_CLIENT_ID = new Comparator<MapClientEntity>(){

        @Override
        public int compare(MapClientEntity o1, MapClientEntity o2) {
            String c2;
            String c1 = o1 == null ? null : o1.getClientId();
            String string = c2 = o2 == null ? null : o2.getClientId();
            return c1 == c2 ? 0 : (c1 == null ? -1 : (c2 == null ? 1 : c1.compareTo(c2)));
        }
    };

    public MapClientProvider(KeycloakSession session, MapStorage<UUID, MapClientEntity> clientStore, ConcurrentMap<UUID, ConcurrentMap<String, Integer>> clientRegisteredNodesStore) {
        this.session = session;
        this.clientStore = clientStore;
        this.clientRegisteredNodesStore = clientRegisteredNodesStore;
        this.tx = new MapKeycloakTransaction<UUID, MapClientEntity>(clientStore);
        session.getTransactionManager().enlist(this.tx);
    }

    private ClientModel.ClientUpdatedEvent clientUpdatedEvent(final ClientModel c) {
        return new ClientModel.ClientUpdatedEvent(){

            public ClientModel getUpdatedClient() {
                return c;
            }

            public KeycloakSession getKeycloakSession() {
                return MapClientProvider.this.session;
            }
        };
    }

    private MapClientEntity registerEntityForChanges(MapClientEntity origEntity) {
        MapClientEntity res = this.tx.get((UUID)origEntity.getId(), id -> Serialization.from(origEntity));
        this.tx.putIfChanged((UUID)origEntity.getId(), res, AbstractClientEntity::isUpdated);
        return res;
    }

    private Function<MapClientEntity, ClientModel> entityToAdapterFunc(RealmModel realm) {
        return origEntity -> new MapClientAdapter(this.session, realm, this.registerEntityForChanges((MapClientEntity)origEntity), (MapClientEntity)origEntity){
            final /* synthetic */ MapClientEntity val$origEntity;
            {
                this.val$origEntity = mapClientEntity;
                super(session, realm, entity);
            }

            public void updateClient() {
                LOG.tracef("updateClient(%s)%s", (Object)this.realm, this.val$origEntity.getId(), StackUtil.getShortStackTrace());
                this.session.getKeycloakSessionFactory().publish((ProviderEvent)MapClientProvider.this.clientUpdatedEvent(this));
            }

            public Map<String, Integer> getRegisteredNodes() {
                return MapClientProvider.this.clientRegisteredNodesStore.computeIfAbsent(((MapClientEntity)this.entity).getId(), k -> new ConcurrentHashMap());
            }

            public void registerNode(String nodeHost, int registrationTime) {
                Map<String, Integer> value = this.getRegisteredNodes();
                value.put(nodeHost, registrationTime);
            }

            public void unregisterNode(String nodeHost) {
                this.getRegisteredNodes().remove(nodeHost);
            }
        };
    }

    private Predicate<MapClientEntity> entityRealmFilter(RealmModel realm) {
        if (realm == null || realm.getId() == null) {
            return ALWAYS_FALSE;
        }
        String realmId = realm.getId();
        return entity -> Objects.equals(realmId, entity.getRealmId());
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm, Integer firstResult, Integer maxResults) {
        Stream<ClientModel> s = this.getClientsStream(realm);
        if (firstResult != null && firstResult >= 0) {
            s = s.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            s = s.limit(maxResults.intValue());
        }
        return s;
    }

    private Stream<MapClientEntity> getNotRemovedUpdatedClientsStream() {
        Stream<MapClientEntity> updatedAndNotRemovedClientsStream = this.clientStore.entrySet().stream().map(this.tx::getUpdated).filter(Objects::nonNull);
        return Stream.concat(this.tx.createdValuesStream(), updatedAndNotRemovedClientsStream);
    }

    public Stream<ClientModel> getClientsStream(RealmModel realm) {
        return this.getNotRemovedUpdatedClientsStream().filter(this.entityRealmFilter(realm)).sorted(COMPARE_BY_CLIENT_ID).map(this.entityToAdapterFunc(realm));
    }

    public ClientModel addClient(RealmModel realm, String id, String clientId) {
        UUID entityId;
        UUID uUID = entityId = id == null ? UUID.randomUUID() : UUID.fromString(id);
        if (clientId == null) {
            clientId = entityId.toString();
        }
        LOG.tracef("addClient(%s, %s, %s)%s", new Object[]{realm, id, clientId, StackUtil.getShortStackTrace()});
        MapClientEntity entity = new MapClientEntity(entityId, realm.getId());
        entity.setClientId(clientId);
        entity.setEnabled(true);
        entity.setStandardFlowEnabled(true);
        if (this.tx.get((UUID)entity.getId(), this.clientStore::get) != null) {
            throw new ModelDuplicateException("Client exists: " + id);
        }
        this.tx.putIfAbsent((UUID)entity.getId(), entity);
        ClientModel resource = this.entityToAdapterFunc(realm).apply(entity);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)((ClientModel.ClientCreationEvent)() -> resource));
        resource.updateClient();
        return resource;
    }

    public Stream<ClientModel> getAlwaysDisplayInConsoleClientsStream(RealmModel realm) {
        return this.getClientsStream(realm).filter(ClientModel::isAlwaysDisplayInConsole);
    }

    public void removeClients(RealmModel realm) {
        LOG.tracef("removeClients(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.getClientsStream(realm).map(ClientModel::getId).collect(Collectors.toSet()).forEach(cid -> this.removeClient(realm, (String)cid));
    }

    public boolean removeClient(RealmModel realm, String id) {
        if (id == null) {
            return false;
        }
        LOG.tracef("removeClient(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        final ClientModel client = this.getClientById(realm, id);
        if (client == null) {
            return false;
        }
        this.session.users().preRemove(realm, client);
        this.session.roles().removeRoles(client);
        this.session.getKeycloakSessionFactory().publish((ProviderEvent)new ClientModel.ClientRemovedEvent(){

            public ClientModel getClient() {
                return client;
            }

            public KeycloakSession getKeycloakSession() {
                return MapClientProvider.this.session;
            }
        });
        this.tx.remove(UUID.fromString(id));
        return true;
    }

    public long getClientsCount(RealmModel realm) {
        return this.getNotRemovedUpdatedClientsStream().filter(this.entityRealmFilter(realm)).count();
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        if (id == null) {
            return null;
        }
        LOG.tracef("getClientById(%s, %s)%s", (Object)realm, (Object)id, StackUtil.getShortStackTrace());
        MapClientEntity entity = this.tx.get(UUID.fromString(id), this.clientStore::get);
        return entity == null || !this.entityRealmFilter(realm).test(entity) ? null : this.entityToAdapterFunc(realm).apply(entity);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        if (clientId == null) {
            return null;
        }
        LOG.tracef("getClientByClientId(%s, %s)%s", (Object)realm, (Object)clientId, StackUtil.getShortStackTrace());
        String clientIdLower = clientId.toLowerCase();
        return this.getNotRemovedUpdatedClientsStream().filter(this.entityRealmFilter(realm)).filter(entity -> entity.getClientId() != null && Objects.equals(entity.getClientId().toLowerCase(), clientIdLower)).map(this.entityToAdapterFunc(realm)).findFirst().orElse(null);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        if (clientId == null) {
            return Stream.empty();
        }
        String clientIdLower = clientId.toLowerCase();
        Stream<MapClientEntity> s = this.getNotRemovedUpdatedClientsStream().filter(this.entityRealmFilter(realm)).filter(entity -> entity.getClientId() != null && entity.getClientId().toLowerCase().contains(clientIdLower)).sorted(COMPARE_BY_CLIENT_ID);
        if (firstResult != null && firstResult >= 0) {
            s = s.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            s = s.limit(maxResults.intValue());
        }
        return s.map(this.entityToAdapterFunc(realm));
    }

    public void close() {
    }
}

