/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.authSession;

import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.map.authSession.MapAuthenticationSessionEntity;
import org.keycloak.models.map.authSession.MapRootAuthenticationSessionAdapter;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.CommonClientSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;

public class MapAuthenticationSessionAdapter
implements AuthenticationSessionModel {
    private final KeycloakSession session;
    private final MapRootAuthenticationSessionAdapter parent;
    private final String tabId;
    private MapAuthenticationSessionEntity entity;

    public MapAuthenticationSessionAdapter(KeycloakSession session, MapRootAuthenticationSessionAdapter parent, String tabId, MapAuthenticationSessionEntity entity) {
        this.session = session;
        this.parent = parent;
        this.tabId = tabId;
        this.entity = entity;
    }

    public String getTabId() {
        return this.tabId;
    }

    public RootAuthenticationSessionModel getParentSession() {
        return this.parent;
    }

    public Map<String, CommonClientSessionModel.ExecutionStatus> getExecutionStatus() {
        return this.entity.getExecutionStatus();
    }

    public void setExecutionStatus(String authenticator, CommonClientSessionModel.ExecutionStatus status) {
        Objects.requireNonNull(authenticator, "The provided authenticator can't be null!");
        Objects.requireNonNull(status, "The provided execution status can't be null!");
        this.parent.setUpdated(!Objects.equals(this.entity.getExecutionStatus().put(authenticator, status), status));
    }

    public void clearExecutionStatus() {
        this.parent.setUpdated(!this.entity.getExecutionStatus().isEmpty());
        this.entity.getExecutionStatus().clear();
    }

    public UserModel getAuthenticatedUser() {
        return this.entity.getAuthUserId() == null ? null : this.session.users().getUserById(this.entity.getAuthUserId(), this.getRealm());
    }

    public void setAuthenticatedUser(UserModel user) {
        String userId = user == null ? null : user.getId();
        this.parent.setUpdated(!Objects.equals(userId, this.entity.getAuthUserId()));
        this.entity.setAuthUserId(userId);
    }

    public Set<String> getRequiredActions() {
        return new HashSet<String>(this.entity.getRequiredActions());
    }

    public void addRequiredAction(String action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.parent.setUpdated(this.entity.getRequiredActions().add(action));
    }

    public void removeRequiredAction(String action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.parent.setUpdated(this.entity.getRequiredActions().remove(action));
    }

    public void addRequiredAction(UserModel.RequiredAction action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.addRequiredAction(action.name());
    }

    public void removeRequiredAction(UserModel.RequiredAction action) {
        Objects.requireNonNull(action, "The provided action can't be null!");
        this.removeRequiredAction(action.name());
    }

    public void setUserSessionNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.parent.setUpdated(this.entity.getUserSessionNotes().remove(name) != null);
            } else {
                this.parent.setUpdated(!Objects.equals(this.entity.getUserSessionNotes().put(name, value), value));
            }
        }
    }

    public Map<String, String> getUserSessionNotes() {
        return new ConcurrentHashMap<String, String>(this.entity.getUserSessionNotes());
    }

    public void clearUserSessionNotes() {
        this.parent.setUpdated(!this.entity.getUserSessionNotes().isEmpty());
        this.entity.getUserSessionNotes().clear();
    }

    public String getAuthNote(String name) {
        return name != null ? this.entity.getAuthNotes().get(name) : null;
    }

    public void setAuthNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.parent.setUpdated(this.entity.getAuthNotes().remove(name) != null);
            } else {
                this.parent.setUpdated(!Objects.equals(this.entity.getAuthNotes().put(name, value), value));
            }
        }
    }

    public void removeAuthNote(String name) {
        if (name != null) {
            this.parent.setUpdated(this.entity.getAuthNotes().remove(name) != null);
        }
    }

    public void clearAuthNotes() {
        this.parent.setUpdated(!this.entity.getAuthNotes().isEmpty());
        this.entity.getAuthNotes().clear();
    }

    public String getClientNote(String name) {
        return name != null ? this.entity.getClientNotes().get(name) : null;
    }

    public void setClientNote(String name, String value) {
        if (name != null) {
            if (value == null) {
                this.parent.setUpdated(this.entity.getClientNotes().remove(name) != null);
            } else {
                this.parent.setUpdated(!Objects.equals(this.entity.getClientNotes().put(name, value), value));
            }
        }
    }

    public void removeClientNote(String name) {
        if (name != null) {
            this.parent.setUpdated(this.entity.getClientNotes().remove(name) != null);
        }
    }

    public Map<String, String> getClientNotes() {
        return new ConcurrentHashMap<String, String>(this.entity.getClientNotes());
    }

    public void clearClientNotes() {
        this.parent.setUpdated(!this.entity.getClientNotes().isEmpty());
        this.entity.getClientNotes().clear();
    }

    public Set<String> getClientScopes() {
        return new HashSet<String>(this.entity.getClientScopes());
    }

    public void setClientScopes(Set<String> clientScopes) {
        Objects.requireNonNull(clientScopes, "The provided client scopes set can't be null!");
        this.parent.setUpdated(!Objects.equals(this.entity.getClientScopes(), clientScopes));
        this.entity.setClientScopes(new HashSet<String>(clientScopes));
    }

    public String getRedirectUri() {
        return this.entity.getRedirectUri();
    }

    public void setRedirectUri(String uri) {
        this.parent.setUpdated(!Objects.equals(this.entity.getRedirectUri(), uri));
        this.entity.setRedirectUri(uri);
    }

    public RealmModel getRealm() {
        return this.parent.getRealm();
    }

    public ClientModel getClient() {
        return this.parent.getRealm().getClientById(this.entity.getClientUUID());
    }

    public String getAction() {
        return this.entity.getAction();
    }

    public void setAction(String action) {
        this.parent.setUpdated(!Objects.equals(this.entity.getAction(), action));
        this.entity.setAction(action);
    }

    public String getProtocol() {
        return this.entity.getProtocol();
    }

    public void setProtocol(String method) {
        this.parent.setUpdated(!Objects.equals(this.entity.getProtocol(), method));
        this.entity.setProtocol(method);
    }
}

