/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.map.common.AbstractEntity;
import org.keycloak.models.map.common.Serialization;
import org.keycloak.models.map.storage.MapStorage;
import org.keycloak.models.map.storage.MapStorageProvider;

public class ConcurrentHashMapStorageProvider
implements MapStorageProvider {
    private static final String PROVIDER_ID = "concurrenthashmap";
    private static final Logger LOG = Logger.getLogger(ConcurrentHashMapStorageProvider.class);
    private final ConcurrentHashMap<String, ConcurrentHashMap<?, ?>> storages = new ConcurrentHashMap();
    private File storageDirectory;

    public MapStorageProvider create(KeycloakSession session) {
        return this;
    }

    public void init(Config.Scope config) {
        File f = new File(config.get("dir"));
        try {
            this.storageDirectory = f.exists() ? f : Files.createTempDirectory("storage-map-chm-", new FileAttribute[0]).toFile();
        }
        catch (IOException ex) {
            this.storageDirectory = null;
        }
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        this.storages.forEach(this::storeMap);
    }

    private void storeMap(String fileName, ConcurrentHashMap<?, ?> store) {
        if (fileName != null) {
            File f = this.getFile(fileName);
            try {
                if (this.storageDirectory != null && this.storageDirectory.exists()) {
                    LOG.debugf("Storing contents to %s", (Object)f.getCanonicalPath());
                    Serialization.MAPPER.writeValue(f, store.values());
                } else {
                    LOG.debugf("Not storing contents of %s because directory %s does not exist", (Object)fileName, (Object)this.storageDirectory);
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private <K, V extends AbstractEntity<K>> ConcurrentHashMapStorage<?, V> loadMap(String fileName, Class<V> valueType, EnumSet<MapStorageProvider.Flag> flags) {
        File f;
        ConcurrentHashMapStorage store = new ConcurrentHashMapStorage();
        if (!flags.contains((Object)MapStorageProvider.Flag.INITIALIZE_EMPTY) && (f = this.getFile(fileName)) != null && f.exists()) {
            try {
                LOG.debugf("Restoring contents from %s", (Object)f.getCanonicalPath());
                CollectionType type = Serialization.MAPPER.getTypeFactory().constructCollectionType(List.class, valueType);
                List values = (List)Serialization.MAPPER.readValue(f, (JavaType)type);
                values.forEach(mce -> store.put(mce.getId(), mce));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return store;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    @Override
    public <K, V extends AbstractEntity<K>> MapStorage<K, V> getStorage(String name, Class<K> keyType, Class<V> valueType, MapStorageProvider.Flag ... flags) {
        EnumSet<MapStorageProvider.Flag> f = flags == null || flags.length == 0 ? EnumSet.noneOf(MapStorageProvider.Flag.class) : EnumSet.of(flags[0], flags);
        return (MapStorage)((Object)this.storages.computeIfAbsent(name, n -> this.loadMap(name, valueType, f)));
    }

    private File getFile(String fileName) {
        return this.storageDirectory == null ? null : new File(this.storageDirectory, "map-" + fileName + ".json");
    }

    private static class ConcurrentHashMapStorage<K, V>
    extends ConcurrentHashMap<K, V>
    implements MapStorage<K, V> {
        private ConcurrentHashMapStorage() {
        }
    }
}

