/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.store;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Optional;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;
import org.keycloak.models.map.storage.ldap.store.LdapMapUtil;
import org.keycloak.truststore.TruststoreProvider;
import org.keycloak.vault.VaultCharSecret;

public final class LdapMapContextManager
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LdapMapContextManager.class);
    private final KeycloakSession session;
    private final LdapMapConfig ldapMapConfig;
    private StartTlsResponse tlsResponse;
    private VaultCharSecret vaultCharSecret = new VaultCharSecret(){

        public Optional<CharBuffer> get() {
            return Optional.empty();
        }

        public Optional<char[]> getAsArray() {
            return Optional.empty();
        }

        public void close() {
        }
    };
    private LdapContext ldapContext;

    public LdapMapContextManager(KeycloakSession session, LdapMapConfig connectionProperties) {
        this.session = session;
        this.ldapMapConfig = connectionProperties;
    }

    public static LdapMapContextManager create(KeycloakSession session, LdapMapConfig connectionProperties) {
        return new LdapMapContextManager(session, connectionProperties);
    }

    private void createLdapContext() throws NamingException {
        Hashtable<Object, Object> connProp = this.getConnectionProperties(this.ldapMapConfig);
        if (!"none".equals(this.ldapMapConfig.getAuthType())) {
            this.vaultCharSecret = this.getVaultSecret();
            if (this.vaultCharSecret != null && !this.ldapMapConfig.isStartTls()) {
                connProp.put("java.naming.security.credentials", this.vaultCharSecret.getAsArray().orElse(this.ldapMapConfig.getBindCredential().toCharArray()));
            }
        }
        this.ldapContext = new InitialLdapContext(connProp, null);
        if (this.ldapMapConfig.isStartTls()) {
            SSLSocketFactory sslSocketFactory = null;
            if (LdapMapUtil.shouldUseTruststoreSpi(this.ldapMapConfig)) {
                TruststoreProvider provider = (TruststoreProvider)this.session.getProvider(TruststoreProvider.class);
                sslSocketFactory = provider.getSSLSocketFactory();
            }
            this.tlsResponse = LdapMapContextManager.startTLS(this.ldapContext, this.ldapMapConfig.getAuthType(), this.ldapMapConfig.getBindDN(), this.vaultCharSecret.getAsArray().orElse(this.ldapMapConfig.getBindCredential().toCharArray()), sslSocketFactory);
            if (this.tlsResponse == null) {
                throw new NamingException("Wasn't able to establish LDAP connection through StartTLS");
            }
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        if (this.ldapContext == null) {
            this.createLdapContext();
        }
        return this.ldapContext;
    }

    private VaultCharSecret getVaultSecret() {
        return "none".equals(this.ldapMapConfig.getAuthType()) ? null : this.session.vault().getCharSecret(this.ldapMapConfig.getBindCredential());
    }

    public static StartTlsResponse startTLS(LdapContext ldapContext, String authType, String bindDN, char[] bindCredential, SSLSocketFactory sslSocketFactory) throws NamingException {
        StartTlsResponse tls;
        try {
            tls = (StartTlsResponse)ldapContext.extendedOperation(new StartTlsRequest());
            tls.negotiate(sslSocketFactory);
            ldapContext.addToEnvironment("java.naming.security.authentication", authType);
            if (!"none".equals(authType)) {
                ldapContext.addToEnvironment("java.naming.security.principal", bindDN);
                ldapContext.addToEnvironment("java.naming.security.credentials", bindCredential);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Could not negotiate TLS", (Throwable)e);
            throw new AuthenticationException("Could not negotiate TLS");
        }
        ldapContext.lookup("");
        return tls;
    }

    private Hashtable<Object, Object> getConnectionProperties(LdapMapConfig ldapMapConfig) {
        Hashtable<Object, Object> env = LdapMapContextManager.getNonAuthConnectionProperties(ldapMapConfig);
        if (!ldapMapConfig.isStartTls()) {
            String authType = ldapMapConfig.getAuthType();
            env.put("java.naming.security.authentication", authType);
            String bindDN = ldapMapConfig.getBindDN();
            char[] bindCredential = null;
            if (ldapMapConfig.getBindCredential() != null) {
                bindCredential = ldapMapConfig.getBindCredential().toCharArray();
            }
            if (!"none".equals(authType)) {
                env.put("java.naming.security.principal", bindDN);
                env.put("java.naming.security.credentials", bindCredential);
            }
        }
        if (logger.isTraceEnabled()) {
            Hashtable<Object, Object> copyEnv = new Hashtable<Object, Object>(env);
            if (copyEnv.containsKey("java.naming.security.credentials")) {
                copyEnv.put("java.naming.security.credentials", "**************************************");
            }
            logger.tracef("Creating LdapContext using properties: [%s]", copyEnv);
        }
        return env;
    }

    public static Hashtable<Object, Object> getNonAuthConnectionProperties(LdapMapConfig ldapMapConfig) {
        Properties additionalProperties;
        String readTimeout;
        String connectionTimeout;
        String connectionPooling;
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", ldapMapConfig.getFactoryName());
        String url = ldapMapConfig.getConnectionUrl();
        if (url != null) {
            env.put("java.naming.provider.url", url);
        } else {
            logger.warn((Object)"LDAP URL is null. LDAPOperationManager won't work correctly");
        }
        if (LdapMapUtil.shouldUseTruststoreSpi(ldapMapConfig)) {
            env.put("java.naming.ldap.factory.socket", "org.keycloak.truststore.SSLSocketFactory");
        }
        if ((connectionPooling = ldapMapConfig.getConnectionPooling()) != null) {
            env.put("com.sun.jndi.ldap.connect.pool", connectionPooling);
        }
        if ((connectionTimeout = ldapMapConfig.getConnectionTimeout()) != null && !connectionTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.connect.timeout", connectionTimeout);
        }
        if ((readTimeout = ldapMapConfig.getReadTimeout()) != null && !readTimeout.isEmpty()) {
            env.put("com.sun.jndi.ldap.read.timeout", readTimeout);
        }
        if ((additionalProperties = ldapMapConfig.getAdditionalConnectionProperties()) != null) {
            for (Object object : additionalProperties.keySet()) {
                env.put(object.toString(), additionalProperties.getProperty(object.toString()));
            }
        }
        StringBuilder binaryAttrsBuilder = new StringBuilder();
        if (ldapMapConfig.isObjectGUID()) {
            binaryAttrsBuilder.append("objectGUID").append(" ");
        }
        if (ldapMapConfig.isEdirectory()) {
            binaryAttrsBuilder.append("guid").append(" ");
        }
        for (String attrName : ldapMapConfig.getBinaryAttributeNames()) {
            binaryAttrsBuilder.append(attrName).append(" ");
        }
        String string = binaryAttrsBuilder.toString().trim();
        if (!string.isEmpty()) {
            env.put("java.naming.ldap.attributes.binary", string);
        }
        return new Hashtable<Object, Object>(env);
    }

    @Override
    public void close() {
        if (this.vaultCharSecret != null) {
            this.vaultCharSecret.close();
        }
        if (this.tlsResponse != null) {
            try {
                this.tlsResponse.close();
            }
            catch (IOException e) {
                logger.error((Object)"Could not close Ldap tlsResponse.", (Throwable)e);
            }
        }
        if (this.ldapContext != null) {
            try {
                this.ldapContext.close();
            }
            catch (NamingException e) {
                logger.error((Object)"Could not close Ldap context.", (Throwable)e);
            }
        }
    }
}

