/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.role.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang.NotImplementedException;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.EntityField;
import org.keycloak.models.map.common.UpdatableEntity;
import org.keycloak.models.map.common.delegate.EntityFieldDelegate;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.role.MapRoleEntityFields;
import org.keycloak.models.map.storage.ldap.model.LdapMapDn;
import org.keycloak.models.map.storage.ldap.model.LdapMapObject;
import org.keycloak.models.map.storage.ldap.role.LdapRoleMapStorage;
import org.keycloak.models.map.storage.ldap.role.config.LdapMapRoleMapperConfig;

public class LdapRoleEntity
extends UpdatableEntity.Impl
implements EntityFieldDelegate<MapRoleEntity> {
    private final LdapMapObject ldapMapObject;
    private final LdapMapRoleMapperConfig roleMapperConfig;
    private final LdapRoleMapStorage store;
    private final String clientId;
    private static final EnumMap<MapRoleEntityFields, BiConsumer<LdapRoleEntity, Object>> SETTERS = new EnumMap(MapRoleEntityFields.class);
    private static final EnumMap<MapRoleEntityFields, Function<LdapRoleEntity, Object>> GETTERS;
    private static final EnumMap<MapRoleEntityFields, BiConsumer<LdapRoleEntity, Object>> ADDERS;
    private static final EnumMap<MapRoleEntityFields, BiFunction<LdapRoleEntity, Object, Object>> REMOVERS;

    public LdapRoleEntity(DeepCloner cloner, LdapMapRoleMapperConfig roleMapperConfig, LdapRoleMapStorage store, String clientId) {
        this.ldapMapObject = new LdapMapObject();
        this.ldapMapObject.setObjectClasses(Arrays.asList("top", "groupOfNames"));
        this.ldapMapObject.setRdnAttributeName(roleMapperConfig.getRoleNameLdapAttribute());
        this.roleMapperConfig = roleMapperConfig;
        this.store = store;
        this.clientId = clientId;
    }

    public LdapRoleEntity(LdapMapObject ldapMapObject, LdapMapRoleMapperConfig roleMapperConfig, LdapRoleMapStorage store, String clientId) {
        this.ldapMapObject = ldapMapObject;
        this.roleMapperConfig = roleMapperConfig;
        this.store = store;
        this.clientId = clientId;
    }

    public String getId() {
        return this.ldapMapObject.getId();
    }

    public void setId(String id) {
        this.updated |= !Objects.equals(this.getId(), id);
        this.ldapMapObject.setId(id);
    }

    public Map<String, List<String>> getAttributes() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String roleAttribute : this.roleMapperConfig.getRoleAttributes()) {
            Set<String> attrs = this.ldapMapObject.getAttributeAsSet(roleAttribute);
            if (attrs == null) continue;
            result.put(roleAttribute, new ArrayList<String>(attrs));
        }
        return result;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        if (attributes != null) {
            attributes.forEach(this::setAttribute);
        }
        for (String roleAttribute : this.roleMapperConfig.getRoleAttributes()) {
            if (attributes != null && attributes.containsKey(roleAttribute)) continue;
            this.removeAttribute(roleAttribute);
        }
    }

    public List<String> getAttribute(String name) {
        if (!this.roleMapperConfig.getRoleAttributes().contains(name)) {
            throw new ModelException("can't read attribute '" + name + "' as it is not supported");
        }
        return new ArrayList<String>(this.ldapMapObject.getAttributeAsSet(name));
    }

    public void setAttribute(String name, List<String> value) {
        if (!this.roleMapperConfig.getRoleAttributes().contains(name)) {
            throw new ModelException("can't set attribute '" + name + "' as it is not supported");
        }
        if (this.ldapMapObject.getAttributeAsSet(name) == null && (value == null || value.size() == 0) || Objects.equals(this.ldapMapObject.getAttributeAsSet(name), new HashSet<String>(value))) {
            return;
        }
        if (this.ldapMapObject.getReadOnlyAttributeNames().contains(name)) {
            throw new ModelException("can't write attribute '" + name + "' as it is not writeable");
        }
        this.ldapMapObject.setAttribute(name, new HashSet<String>(value));
        this.updated = true;
    }

    public void removeAttribute(String name) {
        if (!this.roleMapperConfig.getRoleAttributes().contains(name)) {
            throw new ModelException("can't write attribute '" + name + "' as it is not supported");
        }
        if (this.ldapMapObject.getAttributeAsSet(name) == null || this.ldapMapObject.getAttributeAsSet(name).size() == 0) {
            return;
        }
        this.ldapMapObject.setAttribute(name, null);
        this.updated = true;
    }

    public String getRealmId() {
        return null;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getName() {
        return this.ldapMapObject.getAttributeAsString(this.roleMapperConfig.getRoleNameLdapAttribute());
    }

    public String getDescription() {
        return this.ldapMapObject.getAttributeAsString("description");
    }

    public void setRealmId(String realmId) {
    }

    public void setClientId(String clientId) {
        if (!Objects.equals(this.getClientId(), clientId)) {
            throw new NotImplementedException();
        }
    }

    public void setName(String name) {
        this.updated |= !Objects.equals(this.getName(), name);
        this.ldapMapObject.setSingleAttribute(this.roleMapperConfig.getRoleNameLdapAttribute(), name);
        LdapMapDn dn = LdapMapDn.fromString(this.roleMapperConfig.getRolesDn(this.clientId));
        dn.addFirst(this.roleMapperConfig.getRoleNameLdapAttribute(), name);
        this.ldapMapObject.setDn(dn);
    }

    public void setDescription(String description) {
        this.updated |= !Objects.equals(this.getDescription(), description);
        if (description != null) {
            this.ldapMapObject.setSingleAttribute("description", description);
        } else if (this.getDescription() != null) {
            this.ldapMapObject.setAttribute("description", null);
        }
    }

    public Set<String> getCompositeRoles() {
        Set<String> members = this.ldapMapObject.getAttributeAsSet(this.roleMapperConfig.getMembershipLdapAttribute());
        if (members == null) {
            members = new HashSet<String>();
        }
        HashSet<String> compositeRoles = new HashSet<String>();
        for (String member : members) {
            if (member.equals(this.ldapMapObject.getDn().toString()) || !member.startsWith(this.roleMapperConfig.getRoleNameLdapAttribute())) continue;
            String roleId = this.store.readIdByDn(member);
            if (roleId == null) {
                throw new NotImplementedException();
            }
            compositeRoles.add(roleId);
        }
        return compositeRoles;
    }

    public void setCompositeRoles(Set<String> compositeRoles) {
        Set<String> members;
        HashSet<String> translatedCompositeRoles = new HashSet<String>();
        if (compositeRoles != null) {
            for (String compositeRole : compositeRoles) {
                LdapRoleEntity ldapRole = this.store.readLdap(compositeRole);
                translatedCompositeRoles.add(ldapRole.getLdapMapObject().getDn().toString());
            }
        }
        if ((members = this.ldapMapObject.getAttributeAsSet(this.roleMapperConfig.getMembershipLdapAttribute())) == null) {
            members = new HashSet<String>();
        }
        for (String member : members) {
            if (member.startsWith(this.roleMapperConfig.getRoleNameLdapAttribute())) continue;
            translatedCompositeRoles.add(member);
        }
        if (!translatedCompositeRoles.equals(members)) {
            this.ldapMapObject.setAttribute(this.roleMapperConfig.getMembershipLdapAttribute(), members);
            this.updated = true;
        }
    }

    public void addCompositeRole(String roleId) {
        LdapRoleEntity ldapRole = this.store.readLdap(roleId);
        Set<String> members = this.ldapMapObject.getAttributeAsSet(this.roleMapperConfig.getMembershipLdapAttribute());
        if (members == null) {
            members = new HashSet<String>();
        }
        members.add(ldapRole.getLdapMapObject().getDn().toString());
        this.ldapMapObject.setAttribute(this.roleMapperConfig.getMembershipLdapAttribute(), members);
        this.updated = true;
    }

    public void removeCompositeRole(String roleId) {
        LdapRoleEntity ldapRole = this.store.readLdap(roleId);
        Set<String> members = this.ldapMapObject.getAttributeAsSet(this.roleMapperConfig.getMembershipLdapAttribute());
        if (members == null) {
            members = new HashSet<String>();
        }
        members.remove(ldapRole.getLdapMapObject().getDn().toString());
        this.ldapMapObject.setAttribute(this.roleMapperConfig.getMembershipLdapAttribute(), members);
        this.updated = true;
    }

    public LdapMapObject getLdapMapObject() {
        return this.ldapMapObject;
    }

    public <T, EF extends Enum<? extends EntityField<MapRoleEntity>>> void set(EF field, T value) {
        BiConsumer<LdapRoleEntity, Object> consumer = SETTERS.get(field);
        if (consumer == null) {
            throw new ModelException("unsupported field for setters " + field);
        }
        consumer.accept(this, value);
    }

    public <T, EF extends Enum<? extends EntityField<MapRoleEntity>>> void collectionAdd(EF field, T value) {
        BiConsumer<LdapRoleEntity, Object> consumer = ADDERS.get(field);
        if (consumer == null) {
            throw new ModelException("unsupported field for setters " + field);
        }
        consumer.accept(this, value);
    }

    public <T, EF extends Enum<? extends EntityField<MapRoleEntity>>> Object collectionRemove(EF field, T value) {
        BiFunction<LdapRoleEntity, Object, Object> consumer = REMOVERS.get(field);
        if (consumer == null) {
            throw new ModelException("unsupported field for setters " + field);
        }
        return consumer.apply(this, value);
    }

    public <EF extends Enum<? extends EntityField<MapRoleEntity>>> Object get(EF field) {
        Function<LdapRoleEntity, Object> consumer = GETTERS.get(field);
        if (consumer == null) {
            throw new ModelException("unsupported field for getters " + field);
        }
        return consumer.apply(this);
    }

    public <K, EF extends Enum<? extends EntityField<MapRoleEntity>>> Object mapGet(EF field, K key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <K, T, EF extends Enum<? extends EntityField<MapRoleEntity>>> void mapPut(EF field, K key, T value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public <K, EF extends Enum<? extends EntityField<MapRoleEntity>>> Object mapRemove(EF field, K key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        SETTERS.put(MapRoleEntityFields.DESCRIPTION, (e, v) -> e.setDescription((String)v));
        SETTERS.put(MapRoleEntityFields.ID, (e, v) -> e.setId((String)v));
        SETTERS.put(MapRoleEntityFields.REALM_ID, (e, v) -> e.setRealmId((String)v));
        SETTERS.put(MapRoleEntityFields.CLIENT_ID, (e, v) -> e.setClientId((String)v));
        SETTERS.put(MapRoleEntityFields.ATTRIBUTES, (e, v) -> e.setAttributes((Map)v));
        SETTERS.put(MapRoleEntityFields.COMPOSITE_ROLES, (e, v) -> e.setCompositeRoles((Set)v));
        SETTERS.put(MapRoleEntityFields.NAME, (e, v) -> e.setName((String)v));
        GETTERS = new EnumMap(MapRoleEntityFields.class);
        GETTERS.put(MapRoleEntityFields.DESCRIPTION, LdapRoleEntity::getDescription);
        GETTERS.put(MapRoleEntityFields.ID, LdapRoleEntity::getId);
        GETTERS.put(MapRoleEntityFields.REALM_ID, LdapRoleEntity::getRealmId);
        GETTERS.put(MapRoleEntityFields.CLIENT_ID, LdapRoleEntity::getClientId);
        GETTERS.put(MapRoleEntityFields.ATTRIBUTES, LdapRoleEntity::getAttributes);
        GETTERS.put(MapRoleEntityFields.COMPOSITE_ROLES, LdapRoleEntity::getCompositeRoles);
        GETTERS.put(MapRoleEntityFields.NAME, LdapRoleEntity::getName);
        ADDERS = new EnumMap(MapRoleEntityFields.class);
        ADDERS.put(MapRoleEntityFields.COMPOSITE_ROLES, (e, v) -> e.addCompositeRole((String)v));
        REMOVERS = new EnumMap(MapRoleEntityFields.class);
        REMOVERS.put(MapRoleEntityFields.COMPOSITE_ROLES, (e, v) -> {
            e.removeCompositeRole((String)v);
            return null;
        });
    }
}

