/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.role.config;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.storage.ldap.config.LdapMapCommonGroupMapperConfig;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;
import org.keycloak.models.map.storage.ldap.model.LdapMapDn;

public class LdapMapRoleMapperConfig
extends LdapMapCommonGroupMapperConfig {
    private final Config.Scope config;
    private final LdapMapConfig ldapMapConfig;
    public static final String REALM_ROLES_DN = "roles.realm.dn";
    public static final String CLIENT_ROLES_DN = "roles.client.dn";
    public static final String COMMON_ROLES_DN = "roles.common.dn";
    public static final String ROLE_NAME_LDAP_ATTRIBUTE = "role.name.ldap.attribute";
    public static final String ROLE_OBJECT_CLASSES = "role.object.classes";
    public static final String ROLES_LDAP_FILTER = "roles.ldap.filter";
    public static final String LOAD_ROLES_BY_MEMBER_ATTRIBUTE = "LOAD_ROLES_BY_MEMBER_ATTRIBUTE";
    public static final String GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE = "GET_ROLES_FROM_USER_MEMBEROF_ATTRIBUTE";
    public static final String LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY = "LOAD_ROLES_BY_MEMBER_ATTRIBUTE_RECURSIVELY";

    public LdapMapRoleMapperConfig(final Config.Scope config) {
        super(new ComponentModel(){

            public MultivaluedHashMap<String, String> getConfig() {
                return new MultivaluedHashMap<String, String>(){

                    public String getFirst(String key) {
                        return config.get(key);
                    }
                };
            }
        });
        this.config = config;
        this.ldapMapConfig = new LdapMapConfig(config);
    }

    public String getRealmRolesDn() {
        String rolesDn = this.config.get(REALM_ROLES_DN);
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    public String getCommonRolesDn() {
        String rolesDn = this.config.get(COMMON_ROLES_DN);
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    public String getClientRolesDn() {
        String rolesDn = this.config.get(CLIENT_ROLES_DN);
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    public String getRolesDn(String clientId) {
        String rolesDn;
        boolean isClientRole;
        boolean bl = isClientRole = clientId != null;
        if (!isClientRole) {
            rolesDn = (String)this.mapperModel.getConfig().getFirst((Object)REALM_ROLES_DN);
        } else {
            rolesDn = this.config.get(CLIENT_ROLES_DN);
            if (rolesDn != null) {
                LdapMapDn dn = LdapMapDn.fromString(rolesDn);
                LdapMapDn.RDN firstRdn = dn.getFirstRdn();
                for (String key : firstRdn.getAllKeys()) {
                    firstRdn.setAttrValue(key, firstRdn.getAttrValue(key).replaceAll("\\{0}", Matcher.quoteReplacement(clientId)));
                }
                rolesDn = dn.toString();
            }
        }
        if (rolesDn == null) {
            throw new ModelException("Roles DN is null! Check your configuration");
        }
        return rolesDn;
    }

    public Set<String> getRoleAttributes() {
        String roleAttributes = (String)this.mapperModel.getConfig().getFirst((Object)"role.attributes");
        if (roleAttributes == null) {
            roleAttributes = "";
        }
        return new HashSet<String>(Arrays.asList(roleAttributes.trim().split("\\s+")));
    }

    public String getRoleNameLdapAttribute() {
        String rolesRdnAttr = (String)this.mapperModel.getConfig().getFirst((Object)ROLE_NAME_LDAP_ATTRIBUTE);
        return rolesRdnAttr != null ? rolesRdnAttr : "cn";
    }

    @Override
    public String getLDAPGroupNameLdapAttribute() {
        return this.getRoleNameLdapAttribute();
    }

    public String getCustomLdapFilter() {
        return (String)this.mapperModel.getConfig().getFirst((Object)ROLES_LDAP_FILTER);
    }

    public String getUserRolesRetrieveStrategy() {
        String strategyString = (String)this.mapperModel.getConfig().getFirst((Object)"user.roles.retrieve.strategy");
        return strategyString != null ? strategyString : LOAD_ROLES_BY_MEMBER_ATTRIBUTE;
    }

    public LdapMapConfig getLdapMapConfig() {
        return this.ldapMapConfig;
    }
}

