/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.role;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import org.keycloak.models.ModelException;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.LdapModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.role.config.LdapMapRoleMapperConfig;
import org.keycloak.models.map.storage.ldap.role.entity.LdapRoleEntity;
import org.keycloak.models.map.storage.ldap.store.LdapMapEscapeStrategy;
import org.keycloak.storage.SearchableModelField;

public class LdapRoleModelCriteriaBuilder
extends LdapModelCriteriaBuilder<LdapRoleEntity, RoleModel, LdapRoleModelCriteriaBuilder> {
    private final LdapMapRoleMapperConfig roleMapperConfig;
    private String clientId;
    private Boolean isClientRole;
    private String realmId;

    public String getClientId() {
        return this.clientId;
    }

    public Boolean isClientRole() {
        return this.isClientRole;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public LdapRoleModelCriteriaBuilder and(LdapRoleModelCriteriaBuilder ... builders) {
        LdapRoleModelCriteriaBuilder and = (LdapRoleModelCriteriaBuilder)super.and((LdapModelCriteriaBuilder[])builders);
        for (LdapRoleModelCriteriaBuilder builder : builders) {
            if (builder.isClientRole != null) {
                if (and.isClientRole != null && !Objects.equals(and.isClientRole, builder.isClientRole)) {
                    throw new ModelException("isClientRole must be specified in query only once");
                }
                and.isClientRole = builder.isClientRole;
            }
            if (builder.clientId != null) {
                if (and.clientId != null && !Objects.equals(and.clientId, builder.clientId)) {
                    throw new ModelException("clientId must be specified in query only once");
                }
                and.clientId = builder.clientId;
            }
            if (builder.realmId == null) continue;
            if (and.realmId != null && !Objects.equals(and.realmId, builder.realmId)) {
                throw new ModelException("realmId must be specified in query only once");
            }
            and.realmId = builder.realmId;
        }
        return and;
    }

    public LdapRoleModelCriteriaBuilder or(LdapRoleModelCriteriaBuilder ... builders) {
        LdapRoleModelCriteriaBuilder or = (LdapRoleModelCriteriaBuilder)super.or((LdapModelCriteriaBuilder[])builders);
        for (LdapRoleModelCriteriaBuilder builder : builders) {
            if (builder.isClientRole != null) {
                throw new ModelException("isClientRole not supported in OR condition");
            }
            if (builder.clientId != null) {
                throw new ModelException("clientId not supported in OR condition");
            }
            if (builder.realmId == null) continue;
            throw new ModelException("realmId not supported in OR condition");
        }
        return or;
    }

    @Override
    public LdapRoleModelCriteriaBuilder not(LdapRoleModelCriteriaBuilder builder) {
        LdapRoleModelCriteriaBuilder not = super.not(builder);
        if (builder.isClientRole != null) {
            throw new ModelException("isClientRole not supported in NOT condition");
        }
        if (builder.clientId != null) {
            throw new ModelException("clientId not supported in NOT condition");
        }
        if (builder.realmId != null) {
            throw new ModelException("realmId not supported in NOT condition");
        }
        return not;
    }

    public LdapRoleModelCriteriaBuilder(LdapMapRoleMapperConfig roleMapperConfig) {
        super((Supplier<StringBuilder> predicateFunc) -> new LdapRoleModelCriteriaBuilder(roleMapperConfig, (Supplier<StringBuilder>)predicateFunc));
        this.roleMapperConfig = roleMapperConfig;
    }

    private LdapRoleModelCriteriaBuilder(LdapMapRoleMapperConfig roleMapperConfig, Supplier<StringBuilder> predicateFunc) {
        super((Supplier<StringBuilder> pf) -> new LdapRoleModelCriteriaBuilder(roleMapperConfig, (Supplier<StringBuilder>)pf), predicateFunc);
        this.roleMapperConfig = roleMapperConfig;
    }

    public LdapRoleModelCriteriaBuilder compare(SearchableModelField<? super RoleModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == RoleModel.SearchableFields.CLIENT_ID) {
                    LdapRoleModelCriteriaBuilder result = new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, StringBuilder::new);
                    result.clientId = (String)value[0];
                    return result;
                }
                if (modelField == RoleModel.SearchableFields.REALM_ID) {
                    LdapRoleModelCriteriaBuilder result = new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, StringBuilder::new);
                    result.realmId = (String)value[0];
                    return result;
                }
                if (modelField == RoleModel.SearchableFields.NAME) {
                    String field = this.modelFieldNameToLdap(this.roleMapperConfig, modelField);
                    return new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, () -> this.equal(field, value[0], LdapMapEscapeStrategy.DEFAULT, false));
                }
                if (modelField == RoleModel.SearchableFields.COMPOSITE_ROLE) {
                    return new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, StringBuilder::new);
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NE: {
                if (modelField == RoleModel.SearchableFields.NAME) {
                    String field = this.modelFieldNameToLdap(this.roleMapperConfig, modelField);
                    return this.not(new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, () -> this.equal(field, value[0], LdapMapEscapeStrategy.DEFAULT, false)));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: 
            case LIKE: {
                if (modelField == RoleModel.SearchableFields.NAME || modelField == RoleModel.SearchableFields.DESCRIPTION) {
                    String v = LdapMapEscapeStrategy.DEFAULT.escape(String.valueOf(value[0])).replaceAll("%", "*");
                    String field = this.modelFieldNameToLdap(this.roleMapperConfig, modelField);
                    return new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, () -> {
                        if (v.equals("**")) {
                            return new StringBuilder();
                        }
                        return this.equal(field, v, LdapMapEscapeStrategy.NON_ASCII_CHARS_ONLY, false);
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == RoleModel.SearchableFields.NAME || modelField == RoleModel.SearchableFields.DESCRIPTION || modelField == RoleModel.SearchableFields.ID) {
                    String field = this.modelFieldNameToLdap(this.roleMapperConfig, modelField);
                    return new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, () -> {
                        if (!(value[0] instanceof ArrayList)) {
                            throw new CriterionNotSupportedException(modelField, op);
                        }
                        Object[] v = ((ArrayList)value[0]).toArray();
                        return this.in(field, v, false);
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case EXISTS: 
            case NOT_EXISTS: {
                if (modelField != RoleModel.SearchableFields.CLIENT_ID) break;
                LdapRoleModelCriteriaBuilder result = new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, StringBuilder::new);
                result.isClientRole = op == ModelCriteriaBuilder.Operator.EXISTS;
                return result;
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }

    private String modelFieldNameToLdap(LdapMapRoleMapperConfig roleMapperConfig, SearchableModelField<? super RoleModel> modelField) {
        if (modelField == RoleModel.SearchableFields.NAME) {
            return roleMapperConfig.getRoleNameLdapAttribute();
        }
        if (modelField == RoleModel.SearchableFields.ID) {
            return roleMapperConfig.getLdapMapConfig().getUuidLDAPAttributeName();
        }
        if (modelField == RoleModel.SearchableFields.DESCRIPTION) {
            return "description";
        }
        throw new CriterionNotSupportedException(modelField, null);
    }

    public LdapRoleModelCriteriaBuilder withCustomFilter(String customFilter) {
        if (customFilter != null && this.toString().length() > 0) {
            return this.and(this, new LdapRoleModelCriteriaBuilder(this.roleMapperConfig, () -> new StringBuilder(customFilter)));
        }
        return this;
    }
}

