/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.StartTlsResponse;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;
import org.keycloak.models.map.storage.ldap.model.LdapMapDn;
import org.keycloak.models.map.storage.ldap.store.LdapMapContextManager;
import org.keycloak.models.map.storage.ldap.store.LdapMapOperationDecorator;
import org.keycloak.models.map.storage.ldap.store.LdapMapUtil;
import org.keycloak.truststore.TruststoreProvider;

public class LdapMapOperationManager
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LdapMapOperationManager.class);
    private static final Logger perfLogger = Logger.getLogger(LdapMapOperationManager.class, (String)"perf");
    private final KeycloakSession session;
    private final LdapMapConfig config;
    private LdapMapContextManager ldapMapContextManager;

    public LdapMapOperationManager(KeycloakSession session, LdapMapConfig config) {
        this.session = session;
        this.config = config;
    }

    public void modifyAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void modifyAttributes(String dn, NamingEnumeration<Attribute> attributes) {
        try {
            ArrayList<ModificationItem> modItems = new ArrayList<ModificationItem>();
            while (attributes.hasMore()) {
                ModificationItem modItem = new ModificationItem(2, attributes.next());
                modItems.add(modItem);
            }
            this.modifyAttributes(dn, modItems.toArray(new ModificationItem[0]), null);
        }
        catch (NamingException ne) {
            throw new ModelException("Could not modify attributes on entry from DN [" + dn + "]", (Throwable)ne);
        }
    }

    public void removeAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void addAttribute(String dn, Attribute attribute) {
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, attribute)};
        this.modifyAttributes(dn, mods, null);
    }

    public void removeEntry(final String entryDn) {
        try {
            this.execute(new LdapOperation<SearchResult>(){

                @Override
                public SearchResult execute(LdapContext context) {
                    if (logger.isTraceEnabled()) {
                        logger.tracef("Removing entry with DN [%s]", (Object)entryDn);
                    }
                    LdapMapOperationManager.this.destroySubcontext(context, entryDn);
                    return null;
                }

                public String toString() {
                    return "LdapOperation: remove\n dn: " + entryDn;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not remove entry from DN [" + entryDn + "]", (Throwable)e);
        }
    }

    public String renameEntry(final String oldDn, final String newDn, final boolean fallback) {
        try {
            return this.execute(new LdapOperation<String>(){

                @Override
                public String execute(LdapContext context) throws NamingException {
                    String dn = newDn;
                    int max = 5;
                    for (int i = 0; i < max; ++i) {
                        try {
                            context.rename(new LdapName(oldDn), new LdapName(dn));
                            return dn;
                        }
                        catch (NameAlreadyBoundException ex) {
                            if (!fallback) {
                                throw ex;
                            }
                            String failedDn = dn;
                            dn = LdapMapOperationManager.this.findNextDNForFallback(newDn, i);
                            logger.warnf("Failed to rename DN [%s] to [%s]. Will try to fallback to DN [%s]", (Object)oldDn, (Object)failedDn, (Object)dn);
                            continue;
                        }
                    }
                    throw new ModelException("Could not rename entry from DN [" + oldDn + "] to new DN [" + newDn + "]. All fallbacks failed");
                }

                public String toString() {
                    return "LdapOperation: renameEntry\n oldDn: " + oldDn + "\n newDn: " + newDn;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not rename entry from DN [" + oldDn + "] to new DN [" + newDn + "]", (Throwable)e);
        }
    }

    private String findNextDNForFallback(String newDn, int counter) {
        LdapMapDn dn = LdapMapDn.fromString(newDn);
        LdapMapDn.RDN firstRdn = dn.getFirstRdn();
        String rdnAttrName = firstRdn.getAllKeys().get(0);
        String rdnAttrVal = firstRdn.getAttrValue(rdnAttrName);
        LdapMapDn parentDn = dn.getParentDn();
        parentDn.addFirst(rdnAttrName, rdnAttrVal + counter);
        return parentDn.toString();
    }

    public List<SearchResult> search(final String baseDN, final String filter, final Collection<String> returningAttributes, final int searchScope) throws NamingException {
        final ArrayList result = new ArrayList();
        final SearchControls cons = this.getSearchControls(returningAttributes, searchScope);
        return this.execute(new LdapOperation<List<SearchResult>>(){

            @Override
            public List<SearchResult> execute(LdapContext context) throws NamingException {
                NamingEnumeration<SearchResult> search = context.search((Name)new LdapName(baseDN), filter, cons);
                while (search.hasMoreElements()) {
                    result.add((SearchResult)search.nextElement());
                }
                search.close();
                return result;
            }

            public String toString() {
                return "LdapOperation: search\n baseDn: " + baseDN + "\n filter: " + filter + "\n searchScope: " + searchScope + "\n returningAttrs: " + returningAttributes + "\n resultSize: " + result.size();
            }
        });
    }

    private SearchControls getSearchControls(Collection<String> returningAttributes, int searchScope) {
        SearchControls cons = new SearchControls();
        cons.setSearchScope(searchScope);
        cons.setReturningObjFlag(false);
        returningAttributes = this.getReturningAttributes(returningAttributes);
        cons.setReturningAttributes(returningAttributes.toArray(new String[0]));
        return cons;
    }

    public String getFilterById(String id) {
        StringBuilder filter = new StringBuilder();
        filter.insert(0, "(&");
        if (this.config.isObjectGUID()) {
            byte[] objectGUID = LdapMapUtil.encodeObjectGUID(id);
            filter.append("(objectClass=*)(").append(this.getUuidAttributeName()).append("=").append(LdapMapUtil.convertObjectGUIDToByteString(objectGUID)).append(")");
        } else if (this.config.isEdirectoryGUID()) {
            filter.append("(objectClass=*)(").append(this.getUuidAttributeName().toUpperCase()).append("=").append(LdapMapUtil.convertGUIDToEdirectoryHexString(id)).append(")");
        } else {
            filter.append("(objectClass=*)(").append(this.getUuidAttributeName()).append("=").append(id).append(")");
        }
        if (this.config.getCustomUserSearchFilter() != null) {
            filter.append(this.config.getCustomUserSearchFilter());
        }
        filter.append(")");
        String ldapIdFilter = filter.toString();
        logger.tracef("Using filter for lookup user by LDAP ID: %s", (Object)ldapIdFilter);
        return ldapIdFilter;
    }

    public SearchResult lookupById(final String baseDN, String id, final Collection<String> returningAttributes) {
        final String filter = this.getFilterById(id);
        try {
            final SearchControls cons = this.getSearchControls(returningAttributes, this.config.getSearchScope());
            return this.execute(new LdapOperation<SearchResult>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public SearchResult execute(LdapContext context) throws NamingException {
                    try (NamingEnumeration<SearchResult> search = context.search((Name)new LdapName(baseDN), filter, cons);){
                        if (search.hasMoreElements()) {
                            SearchResult searchResult = search.next();
                            return searchResult;
                        }
                    }
                    return null;
                }

                public String toString() {
                    return "LdapOperation: lookupById\n baseDN: " + baseDN + "\n filter: " + filter + "\n searchScope: " + cons.getSearchScope() + "\n returningAttrs: " + returningAttributes;
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Could not query server using DN [" + baseDN + "] and filter [" + filter + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroySubcontext(LdapContext context, String dn) {
        try {
            NamingEnumeration<Binding> enumeration = null;
            try {
                enumeration = context.listBindings(new LdapName(dn));
                while (enumeration.hasMore()) {
                    Binding binding = enumeration.next();
                    String name = binding.getNameInNamespace();
                    this.destroySubcontext(context, name);
                }
                context.unbind(new LdapName(dn));
            }
            finally {
                if (enumeration != null) {
                    try {
                        enumeration.close();
                    }
                    catch (Exception e) {
                        logger.warn((Object)"problem during close", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ModelException("Could not unbind DN [" + dn + "]", (Throwable)e);
        }
    }

    public void authenticate(String dn, String password) throws AuthenticationException {
        if (password == null || password.isEmpty()) {
            throw new AuthenticationException("Empty password used");
        }
        Context authCtx = null;
        StartTlsResponse tlsResponse = null;
        try {
            LdapMapUtil.setLDAPHostnameToKeycloakSession(this.session, this.config);
            Hashtable<Object, Object> env = LdapMapContextManager.getNonAuthConnectionProperties(this.config);
            env.put("com.sun.jndi.ldap.connect.pool", "false");
            if (!this.config.isStartTls()) {
                env.put("java.naming.security.authentication", "simple");
                env.put("java.naming.security.principal", dn);
                env.put("java.naming.security.credentials", password);
            }
            authCtx = new InitialLdapContext(env, null);
            if (this.config.isStartTls()) {
                SSLSocketFactory sslSocketFactory = null;
                String useTruststoreSpi = this.config.getUseTruststoreSpi();
                if (useTruststoreSpi != null && useTruststoreSpi.equals("always")) {
                    TruststoreProvider provider = (TruststoreProvider)this.session.getProvider(TruststoreProvider.class);
                    sslSocketFactory = provider.getSSLSocketFactory();
                }
                if ((tlsResponse = LdapMapContextManager.startTLS((LdapContext)authCtx, "simple", dn, password.toCharArray(), sslSocketFactory)) == null) {
                    throw new AuthenticationException("Null TLS Response returned from the authentication");
                }
            }
        }
        catch (AuthenticationException ae) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)ae, "Authentication failed for DN [%s]", (Object)dn);
            }
            throw ae;
        }
        catch (RuntimeException re) {
            if (logger.isDebugEnabled()) {
                logger.debugf((Throwable)re, "LDAP Connection TimeOut for DN [%s]", (Object)dn);
            }
            throw re;
        }
        catch (Exception e) {
            logger.errorf((Throwable)e, "Unexpected exception when validating password of DN [%s]", (Object)dn);
            throw new AuthenticationException("Unexpected exception when validating password of user");
        }
        finally {
            if (tlsResponse != null) {
                try {
                    tlsResponse.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (authCtx != null) {
                try {
                    authCtx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void modifyAttributesNaming(final String dn, final ModificationItem[] mods, LdapMapOperationDecorator decorator) throws NamingException {
        if (logger.isTraceEnabled()) {
            logger.tracef("Modifying attributes for entry [%s]: [", (Object)dn);
            for (ModificationItem item : mods) {
                Object values = item.getAttribute().size() > 0 ? item.getAttribute().get() : "No values";
                String attrName = item.getAttribute().getID().toUpperCase();
                if (attrName.contains("PASSWORD") || attrName.contains("UNICODEPWD")) {
                    values = "********************";
                }
                logger.tracef("  Op [%s]: %s = %s", item.getModificationOp(), (Object)item.getAttribute().getID(), values);
            }
            logger.tracef("]", new Object[0]);
        }
        this.execute(new LdapOperation<Void>(){

            @Override
            public Void execute(LdapContext context) throws NamingException {
                context.modifyAttributes(new LdapName(dn), mods);
                return null;
            }

            public String toString() {
                return "LdapOperation: modify\n dn: " + dn + "\n modificationsSize: " + mods.length;
            }
        }, decorator);
    }

    public void modifyAttributes(String dn, ModificationItem[] mods, LdapMapOperationDecorator decorator) {
        try {
            this.modifyAttributesNaming(dn, mods, decorator);
        }
        catch (NamingException e) {
            throw new ModelException("Could not modify attribute for DN [" + dn + "]", (Throwable)e);
        }
    }

    public void createSubContext(final String name, final Attributes attributes) {
        try {
            if (logger.isTraceEnabled()) {
                logger.tracef("Creating entry [%s] with attributes: [", (Object)name);
                NamingEnumeration<? extends Attribute> all = attributes.getAll();
                while (all.hasMore()) {
                    Attribute attribute = all.next();
                    String attrName = attribute.getID().toUpperCase();
                    Object attrVal = attribute.get();
                    if (attrName.contains("PASSWORD") || attrName.contains("UNICODEPWD")) {
                        attrVal = "********************";
                    }
                    logger.tracef("  %s = %s", (Object)attribute.getID(), attrVal);
                }
                logger.tracef("]", new Object[0]);
            }
            this.execute(new LdapOperation<Void>(){

                @Override
                public Void execute(LdapContext context) throws NamingException {
                    DirContext subcontext = context.createSubcontext(new LdapName(name), attributes);
                    subcontext.close();
                    return null;
                }

                public String toString() {
                    return "LdapOperation: create\n dn: " + name + "\n attributesSize: " + attributes.size();
                }
            });
        }
        catch (NamingException e) {
            throw new ModelException("Error creating subcontext [" + name + "]", (Throwable)e);
        }
    }

    private String getUuidAttributeName() {
        return this.config.getUuidLDAPAttributeName();
    }

    public Attributes getAttributes(String entryUUID, String baseDN, Set<String> returningAttributes) {
        SearchResult search = this.lookupById(baseDN, entryUUID, returningAttributes);
        if (search == null) {
            throw new ModelException("Couldn't find item with ID [" + entryUUID + " under base DN [" + baseDN + "]");
        }
        return search.getAttributes();
    }

    public String decodeEntryUUID(Object entryUUID) {
        if (entryUUID instanceof byte[]) {
            if (this.config.isObjectGUID()) {
                return LdapMapUtil.decodeObjectGUID((byte[])entryUUID);
            }
            if (this.config.isEdirectory() && this.config.isEdirectoryGUID()) {
                return LdapMapUtil.decodeGuid((byte[])entryUUID);
            }
        }
        return entryUUID.toString();
    }

    private <R> R execute(LdapOperation<R> operation) throws NamingException {
        return this.execute(operation, null);
    }

    private <R> R execute(LdapOperation<R> operation, LdapMapOperationDecorator decorator) throws NamingException {
        return this.execute(operation, this.getLdapContextManager().getLdapContext(), decorator);
    }

    private LdapMapContextManager getLdapContextManager() {
        if (this.ldapMapContextManager == null) {
            this.ldapMapContextManager = LdapMapContextManager.create(this.session, this.config);
        }
        return this.ldapMapContextManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R execute(LdapOperation<R> operation, LdapContext context, LdapMapOperationDecorator decorator) throws NamingException {
        if (context == null) {
            throw new IllegalArgumentException("Ldap context cannot be null");
        }
        Long start = null;
        if (perfLogger.isDebugEnabled()) {
            start = Time.currentTimeMillis();
        }
        try {
            if (decorator != null) {
                decorator.beforeLDAPOperation(context, operation);
            }
            R r = operation.execute(context);
            return r;
        }
        finally {
            if (start != null) {
                long took = Time.currentTimeMillis() - start;
                if (took > 100L) {
                    perfLogger.debugf("\n%s\ntook: %d ms\n", (Object)operation.toString(), (Object)took);
                } else if (perfLogger.isTraceEnabled()) {
                    perfLogger.tracef("\n%s\ntook: %d ms\n", (Object)operation.toString(), (Object)took);
                }
            }
        }
    }

    @Override
    public void close() {
        this.ldapMapContextManager.close();
    }

    private Set<String> getReturningAttributes(Collection<String> returningAttributes) {
        HashSet<String> result = new HashSet<String>(returningAttributes);
        result.add(this.getUuidAttributeName());
        result.add("objectclass");
        return result;
    }

    public static interface LdapOperation<R> {
        public R execute(LdapContext var1) throws NamingException;
    }
}

