/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.role;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.NamingException;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.common.DeepCloner;
import org.keycloak.models.map.common.StreamUtils;
import org.keycloak.models.map.common.StringKeyConverter;
import org.keycloak.models.map.role.MapRoleEntity;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.QueryParameters;
import org.keycloak.models.map.storage.chm.MapFieldPredicates;
import org.keycloak.models.map.storage.chm.MapModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.LdapMapKeycloakTransaction;
import org.keycloak.models.map.storage.ldap.LdapModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.MapModelCriteriaBuilderAssumingEqualForField;
import org.keycloak.models.map.storage.ldap.config.LdapMapConfig;
import org.keycloak.models.map.storage.ldap.model.LdapMapDn;
import org.keycloak.models.map.storage.ldap.model.LdapMapObject;
import org.keycloak.models.map.storage.ldap.model.LdapMapQuery;
import org.keycloak.models.map.storage.ldap.role.LdapRoleModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.role.config.LdapMapRoleMapperConfig;
import org.keycloak.models.map.storage.ldap.role.entity.LdapMapRoleEntityFieldDelegate;
import org.keycloak.models.map.storage.ldap.role.entity.LdapRoleEntity;
import org.keycloak.models.map.storage.ldap.store.LdapMapIdentityStore;
import org.keycloak.provider.Provider;

public class LdapRoleMapKeycloakTransaction
extends LdapMapKeycloakTransaction<LdapMapRoleEntityFieldDelegate, MapRoleEntity, RoleModel>
implements Provider {
    private final StringKeyConverter<String> keyConverter = new StringKeyConverter.StringKey();
    private final Set<String> deletedKeys = new HashSet<String>();
    private final LdapMapRoleMapperConfig roleMapperConfig;
    private final LdapMapConfig ldapMapConfig;
    private final LdapMapIdentityStore identityStore;
    private final Map<String, String> dns = new HashMap<String, String>();

    public LdapRoleMapKeycloakTransaction(KeycloakSession session, Config.Scope config) {
        this.roleMapperConfig = new LdapMapRoleMapperConfig(config);
        this.ldapMapConfig = new LdapMapConfig(config);
        this.identityStore = new LdapMapIdentityStore(session, this.ldapMapConfig);
        session.enlistForClose((Provider)this);
    }

    public String readIdByDn(String dn) {
        String id = this.dns.get(dn);
        if (id == null) {
            for (Map.Entry entry : this.entities.entrySet()) {
                LdapMapObject ldap = ((LdapMapRoleEntityFieldDelegate)((Object)entry.getValue())).getLdapMapObject();
                if (!ldap.getDn().toString().equals(dn)) continue;
                id = ldap.getId();
                break;
            }
        }
        if (id != null) {
            return id;
        }
        LdapMapQuery ldapQuery = new LdapMapQuery();
        ldapQuery.setSearchScope(this.ldapMapConfig.getSearchScope());
        ldapQuery.setSearchDn(this.roleMapperConfig.getCommonRolesDn());
        Collection<String> roleObjectClasses = this.ldapMapConfig.getRoleObjectClasses();
        ldapQuery.addObjectClasses(roleObjectClasses);
        String rolesRdnAttr = this.roleMapperConfig.getRoleNameLdapAttribute();
        ldapQuery.addReturningLdapAttribute(rolesRdnAttr);
        LdapMapDn.RDN rdn = LdapMapDn.fromString(dn).getFirstRdn();
        String key = rdn.getAllKeys().get(0);
        String value = rdn.getAttrValue(key);
        ModelCriteriaBuilder mcb = new LdapRoleModelCriteriaBuilder(this.roleMapperConfig).compare(RoleModel.SearchableFields.NAME, ModelCriteriaBuilder.Operator.EQ, new Object[]{value});
        mcb = mcb.withCustomFilter(this.roleMapperConfig.getCustomLdapFilter());
        ldapQuery.setModelCriteriaBuilder((LdapModelCriteriaBuilder<?, ?, ?>)mcb);
        List<LdapMapObject> ldapObjects = this.identityStore.fetchQueryResults(ldapQuery);
        if (ldapObjects.size() == 1) {
            this.dns.put(dn, ldapObjects.get(0).getId());
            return ldapObjects.get(0).getId();
        }
        return null;
    }

    private MapModelCriteriaBuilder<String, MapRoleEntity, RoleModel> createCriteriaBuilderMap() {
        return new MapModelCriteriaBuilderAssumingEqualForField<String, MapRoleEntity, RoleModel>(this.keyConverter, MapFieldPredicates.getPredicates(RoleModel.class), RoleModel.SearchableFields.REALM_ID);
    }

    public LdapMapRoleEntityFieldDelegate create(MapRoleEntity value) {
        LdapMapRoleEntityFieldDelegate mapped;
        block3: {
            DeepCloner CLONER = new DeepCloner.Builder().constructor(MapRoleEntity.class, cloner -> new LdapMapRoleEntityFieldDelegate(new LdapRoleEntity((DeepCloner)cloner, this.roleMapperConfig, this, value.getClientId()))).build();
            mapped = (LdapMapRoleEntityFieldDelegate)((Object)CLONER.from((Object)value));
            mapped.setId(null);
            if (mapped.getLdapMapObject().getId() == null && mapped.getLdapMapObject().getAttributeAsSet(this.roleMapperConfig.getMembershipLdapAttribute()) == null) {
                mapped.getLdapMapObject().setAttribute(this.roleMapperConfig.getMembershipLdapAttribute(), Stream.of(mapped.getLdapMapObject().getDn().toString()).collect(Collectors.toSet()));
            }
            try {
                this.identityStore.add(mapped.getLdapMapObject());
            }
            catch (ModelException ex) {
                if (!value.isClientRole().booleanValue() || !(ex.getCause() instanceof NamingException)) break block3;
                final LdapMapObject client = new LdapMapObject();
                client.setObjectClasses(Arrays.asList("top", "organizationalUnit"));
                client.setRdnAttributeName("ou");
                client.setDn(LdapMapDn.fromString(this.roleMapperConfig.getRolesDn(mapped.isClientRole(), mapped.getClientId())));
                client.setSingleAttribute("ou", mapped.getClientId());
                this.identityStore.add(client);
                this.tasksOnRollback.add(new LdapMapKeycloakTransaction.DeleteOperation(){

                    @Override
                    public void execute() {
                        LdapRoleMapKeycloakTransaction.this.identityStore.remove(client);
                    }
                });
                this.identityStore.add(mapped.getLdapMapObject());
            }
        }
        this.entities.put(mapped.getId(), mapped);
        this.tasksOnRollback.add(new LdapMapKeycloakTransaction.DeleteOperation(){

            @Override
            public void execute() {
                LdapRoleMapKeycloakTransaction.this.identityStore.remove(mapped.getLdapMapObject());
                LdapRoleMapKeycloakTransaction.this.entities.remove(mapped.getId());
            }
        });
        return mapped;
    }

    public boolean delete(String key) {
        final LdapMapRoleEntityFieldDelegate read = this.read(key);
        if (read == null) {
            throw new ModelException("unable to read entity with key " + key);
        }
        if (!this.deletedKeys.contains(key)) {
            this.deletedKeys.add(key);
            this.tasksOnCommit.add(new LdapMapKeycloakTransaction.DeleteOperation(){

                @Override
                public void execute() {
                    LdapRoleMapKeycloakTransaction.this.identityStore.remove(read.getLdapMapObject());
                    LdapRoleMapKeycloakTransaction.this.entities.remove(read.getId());
                }
            });
        }
        return true;
    }

    public LdapRoleEntity readLdap(String key) {
        LdapMapRoleEntityFieldDelegate read = this.read(key);
        if (read == null) {
            return null;
        }
        return read.getEntityFieldDelegate();
    }

    public LdapMapRoleEntityFieldDelegate read(String key) {
        if (this.deletedKeys.contains(key)) {
            return null;
        }
        LdapMapRoleEntityFieldDelegate val = (LdapMapRoleEntityFieldDelegate)((Object)this.entities.get(key));
        if (val == null) {
            val = this.lookupEntityById(key, null);
            if (val == null) {
                LdapMapQuery ldapQuery = new LdapMapQuery();
                ldapQuery.setSearchScope(this.ldapMapConfig.getSearchScope());
                String sdn = this.roleMapperConfig.getClientRolesDn();
                ldapQuery.setSearchDn(sdn.replaceAll(".*\\{0},", ""));
                LdapMapObject ldapObject = this.identityStore.fetchById(key, ldapQuery);
                if (ldapObject != null) {
                    LdapMapDn.RDN firstRdn = ldapObject.getDn().getParentDn().getFirstRdn();
                    String clientId = firstRdn.getAttrValue(firstRdn.getAllKeys().get(0));
                    val = this.lookupEntityById(key, clientId);
                }
            }
            if (val != null) {
                this.entities.put(key, val);
            }
        }
        return val;
    }

    private LdapMapRoleEntityFieldDelegate lookupEntityById(String id, String clientId) {
        LdapMapQuery ldapQuery = this.getLdapQuery(clientId != null, clientId);
        LdapMapObject ldapObject = this.identityStore.fetchById(id, ldapQuery);
        if (ldapObject != null) {
            return new LdapMapRoleEntityFieldDelegate(new LdapRoleEntity(ldapObject, this.roleMapperConfig, this, clientId));
        }
        return null;
    }

    public Stream<MapRoleEntity> read(QueryParameters<RoleModel> queryParameters) {
        Stream<Object> ldapStream;
        LdapRoleModelCriteriaBuilder mcb = (LdapRoleModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder((ModelCriteriaBuilder)this.createLdapModelCriteriaBuilder());
        Boolean isClientRole = mcb.isClientRole();
        String clientId = mcb.getClientId();
        LdapMapQuery ldapQuery = this.getLdapQuery(isClientRole, clientId);
        mcb = mcb.withCustomFilter(this.roleMapperConfig.getCustomLdapFilter());
        ldapQuery.setModelCriteriaBuilder(mcb);
        MapModelCriteriaBuilder mapMcb = (MapModelCriteriaBuilder)queryParameters.getModelCriteriaBuilder().flashToModelCriteriaBuilder(this.createCriteriaBuilderMap());
        Stream existingEntities = this.entities.entrySet().stream().filter(me -> mapMcb.getKeyFilter().test(this.keyConverter.fromString((String)me.getKey())) && !this.deletedKeys.contains(me.getKey())).map(Map.Entry::getValue).filter(mapMcb.getEntityFilter()).collect(Collectors.toList()).stream();
        try {
            List<LdapMapObject> ldapObjects = this.identityStore.fetchQueryResults(ldapQuery);
            ldapStream = ldapObjects.stream().map(ldapMapObject -> {
                StreamUtils.Pair<Boolean, String> client = this.getClientId(ldapMapObject.getDn());
                if (client == null) {
                    return null;
                }
                LdapMapRoleEntityFieldDelegate entity = new LdapMapRoleEntityFieldDelegate(new LdapRoleEntity((LdapMapObject)ldapMapObject, this.roleMapperConfig, this, (String)client.getV()));
                LdapMapRoleEntityFieldDelegate existingEntry = (LdapMapRoleEntityFieldDelegate)((Object)((Object)this.entities.get(entity.getId())));
                if (existingEntry != null) {
                    return null;
                }
                this.entities.put(entity.getId(), entity);
                return entity;
            }).filter(Objects::nonNull).filter(me -> !this.deletedKeys.contains(me.getId())).filter(me -> mapMcb.getKeyFilter().test(me.getId())).filter(me -> mapMcb.getEntityFilter().test(me)).collect(Collectors.toList()).stream();
        }
        catch (ModelException ex) {
            if (clientId != null && ex.getCause() instanceof NamingException) {
                ldapStream = Stream.empty();
            }
            throw ex;
        }
        ldapStream = Stream.concat(ldapStream, existingEntities);
        if (!queryParameters.getOrderBy().isEmpty()) {
            ldapStream = ldapStream.sorted(MapFieldPredicates.getComparator(queryParameters.getOrderBy().stream()));
        }
        if (queryParameters.getOffset() != null) {
            ldapStream = ldapStream.skip(queryParameters.getOffset().intValue());
        }
        if (queryParameters.getLimit() != null) {
            ldapStream = ldapStream.limit(queryParameters.getLimit().intValue());
        }
        return ldapStream;
    }

    private StreamUtils.Pair<Boolean, String> getClientId(LdapMapDn dn) {
        if (dn.getParentDn().equals(LdapMapDn.fromString(this.roleMapperConfig.getRealmRolesDn()))) {
            return new StreamUtils.Pair((Object)false, null);
        }
        String clientsDnWildcard = this.roleMapperConfig.getClientRolesDn();
        if (clientsDnWildcard != null) {
            clientsDnWildcard = clientsDnWildcard.replaceAll(".*\\{0},", "");
            if (dn.getParentDn().getParentDn().equals(LdapMapDn.fromString(clientsDnWildcard))) {
                LdapMapDn.RDN firstRdn = dn.getParentDn().getFirstRdn();
                return new StreamUtils.Pair((Object)true, (Object)firstRdn.getAttrValue(firstRdn.getAllKeys().get(0)));
            }
        }
        return null;
    }

    private LdapMapQuery getLdapQuery(Boolean isClientRole, String clientId) {
        LdapMapQuery ldapMapQuery = new LdapMapQuery();
        ldapMapQuery.setSearchScope(this.ldapMapConfig.getSearchScope());
        String rolesDn = this.roleMapperConfig.getRolesDn(isClientRole, clientId);
        ldapMapQuery.setSearchDn(rolesDn);
        Collection<String> roleObjectClasses = this.ldapMapConfig.getRoleObjectClasses();
        ldapMapQuery.addObjectClasses(roleObjectClasses);
        String rolesRdnAttr = this.roleMapperConfig.getRoleNameLdapAttribute();
        ldapMapQuery.addReturningLdapAttribute(rolesRdnAttr);
        ldapMapQuery.addReturningLdapAttribute("description");
        ldapMapQuery.addReturningLdapAttribute(this.roleMapperConfig.getMembershipLdapAttribute());
        this.roleMapperConfig.getRoleAttributes().forEach(ldapMapQuery::addReturningLdapAttribute);
        return ldapMapQuery;
    }

    @Override
    public void commit() {
        super.commit();
        for (LdapMapKeycloakTransaction.MapTaskWithValue mapTaskWithValue : this.tasksOnCommit) {
            mapTaskWithValue.execute();
        }
        this.entities.forEach((entityKey, entity) -> {
            if (entity.isUpdated()) {
                this.identityStore.update(entity.getLdapMapObject());
            }
        });
        this.tasksOnCommit.clear();
        this.entities.clear();
        this.tasksOnRollback.clear();
    }

    @Override
    public void rollback() {
        super.rollback();
        Iterator iterator = this.tasksOnRollback.descendingIterator();
        while (iterator.hasNext()) {
            ((LdapMapKeycloakTransaction.MapTaskWithValue)iterator.next()).execute();
        }
    }

    protected LdapRoleModelCriteriaBuilder createLdapModelCriteriaBuilder() {
        return new LdapRoleModelCriteriaBuilder(this.roleMapperConfig);
    }

    public void close() {
        this.identityStore.close();
    }

    public static interface LdapRoleMapKeycloakTransactionFunction<A, B, R> {
        public R apply(A var1, B var2);
    }
}

