/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.map.storage.ldap.LdapModelCriteriaBuilder;

public class LdapMapQuery
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(LdapMapQuery.class);
    private int offset;
    private int limit;
    private String searchDn;
    private LdapModelCriteriaBuilder<?, ?, ?> modelCriteriaBuilder;
    private final Set<String> returningLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> returningReadOnlyLdapAttributes = new LinkedHashSet<String>();
    private final Set<String> objectClasses = new LinkedHashSet<String>();
    private final List<ComponentModel> mappers = new ArrayList<ComponentModel>();
    private int searchScope = 2;

    public void setSearchDn(String searchDn) {
        this.searchDn = searchDn;
    }

    public void addObjectClasses(Collection<String> objectClasses) {
        this.objectClasses.addAll(objectClasses);
    }

    public void addReturningLdapAttribute(String ldapAttributeName) {
        this.returningLdapAttributes.add(ldapAttributeName);
    }

    public void addReturningReadOnlyLdapAttribute(String ldapAttributeName) {
        this.returningReadOnlyLdapAttributes.add(ldapAttributeName.toLowerCase());
    }

    public LdapMapQuery addMappers(Collection<ComponentModel> mappers) {
        this.mappers.addAll(mappers);
        return this;
    }

    public void setSearchScope(int searchScope) {
        this.searchScope = searchScope;
    }

    public String getSearchDn() {
        return this.searchDn;
    }

    public Set<String> getObjectClasses() {
        return Collections.unmodifiableSet(this.objectClasses);
    }

    public Set<String> getReturningLdapAttributes() {
        return Collections.unmodifiableSet(this.returningLdapAttributes);
    }

    public Set<String> getReturningReadOnlyLdapAttributes() {
        return Collections.unmodifiableSet(this.returningReadOnlyLdapAttributes);
    }

    public List<ComponentModel> getMappers() {
        return this.mappers;
    }

    public int getSearchScope() {
        return this.searchScope;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public LdapMapQuery setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public LdapMapQuery setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void close() {
    }

    public void setModelCriteriaBuilder(LdapModelCriteriaBuilder<?, ?, ?> ldapModelCriteriaBuilder) {
        this.modelCriteriaBuilder = ldapModelCriteriaBuilder;
    }

    public LdapModelCriteriaBuilder<?, ?, ?> getModelCriteriaBuilder() {
        return this.modelCriteriaBuilder;
    }
}

