/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap.config;

import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.models.LDAPConstants;

public class LdapMapConfig {
    private final MultivaluedHashMap<String, String> config;
    private final Set<String> binaryAttributeNames = new HashSet<String>();

    public LdapMapConfig(Config.Scope config) {
        this.config = LdapMapConfig.hm(config);
    }

    private static MultivaluedHashMap<String, String> hm(final Config.Scope config) {
        return new MultivaluedHashMap<String, String>(){

            public String getFirst(String key) {
                return config.get(key);
            }
        };
    }

    public Collection<String> getRoleObjectClasses() {
        String objectClasses = (String)this.config.getFirst((Object)"role.object.classes");
        if (objectClasses == null) {
            objectClasses = this.isActiveDirectory() ? "group" : "groupOfNames";
        }
        return this.getConfigValues(objectClasses);
    }

    protected Set<String> getConfigValues(String str) {
        String[] objClasses = str.split(",");
        HashSet<String> trimmed = new HashSet<String>();
        for (String objectClass : objClasses) {
            if ((objectClass = objectClass.trim()).length() <= 0) continue;
            trimmed.add(objectClass);
        }
        return trimmed;
    }

    public String getConnectionUrl() {
        return (String)this.config.getFirst((Object)"connectionUrl");
    }

    public String getFactoryName() {
        return "com.sun.jndi.ldap.LdapCtxFactory";
    }

    public String getAuthType() {
        String value = (String)this.config.getFirst((Object)"authType");
        if (value == null) {
            return "simple";
        }
        return value;
    }

    public boolean useExtendedPasswordModifyOp() {
        String value = (String)this.config.getFirst((Object)"usePasswordModifyExtendedOp");
        return Boolean.parseBoolean(value);
    }

    public String getUseTruststoreSpi() {
        return (String)this.config.getFirst((Object)"useTruststoreSpi");
    }

    public String getUsersDn() {
        String usersDn = (String)this.config.getFirst((Object)"usersDn");
        if (usersDn == null) {
            usersDn = (String)this.config.getFirst((Object)"userDnSuffix");
        }
        return usersDn;
    }

    public Collection<String> getUserObjectClasses() {
        String objClassesCfg = (String)this.config.getFirst((Object)"userObjectClasses");
        String objClassesStr = objClassesCfg != null && objClassesCfg.length() > 0 ? objClassesCfg.trim() : "inetOrgPerson,organizationalPerson";
        String[] objectClasses = objClassesStr.split(",");
        HashSet<String> userObjClasses = new HashSet<String>();
        for (String objectClass : objectClasses) {
            userObjClasses.add(objectClass.trim());
        }
        return userObjClasses;
    }

    public String getBindDN() {
        return (String)this.config.getFirst((Object)"bindDn");
    }

    public String getBindCredential() {
        return (String)this.config.getFirst((Object)"bindCredential");
    }

    public String getVendor() {
        return (String)this.config.getFirst((Object)"vendor");
    }

    public boolean isActiveDirectory() {
        String vendor = this.getVendor();
        return vendor != null && vendor.equals("ad");
    }

    public boolean isValidatePasswordPolicy() {
        String validatePPolicy = (String)this.config.getFirst((Object)"validatePasswordPolicy");
        return Boolean.parseBoolean(validatePPolicy);
    }

    public boolean isTrustEmail() {
        String trustEmail = (String)this.config.getFirst((Object)"trustEmail");
        return Boolean.parseBoolean(trustEmail);
    }

    public String getConnectionPooling() {
        if (this.isStartTls()) {
            return null;
        }
        return (String)this.config.getFirst((Object)"connectionPooling");
    }

    public String getConnectionPoolingAuthentication() {
        return (String)this.config.getFirst((Object)"connectionPoolingAuthentication");
    }

    public String getConnectionPoolingDebug() {
        return (String)this.config.getFirst((Object)"connectionPoolingDebug");
    }

    public String getConnectionPoolingInitSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingInitSize");
    }

    public String getConnectionPoolingMaxSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingMaxSize");
    }

    public String getConnectionPoolingPrefSize() {
        return (String)this.config.getFirst((Object)"connectionPoolingPrefSize");
    }

    public String getConnectionPoolingProtocol() {
        return (String)this.config.getFirst((Object)"connectionPoolingProtocol");
    }

    public String getConnectionPoolingTimeout() {
        return (String)this.config.getFirst((Object)"connectionPoolingTimeout");
    }

    public String getConnectionTimeout() {
        return (String)this.config.getFirst((Object)"connectionTimeout");
    }

    public String getReadTimeout() {
        return (String)this.config.getFirst((Object)"readTimeout");
    }

    public Properties getAdditionalConnectionProperties() {
        return null;
    }

    public int getSearchScope() {
        String searchScope = (String)this.config.getFirst((Object)"searchScope");
        return searchScope == null ? 2 : Integer.parseInt(searchScope);
    }

    public String getUuidLDAPAttributeName() {
        String uuidAttrName = (String)this.config.getFirst((Object)"uuidLDAPAttribute");
        if (uuidAttrName == null) {
            String vendor = this.getVendor();
            uuidAttrName = LDAPConstants.getUuidAttributeName((String)vendor);
        }
        return uuidAttrName;
    }

    public boolean isObjectGUID() {
        return this.getUuidLDAPAttributeName().equalsIgnoreCase("objectGUID");
    }

    public boolean isEdirectoryGUID() {
        return this.isEdirectory() && this.getUuidLDAPAttributeName().equalsIgnoreCase("guid");
    }

    public boolean isPagination() {
        String pagination = (String)this.config.getFirst((Object)"pagination");
        return Boolean.parseBoolean(pagination);
    }

    public int getBatchSizeForSync() {
        String pageSizeConfig = (String)this.config.getFirst((Object)"batchSizeForSync");
        return pageSizeConfig != null ? Integer.parseInt(pageSizeConfig) : 1000;
    }

    public String getUsernameLdapAttribute() {
        String username = (String)this.config.getFirst((Object)"usernameLDAPAttribute");
        if (username == null) {
            username = this.isActiveDirectory() ? "cn" : "uid";
        }
        return username;
    }

    public String getRdnLdapAttribute() {
        String rdn = (String)this.config.getFirst((Object)"rdnLDAPAttribute");
        if (rdn == null && (rdn = this.getUsernameLdapAttribute()).equalsIgnoreCase("sAMAccountName")) {
            rdn = "cn";
        }
        return rdn;
    }

    public String getCustomUserSearchFilter() {
        String customFilter = (String)this.config.getFirst((Object)"customUserSearchFilter");
        if (customFilter != null && (customFilter = customFilter.trim()).length() > 0) {
            return customFilter;
        }
        return null;
    }

    public boolean isStartTls() {
        return Boolean.parseBoolean((String)this.config.getFirst((Object)"startTls"));
    }

    public void addBinaryAttribute(String attrName) {
        this.binaryAttributeNames.add(attrName);
    }

    public Set<String> getBinaryAttributeNames() {
        return this.binaryAttributeNames;
    }

    public boolean isEdirectory() {
        return "edirectory".equalsIgnoreCase(this.getVendor());
    }

    public String toString() {
        MultivaluedHashMap copy = new MultivaluedHashMap(this.config);
        copy.remove((Object)"bindCredential");
        return copy + ", binaryAttributes: " + this.binaryAttributeNames;
    }
}

