/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.ldap;

import java.util.Date;
import java.util.function.Function;
import java.util.function.Supplier;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.ldap.store.LdapMapEscapeStrategy;
import org.keycloak.models.map.storage.ldap.store.LdapMapOctetStringEncoder;
import org.keycloak.models.map.storage.ldap.store.LdapMapUtil;

public abstract class LdapModelCriteriaBuilder<E, M, Self extends LdapModelCriteriaBuilder<E, M, Self>>
implements ModelCriteriaBuilder<M, Self> {
    private final Function<Supplier<StringBuilder>, Self> instantiator;
    private Supplier<StringBuilder> predicateFunc = null;

    public LdapModelCriteriaBuilder(Function<Supplier<StringBuilder>, Self> instantiator) {
        this.instantiator = instantiator;
    }

    public Self and(Self ... builders) {
        return (Self)((LdapModelCriteriaBuilder)this.instantiator.apply(() -> {
            StringBuilder filter = new StringBuilder();
            for (LdapModelCriteriaBuilder builder : builders) {
                filter.append((CharSequence)builder.getPredicateFunc().get());
            }
            if (filter.length() > 0) {
                filter.insert(0, "(&");
                filter.append(")");
            }
            return filter;
        }));
    }

    public Self or(Self ... builders) {
        return (Self)((LdapModelCriteriaBuilder)this.instantiator.apply(() -> {
            StringBuilder filter = new StringBuilder();
            filter.append("(|");
            for (LdapModelCriteriaBuilder builder : builders) {
                filter.append((CharSequence)builder.getPredicateFunc().get());
            }
            filter.append(")");
            return filter;
        }));
    }

    public Self not(Self builder) {
        return (Self)((LdapModelCriteriaBuilder)this.instantiator.apply(() -> {
            StringBuilder filter = new StringBuilder();
            filter.append("(!");
            filter.append((CharSequence)builder.getPredicateFunc().get());
            filter.append(")");
            return filter;
        }));
    }

    public Supplier<StringBuilder> getPredicateFunc() {
        return this.predicateFunc;
    }

    public LdapModelCriteriaBuilder(Function<Supplier<StringBuilder>, Self> instantiator, Supplier<StringBuilder> predicateFunc) {
        this.instantiator = instantiator;
        this.predicateFunc = predicateFunc;
    }

    protected StringBuilder equal(String field, Object value, LdapMapEscapeStrategy ldapMapEscapeStrategy, boolean isBinary) {
        Object parameterValue = value;
        if (value instanceof Date) {
            parameterValue = LdapMapUtil.formatDate((Date)parameterValue);
        }
        String escaped = new LdapMapOctetStringEncoder(ldapMapEscapeStrategy).encode(parameterValue, isBinary);
        return new StringBuilder().append("(").append(field).append("=").append(escaped).append(")");
    }

    protected StringBuilder in(String name, Object[] valuesToCompare, boolean isBinary) {
        StringBuilder filter = new StringBuilder();
        filter.append("(|(");
        for (Object o : valuesToCompare) {
            String value = new LdapMapOctetStringEncoder().encode(o, false);
            filter.append("(").append(name).append("=").append((Object)value).append(")");
        }
        filter.append("))");
        return filter;
    }
}

