/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.keycloak.models.map.annotations.GenerateEntityImplementations;
import org.keycloak.models.map.processor.AbstractGenerateEntityImplementationsProcessor;
import org.keycloak.models.map.processor.FieldAccessorType;
import org.keycloak.models.map.processor.PrintWriterNoJavaLang;
import org.keycloak.models.map.processor.Util;

@SupportedAnnotationTypes(value={"org.keycloak.models.map.annotations.GenerateEntityImplementations"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_11)
public class GenerateEntityImplementationsProcessor
extends AbstractGenerateEntityImplementationsProcessor {
    private static final Collection<String> autogenerated = new TreeSet<String>();
    private static final String ID_FIELD_NAME = "Id";
    private final AbstractGenerateEntityImplementationsProcessor.Generator[] generators = new AbstractGenerateEntityImplementationsProcessor.Generator[]{new ClonerGenerator(), new DelegateGenerator(), new FieldsGenerator(), new FieldDelegateGenerator(), new ImplGenerator()};

    @Override
    protected void afterAnnotationProcessing() {
        if (!autogenerated.isEmpty()) {
            try {
                JavaFileObject file = this.processingEnv.getFiler().createSourceFile("org.keycloak.models.map.common.AutogeneratedClasses", new Element[0]);
                try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                    ((PrintWriter)pw).println("package org.keycloak.models.map.common;");
                    ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner.Cloner;");
                    ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner.DelegateCreator;");
                    ((PrintWriter)pw).println("import java.util.function.Function;");
                    ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner.EntityFieldDelegateCreator;");
                    ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                    this.generatedAnnotation(pw);
                    ((PrintWriter)pw).println("public final class AutogeneratedClasses {");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Cloner<?>> CLONERS_WITH_ID = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Cloner<?>> CLONERS_WITHOUT_ID = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, DelegateCreator<?>> DELEGATE_CREATORS = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, EntityFieldDelegateCreator<?>> ENTITY_FIELD_DELEGATE_CREATORS = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Object> EMPTY_INSTANCES = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, EntityField<?>[]> ENTITY_FIELDS = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    public static final java.util.Map<Class<?>, Function<DeepCloner, ?>> CONSTRUCTORS_DC = new java.util.HashMap<>();");
                    ((PrintWriter)pw).println("    static {");
                    autogenerated.forEach(pw::println);
                    ((PrintWriter)pw).println("    }");
                    ((PrintWriter)pw).println("}");
                }
            }
            catch (IOException ex) {
                Logger.getLogger(GenerateEntityImplementationsProcessor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    protected AbstractGenerateEntityImplementationsProcessor.Generator[] getGenerators() {
        return this.generators;
    }

    @Override
    protected boolean testAnnotationElement(TypeElement e) {
        if (e.getKind() != ElementKind.INTERFACE) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Annotation @GenerateEntityImplementations is only applicable to an interface", e);
            return false;
        }
        return true;
    }

    protected static String toEnumConstant(String key) {
        return key.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase();
    }

    protected void printMethodHeader(PrintWriter pw, ExecutableElement ee) {
        pw.println("    @Override " + ee.getModifiers().stream().filter(m -> m != Modifier.ABSTRACT).map(Object::toString).collect(Collectors.joining(" ")) + " " + ee.getReturnType() + " " + ee.getSimpleName() + "(" + Util.methodParameters(ee.getParameters()) + ") {");
    }

    private class ClonerGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private ClonerGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String clonerImplClassName = className + "Cloner";
            String clonerSimpleClassName = simpleClassName + "Cloner";
            JavaFileObject enumFile = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(clonerImplClassName, new Element[0]);
            try (PrintWriter pw = new PrintWriter(enumFile.openWriter()){

                @Override
                public void println(String x) {
                    super.println(x == null ? x : x.replaceAll("java.lang.", ""));
                }
            };){
                if (packageName != null) {
                    pw.println("package " + packageName + ";");
                }
                pw.println("import org.keycloak.models.map.common.DeepCloner;");
                pw.println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                GenerateEntityImplementationsProcessor.this.generatedAnnotation(pw);
                pw.println("public class " + clonerSimpleClassName + " {");
                if (methodsPerAttribute.containsKey(GenerateEntityImplementationsProcessor.ID_FIELD_NAME)) {
                    pw.println("    public static " + className + " deepClone(" + className + " original, " + className + " target) {");
                    HashSet<ExecutableElement> idMethods = methodsPerAttribute.get(GenerateEntityImplementationsProcessor.ID_FIELD_NAME);
                    TypeMirror idFieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(GenerateEntityImplementationsProcessor.ID_FIELD_NAME, idMethods);
                    this.cloneField(e, GenerateEntityImplementationsProcessor.ID_FIELD_NAME, idMethods, idFieldType, pw);
                    pw.println("        return deepCloneNoId(original, target);");
                    pw.println("    }");
                    autogenerated.add("        CLONERS_WITH_ID.put(" + className + ".class, (Cloner<" + className + ">) " + clonerImplClassName + "::deepClone);");
                    pw.println("    public static " + className + " deepCloneNoId(" + className + " original, " + className + " target) {");
                    methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(me -> {
                        HashSet methods;
                        String fieldName = (String)me.getKey();
                        TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(fieldName, methods = (HashSet)me.getValue());
                        if (fieldType == null || GenerateEntityImplementationsProcessor.ID_FIELD_NAME.equals(fieldName)) {
                            return;
                        }
                        this.cloneField(e, fieldName, methods, fieldType, pw);
                    });
                    pw.println("        target.clearUpdatedFlag();");
                    pw.println("        return target;");
                    pw.println("    }");
                    autogenerated.add("        CLONERS_WITHOUT_ID.put(" + className + ".class, (Cloner<" + className + ">) " + clonerImplClassName + "::deepCloneNoId);");
                } else {
                    pw.println("    public static " + className + " deepClone(" + className + " original, " + className + " target) {");
                    methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).forEach(me -> {
                        HashSet methods;
                        String fieldName = (String)me.getKey();
                        TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(fieldName, methods = (HashSet)me.getValue());
                        if (fieldType == null) {
                            return;
                        }
                        this.cloneField(e, fieldName, methods, fieldType, pw);
                    });
                    pw.println("        target.clearUpdatedFlag();");
                    pw.println("        return target;");
                    pw.println("    }");
                    autogenerated.add("        CLONERS_WITH_ID.put(" + className + ".class, (Cloner<" + className + ">) " + clonerImplClassName + "::deepClone);");
                }
                pw.println("}");
            }
        }

        private void cloneField(TypeElement e, String fieldName, HashSet<ExecutableElement> methods, TypeMirror fieldType, PrintWriter pw) {
            ExecutableElement getter = FieldAccessorType.getMethod(FieldAccessorType.GETTER, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType).orElse(null);
            if (getter == null) {
                GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not determine getter for " + fieldName + " property");
                return;
            }
            Optional<ExecutableElement> setter = FieldAccessorType.getMethod(FieldAccessorType.SETTER, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            Optional<ExecutableElement> addToCollection = FieldAccessorType.getMethod(FieldAccessorType.COLLECTION_ADD, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            Optional<ExecutableElement> updateMap = FieldAccessorType.getMethod(FieldAccessorType.MAP_ADD, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
            if (setter.isPresent()) {
                Name setterName = setter.get().getSimpleName();
                pw.println("        target." + setterName + "(original." + getter.getSimpleName() + "());");
            } else if (addToCollection.isPresent()) {
                pw.println("        if (original." + getter.getSimpleName() + "() != null) {");
                pw.println("            original." + getter.getSimpleName() + "().forEach(target::" + addToCollection.get().getSimpleName() + ");");
                pw.println("        }");
            } else if (updateMap.isPresent()) {
                pw.println("        if (original." + getter.getSimpleName() + "() != null) {");
                pw.println("            original." + getter.getSimpleName() + "().forEach(target::" + updateMap.get().getSimpleName() + ");");
                pw.println("        }");
            } else {
                GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not determine way to clone " + fieldName + " property", e);
            }
        }
    }

    private class DelegateGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private DelegateGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapClassName = className + "Delegate";
            String mapSimpleClassName = simpleClassName + "Delegate";
            String fieldsClassName = className + "Fields";
            GenerateEntityImplementations an = e.getAnnotation(GenerateEntityImplementations.class);
            TypeElement parentTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(an.inherits() == null || an.inherits().isEmpty() ? "void" : an.inherits());
            if (parentTypeElement == null) {
                return;
            }
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapClassName, new Element[0]);
            IdentityHashMap m2field = new IdentityHashMap();
            methodsPerAttribute.forEach((f, s) -> s.forEach(m -> m2field.put(m, f)));
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                GenerateEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public class " + mapSimpleClassName + " implements " + className + ", org.keycloak.models.map.common.delegate.HasDelegateProvider<" + className + "> {");
                ((PrintWriter)pw).println("    private final org.keycloak.models.map.common.delegate.DelegateProvider<" + className + "> delegateProvider;");
                ((PrintWriter)pw).println("    public " + mapSimpleClassName + "(org.keycloak.models.map.common.delegate.DelegateProvider<" + className + "> delegateProvider) {");
                ((PrintWriter)pw).println("        this.delegateProvider = delegateProvider;");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    public org.keycloak.models.map.common.delegate.DelegateProvider<" + className + "> getDelegateProvider() {");
                ((PrintWriter)pw).println("        return this.delegateProvider;");
                ((PrintWriter)pw).println("    }");
                GenerateEntityImplementationsProcessor.this.getAllAbstractMethods(e).forEach(ee -> {
                    GenerateEntityImplementationsProcessor.this.printMethodHeader(pw, (ExecutableElement)ee);
                    String field = (String)m2field.get(ee);
                    String string = field = field == null ? "null" : fieldsClassName + "." + GenerateEntityImplementationsProcessor.toEnumConstant(field);
                    if (ee.getReturnType().getKind() == TypeKind.BOOLEAN && "isUpdated".equals(ee.getSimpleName().toString())) {
                        pw.println("        return delegateProvider.isUpdated();");
                    } else if (ee.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("        delegateProvider.getDelegate(false, " + Stream.concat(Stream.of(field), ee.getParameters().stream().map(VariableElement::getSimpleName)).collect(Collectors.joining(", ")) + ")." + ee.getSimpleName() + "(" + ee.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.joining(", ")) + ");");
                    } else {
                        pw.println("        return delegateProvider.getDelegate(true, " + Stream.concat(Stream.of(field), ee.getParameters().stream().map(VariableElement::getSimpleName)).collect(Collectors.joining(", ")) + ")." + ee.getSimpleName() + "(" + ee.getParameters().stream().map(VariableElement::getSimpleName).collect(Collectors.joining(", ")) + ");");
                    }
                    pw.println("    }");
                });
                ((PrintWriter)pw).println("}");
                autogenerated.add("        DELEGATE_CREATORS.put(" + className + ".class, (DelegateCreator<" + className + ">) " + mapClassName + "::new);");
            }
        }
    }

    private class FieldDelegateGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private FieldDelegateGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapClassName = className + "FieldDelegate";
            String mapSimpleClassName = simpleClassName + "FieldDelegate";
            String fieldsClassName = className + "Fields";
            GenerateEntityImplementations an = e.getAnnotation(GenerateEntityImplementations.class);
            TypeElement parentTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(an.inherits() == null || an.inherits().isEmpty() ? "void" : an.inherits());
            if (parentTypeElement == null) {
                return;
            }
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapClassName, new Element[0]);
            IdentityHashMap m2field = new IdentityHashMap();
            methodsPerAttribute.forEach((f, s) -> s.forEach(m -> m2field.put(m, f)));
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                GenerateEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public class " + mapSimpleClassName + (String)(an.inherits().isEmpty() ? "" : " extends " + an.inherits()) + " implements " + className + ", org.keycloak.models.map.common.delegate.HasEntityFieldDelegate<" + className + "> {");
                ((PrintWriter)pw).println("    private final org.keycloak.models.map.common.delegate.EntityFieldDelegate<" + className + "> entityFieldDelegate;");
                ((PrintWriter)pw).println("    public " + mapSimpleClassName + "(org.keycloak.models.map.common.delegate.EntityFieldDelegate<" + className + "> entityFieldDelegate) {");
                ((PrintWriter)pw).println("        this.entityFieldDelegate = entityFieldDelegate;");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    public org.keycloak.models.map.common.delegate.EntityFieldDelegate<" + className + "> getEntityFieldDelegate() {");
                ((PrintWriter)pw).println("        return this.entityFieldDelegate;");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public boolean isUpdated() {");
                ((PrintWriter)pw).println("        return entityFieldDelegate.isUpdated();");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public void clearUpdatedFlag() {");
                ((PrintWriter)pw).println("        entityFieldDelegate.clearUpdatedFlag();");
                ((PrintWriter)pw).println("    }");
                GenerateEntityImplementationsProcessor.this.getAllAbstractMethods(e).forEach(ee -> {
                    String originalField = (String)m2field.get(ee);
                    if (originalField == null) {
                        return;
                    }
                    TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(originalField, (HashSet)methodsPerAttribute.get(originalField));
                    String field = fieldsClassName + "." + GenerateEntityImplementationsProcessor.toEnumConstant(originalField);
                    FieldAccessorType fat = FieldAccessorType.determineType(ee, originalField, GenerateEntityImplementationsProcessor.this.types, fieldType);
                    this.printMethodBody(pw, fat, (ExecutableElement)ee, field, fieldType);
                });
                autogenerated.add("        ENTITY_FIELD_DELEGATE_CREATORS.put(" + className + ".class, (EntityFieldDelegateCreator<" + className + ">) " + mapClassName + "::new);");
                ((PrintWriter)pw).println("}");
            }
        }

        private boolean printMethodBody(PrintWriter pw, FieldAccessorType accessorType, ExecutableElement method, String fieldName, TypeMirror fieldType) {
            NullType firstParameterType = method.getParameters().isEmpty() ? GenerateEntityImplementationsProcessor.this.types.getNullType() : method.getParameters().get(0).asType();
            switch (accessorType) {
                case GETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method + " {");
                    pw.println("        return (" + fieldType + ") entityFieldDelegate.get(" + fieldName + ");");
                    pw.println("    }");
                    return true;
                }
                case SETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        entityFieldDelegate.set(" + fieldName + ", p0);");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_ADD: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        entityFieldDelegate.collectionAdd(" + fieldName + ", p0);");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE: {
                    String removeMethod;
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    TypeElement fieldTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType).toString());
                    String string = removeMethod = Util.isMapType(fieldTypeElement) ? "mapRemove" : "collectionRemove";
                    if (method.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("        entityFieldDelegate." + removeMethod + "(" + fieldName + ", p0);");
                    } else {
                        pw.println("        return (" + method.getReturnType() + ") entityFieldDelegate." + removeMethod + "(" + fieldName + ", p0);");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE_BY_ID: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(String p0) {");
                    if (method.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("        entityFieldDelegate.mapRemove(" + fieldName + ", p0);");
                    } else {
                        pw.println("        return (" + method.getReturnType() + ") entityFieldDelegate.mapRemove(" + fieldName + ", p0);");
                    }
                    pw.println("    }");
                    return true;
                }
                case MAP_ADD: {
                    TypeMirror secondParameterType = method.getParameters().get(1).asType();
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0, " + secondParameterType + " p1) {");
                    pw.println("        entityFieldDelegate.mapPut(" + fieldName + ", p0, p1);");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_GET_BY_ID: 
                case MAP_GET: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        return (" + method.getReturnType() + ") entityFieldDelegate.mapGet(" + fieldName + ", p0);");
                    pw.println("    }");
                    return true;
                }
            }
            return false;
        }
    }

    private class ImplGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private ImplGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            GenerateEntityImplementations an = e.getAnnotation(GenerateEntityImplementations.class);
            TypeElement parentTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(an.inherits() == null || an.inherits().isEmpty() ? "void" : an.inherits());
            if (parentTypeElement == null) {
                GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to find type " + an.inherits() + " for inherits parameter for annotation " + GenerateEntityImplementations.class.getTypeName(), e);
            }
            List<? extends Element> allParentMembers = GenerateEntityImplementationsProcessor.this.elements.getAllMembers(parentTypeElement);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapImplClassName = className + "Impl";
            String mapSimpleClassName = simpleClassName + "Impl";
            boolean hasId = methodsPerAttribute.containsKey(GenerateEntityImplementationsProcessor.ID_FIELD_NAME) || allParentMembers.stream().anyMatch(el -> "getId".equals(el.getSimpleName().toString()));
            boolean hasDeepClone = allParentMembers.stream().filter(el -> el.getKind() == ElementKind.METHOD).anyMatch(el -> "deepClone".equals(el.getSimpleName().toString()));
            boolean needsDeepClone = GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getReturnType).anyMatch(fieldType -> !GenerateEntityImplementationsProcessor.this.isKnownCollectionOfImmutableFinalTypes((TypeMirror)fieldType) && !GenerateEntityImplementationsProcessor.this.isImmutableFinalType((TypeMirror)fieldType));
            boolean usingGeneratedCloner = !hasDeepClone && needsDeepClone;
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapImplClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                ((PrintWriter)pw).println("import java.util.Objects;");
                ((PrintWriter)pw).println("import java.util.Optional;");
                ((PrintWriter)pw).println("import org.keycloak.models.map.common.DeepCloner;");
                ((PrintWriter)pw).println("// DO NOT CHANGE THIS CLASS, IT IS GENERATED AUTOMATICALLY BY " + GenerateEntityImplementationsProcessor.class.getSimpleName());
                GenerateEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public class " + mapSimpleClassName + (String)(an.inherits().isEmpty() ? "" : " extends " + an.inherits()) + " implements " + className + " {");
                ((PrintWriter)pw).println("    private " + mapSimpleClassName + "() { this(DeepCloner.DUMB_CLONER); } // Nullary constructor only for Jackson deserialization");
                ((PrintWriter)pw).println("    public " + mapSimpleClassName + "(DeepCloner cloner) { super(); " + (!usingGeneratedCloner ? "" : "this.cloner = cloner;") + "}");
                ((PrintWriter)pw).println("    @Override public boolean equals(Object o) {");
                ((PrintWriter)pw).println("        if (o == this) return true; ");
                ((PrintWriter)pw).println("        if (! (o instanceof " + mapSimpleClassName + ")) return false; ");
                ((PrintWriter)pw).println("        " + mapSimpleClassName + " other = (" + mapSimpleClassName + ") o; ");
                ((PrintWriter)pw).println("        return " + GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> "Objects.equals(" + v + "(), other." + v + "())").collect(Collectors.joining("\n          && ")) + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public int hashCode() {");
                ((PrintWriter)pw).println("        return " + (String)(hasId ? "(getId() == null ? super.hashCode() : getId().hashCode())" : "Objects.hash(" + GenerateEntityImplementationsProcessor.this.fieldGetters(methodsPerAttribute).filter(ee -> GenerateEntityImplementationsProcessor.this.isImmutableFinalType(ee.getReturnType())).map(ExecutableElement::getSimpleName).map(Object::toString).sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.GET_ID_INSTANCE).map(v -> v + "()").collect(Collectors.joining(",\n          ")) + ")") + ";");
                ((PrintWriter)pw).println("    }");
                ((PrintWriter)pw).println("    @Override public String toString() {");
                ((PrintWriter)pw).println("        return String.format(\"%s@%08x\", " + (String)(hasId ? "getId()" : "\"" + mapSimpleClassName + "\"") + ", System.identityHashCode(this));");
                ((PrintWriter)pw).println("    }");
                if (usingGeneratedCloner) {
                    ((PrintWriter)pw).println("    private final DeepCloner cloner;");
                    ((PrintWriter)pw).println("    public <V> V deepClone(V obj) {");
                    ((PrintWriter)pw).println("        return cloner.from(obj);");
                    ((PrintWriter)pw).println("    }");
                }
                methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE)).forEach(me -> {
                    HashSet methods = (HashSet)me.getValue();
                    TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType((String)me.getKey(), methods);
                    if (fieldType == null) {
                        return;
                    }
                    pw.println("");
                    pw.println("    private " + fieldType + " f" + (String)me.getKey() + ";");
                    for (ExecutableElement method : methods) {
                        FieldAccessorType fat = FieldAccessorType.determineType(method, (String)me.getKey(), GenerateEntityImplementationsProcessor.this.types, fieldType);
                        Optional<ExecutableElement> parentMethod = Util.findParentMethodImplementation(allParentMembers, method);
                        if (parentMethod.isPresent()) {
                            GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, "Method " + method + " is declared in a parent class.", method);
                            continue;
                        }
                        if (fat != FieldAccessorType.UNKNOWN && this.printMethodBody(pw, fat, method, "f" + (String)me.getKey(), fieldType)) continue;
                        GenerateEntityImplementationsProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Could not determine desired semantics of method from its signature", method);
                    }
                });
                ((PrintWriter)pw).println("    public static class Empty " + (String)(an.inherits().isEmpty() ? "" : " extends " + an.inherits()) + " implements " + className + " {");
                ((PrintWriter)pw).println("        public static final Empty INSTANCE = new Empty();");
                methodsPerAttribute.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey, AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE)).map(Map.Entry::getValue).flatMap(Collection::stream).forEach(ee -> {
                    pw.println("        @Override " + ee.getModifiers().stream().filter(m -> m != Modifier.ABSTRACT).map(Object::toString).collect(Collectors.joining(" ")) + " " + ee.getReturnType() + " " + ee.getSimpleName() + "(" + Util.methodParameters(ee.getParameters()) + ") {");
                    if (ee.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("        }");
                    } else {
                        pw.println("            return null;");
                        pw.println("        }");
                    }
                });
                GenerateEntityImplementationsProcessor.this.elements.getAllMembers(e).stream().filter(ee -> ee.getSimpleName().contentEquals("isUpdated")).filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> ee.getReturnType().getKind() == TypeKind.BOOLEAN).forEach(ee -> {
                    pw.println("        @Override " + ee.getModifiers().stream().filter(m -> m != Modifier.ABSTRACT).map(Object::toString).collect(Collectors.joining(" ")) + " " + ee.getReturnType() + " " + ee.getSimpleName() + "(" + Util.methodParameters(ee.getParameters()) + ") {");
                    pw.println("            return false;");
                    pw.println("        }");
                });
                ((PrintWriter)pw).println("    }");
                autogenerated.add("        EMPTY_INSTANCES.put(" + className + ".class, " + mapImplClassName + ".Empty.INSTANCE);");
                autogenerated.add("        CONSTRUCTORS_DC.put(" + className + ".class, " + mapImplClassName + "::new);");
                ((PrintWriter)pw).println("}");
            }
        }

        private boolean printMethodBody(PrintWriter pw, FieldAccessorType accessorType, ExecutableElement method, String fieldName, TypeMirror fieldType) {
            NullType firstParameterType = method.getParameters().isEmpty() ? GenerateEntityImplementationsProcessor.this.types.getNullType() : method.getParameters().get(0).asType();
            TypeElement typeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType).toString());
            switch (accessorType) {
                case GETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method + " {");
                    pw.println("        return " + fieldName + ";");
                    pw.println("    }");
                    return true;
                }
                case SETTER: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(fieldType)) {
                        pw.println("        p0 = " + GenerateEntityImplementationsProcessor.this.deepClone(firstParameterType, "p0") + ";");
                    }
                    if (GenerateEntityImplementationsProcessor.this.isCollection(firstParameterType)) {
                        pw.println("        if (p0 != null) {");
                        pw.println("            " + GenerateEntityImplementationsProcessor.this.removeUndefined(firstParameterType, "p0") + ";");
                        pw.println("            if (" + GenerateEntityImplementationsProcessor.this.isUndefined("p0") + ") p0 = null;");
                        pw.println("        }");
                    }
                    pw.println("        updated |= ! Objects.equals(" + fieldName + ", p0);");
                    pw.println("        " + fieldName + " = p0;");
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_ADD: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(firstParameterType)) {
                        pw.println("        p0 = " + GenerateEntityImplementationsProcessor.this.deepClone(firstParameterType, "p0") + ";");
                    }
                    if (GenerateEntityImplementationsProcessor.this.isCollection(firstParameterType)) {
                        pw.println("        if (p0 != null) " + GenerateEntityImplementationsProcessor.this.removeUndefined(firstParameterType, "p0") + ";");
                    }
                    pw.println("        if (" + GenerateEntityImplementationsProcessor.this.isUndefined("p0") + ") return;");
                    pw.println("        if (" + fieldName + " == null) { " + fieldName + " = " + GenerateEntityImplementationsProcessor.this.interfaceToImplementation(typeElement, "") + "; }");
                    if (Util.isSetType(typeElement)) {
                        pw.println("        updated |= " + fieldName + ".add(p0);");
                    } else {
                        pw.println("        " + fieldName + ".add(p0);");
                        pw.println("        updated = true;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE: {
                    boolean needsReturn = method.getReturnType().getKind() != TypeKind.VOID;
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        if (" + fieldName + " == null) { return" + (needsReturn ? " false" : "") + "; }");
                    pw.println("        boolean removed = " + fieldName + ".remove(p0)" + ("java.util.Map".equals(typeElement.getQualifiedName().toString()) ? " != null" : "") + ";");
                    pw.println("        updated |= removed;");
                    if (needsReturn) {
                        pw.println("        return removed;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_DELETE_BY_ID: {
                    boolean needsReturn = method.getReturnType().getKind() != TypeKind.VOID;
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(String p0) {");
                    pw.println("        boolean removed = " + fieldName + " != null && " + fieldName + ".removeIf(o -> Objects.equals(o." + GenerateEntityImplementationsProcessor.this.getCollectionKey(fieldType, method) + ", p0));");
                    pw.println("        updated |= removed;");
                    if (needsReturn) {
                        pw.println("        return removed;");
                    }
                    pw.println("    }");
                    return true;
                }
                case COLLECTION_GET_BY_ID: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(String p0) {");
                    pw.println("        if (" + fieldName + " == null || " + fieldName + ".isEmpty()) return Optional.empty();");
                    pw.println("        return " + fieldName + ".stream().filter(o -> Objects.equals(o." + GenerateEntityImplementationsProcessor.this.getCollectionKey(fieldType, method) + ", p0)).findFirst();");
                    pw.println("    }");
                    return true;
                }
                case MAP_ADD: {
                    TypeMirror secondParameterType = method.getParameters().get(1).asType();
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0, " + secondParameterType + " p1) {");
                    if (!GenerateEntityImplementationsProcessor.this.isImmutableFinalType(secondParameterType)) {
                        pw.println("        p1 = " + GenerateEntityImplementationsProcessor.this.deepClone(secondParameterType, "p1") + ";");
                    }
                    if (GenerateEntityImplementationsProcessor.this.isCollection(secondParameterType)) {
                        pw.println("        if (p1 != null) " + GenerateEntityImplementationsProcessor.this.removeUndefined(secondParameterType, "p1") + ";");
                    }
                    pw.println("        boolean valueUndefined = " + GenerateEntityImplementationsProcessor.this.isUndefined("p1") + ";");
                    pw.println("        if (valueUndefined) { if (" + fieldName + " != null) { updated |= " + fieldName + ".remove(p0) != null; } return; }");
                    pw.println("        if (" + fieldName + " == null) { " + fieldName + " = " + GenerateEntityImplementationsProcessor.this.interfaceToImplementation(typeElement, "") + "; }");
                    pw.println("        Object v = " + fieldName + ".put(p0, p1);");
                    pw.println("        updated |= ! Objects.equals(v, p1);");
                    pw.println("    }");
                    return true;
                }
                case MAP_GET: {
                    pw.println("    @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " " + method.getSimpleName() + "(" + firstParameterType + " p0) {");
                    pw.println("        return " + fieldName + " == null ? null : " + fieldName + ".get(p0);");
                    pw.println("    }");
                    return true;
                }
            }
            return false;
        }
    }

    private class FieldsGenerator
    implements AbstractGenerateEntityImplementationsProcessor.Generator {
        private FieldsGenerator() {
        }

        @Override
        public void generate(TypeElement e) throws IOException {
            Map<String, HashSet<ExecutableElement>> methodsPerAttribute = GenerateEntityImplementationsProcessor.this.methodsPerAttributeMapping(e);
            String className = e.getQualifiedName().toString();
            String packageName = null;
            int lastDot = className.lastIndexOf(46);
            if (lastDot > 0) {
                packageName = className.substring(0, lastDot);
            }
            String simpleClassName = className.substring(lastDot + 1);
            String mapFieldsClassName = className + "Fields";
            String mapSimpleFieldsClassName = simpleClassName + "Fields";
            JavaFileObject file = GenerateEntityImplementationsProcessor.this.processingEnv.getFiler().createSourceFile(mapFieldsClassName, new Element[0]);
            try (PrintWriterNoJavaLang pw = new PrintWriterNoJavaLang(file.openWriter());){
                if (packageName != null) {
                    ((PrintWriter)pw).println("package " + packageName + ";");
                }
                GenerateEntityImplementationsProcessor.this.generatedAnnotation(pw);
                ((PrintWriter)pw).println("public enum " + mapSimpleFieldsClassName + " implements org.keycloak.models.map.common.EntityField<" + className + "> {");
                methodsPerAttribute.keySet().stream().sorted(AbstractGenerateEntityImplementationsProcessor.NameFirstComparator.ID_INSTANCE).forEach(key -> {
                    pw.println("    " + GenerateEntityImplementationsProcessor.toEnumConstant(key) + " {");
                    this.printEntityFieldMethods(pw, className, (String)key, (HashSet)methodsPerAttribute.get(key));
                    pw.println("    },");
                });
                ((PrintWriter)pw).println("}");
                autogenerated.add("        ENTITY_FIELDS.put(" + className + ".class, " + mapFieldsClassName + ".values());");
            }
        }

        private void printEntityFieldMethods(PrintWriter pw, String className, String fieldName, HashSet<ExecutableElement> methods) {
            TypeMirror fieldType = GenerateEntityImplementationsProcessor.this.determineFieldType(fieldName, methods);
            pw.println("        public static final String FIELD_NAME = \"" + fieldName + "\";");
            pw.println("        public static final String FIELD_NAME_DASHED = \"" + fieldName.replaceAll("([^_A-Z])([A-Z])", "$1-$2").toLowerCase() + "\";");
            pw.println("        public static final String FIELD_NAME_CAMEL_CASE = \"" + fieldName.substring(0, 1).toLowerCase() + fieldName.substring(1) + "\";");
            pw.println("        @SuppressWarnings(\"unchecked\") @Override public Class<?> getFieldClass() {");
            pw.println("            return " + GenerateEntityImplementationsProcessor.this.types.erasure(fieldType) + ".class;");
            pw.println("        }");
            pw.println("        @Override public String getName() {");
            pw.println("            return FIELD_NAME;");
            pw.println("        }");
            pw.println("        @Override public String getNameDashed() {");
            pw.println("            return FIELD_NAME_DASHED;");
            pw.println("        }");
            pw.println("        @Override public String getNameCamelCase() {");
            pw.println("            return FIELD_NAME_CAMEL_CASE;");
            pw.println("        }");
            FieldAccessorType.getMethod(FieldAccessorType.GETTER, methods, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType).ifPresent(method -> {
                if (Util.isCollectionType((TypeElement)GenerateEntityImplementationsProcessor.this.types.asElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType)))) {
                    TypeMirror firstParameterType = Util.getGenericsDeclaration(method.getReturnType()).get(0);
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public Class<?> getCollectionElementClass() {");
                    pw.println("            return " + GenerateEntityImplementationsProcessor.this.types.erasure(firstParameterType) + ".class;");
                    pw.println("        }");
                } else if (Util.isMapType((TypeElement)GenerateEntityImplementationsProcessor.this.types.asElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType)))) {
                    TypeMirror firstParameterType = Util.getGenericsDeclaration(method.getReturnType()).get(0);
                    TypeMirror secondParameterType = Util.getGenericsDeclaration(method.getReturnType()).get(1);
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public Class<?> getMapKeyClass() {");
                    pw.println("            return " + GenerateEntityImplementationsProcessor.this.types.erasure(firstParameterType) + ".class;");
                    pw.println("        }");
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public Class<?> getMapValueClass() {");
                    pw.println("            return " + GenerateEntityImplementationsProcessor.this.types.erasure(secondParameterType) + ".class;");
                    pw.println("        }");
                }
            });
            for (ExecutableElement ee : methods) {
                FieldAccessorType fat = FieldAccessorType.determineType(ee, fieldName, GenerateEntityImplementationsProcessor.this.types, fieldType);
                this.printMethodBody(pw, fat, ee, className, fieldType);
            }
        }

        private void printMethodBody(PrintWriter pw, FieldAccessorType accessorType, ExecutableElement method, String className, TypeMirror fieldType) {
            NullType firstParameterType = method.getParameters().isEmpty() ? GenerateEntityImplementationsProcessor.this.types.getNullType() : method.getParameters().get(0).asType();
            switch (accessorType) {
                case GETTER: {
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public " + method.getReturnType() + " get(" + className + " e) {");
                    pw.println("            return (" + fieldType + ") e." + method.getSimpleName() + "();");
                    pw.println("        }");
                    return;
                }
                case SETTER: {
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <T> void set(" + className + " e, T value) {");
                    pw.println("            e." + method.getSimpleName() + "((" + firstParameterType + ") value);");
                    pw.println("        }");
                    return;
                }
                case COLLECTION_ADD: {
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <T> void collectionAdd(" + className + " e, T value) {");
                    pw.println("            e." + method.getSimpleName() + "((" + firstParameterType + ") value);");
                    pw.println("        }");
                    return;
                }
                case COLLECTION_DELETE: {
                    String returnType = method.getReturnType().getKind() == TypeKind.VOID ? "Void" : method.getReturnType().toString();
                    TypeElement fieldTypeElement = GenerateEntityImplementationsProcessor.this.elements.getTypeElement(GenerateEntityImplementationsProcessor.this.types.erasure(fieldType).toString());
                    if (Util.isMapType(fieldTypeElement)) {
                        pw.println("        @SuppressWarnings(\"unchecked\") @Override public <K> " + returnType + " mapRemove(" + className + " e, K p0) {");
                    } else {
                        pw.println("        @SuppressWarnings(\"unchecked\") @Override public <T> " + returnType + " collectionRemove(" + className + " e, T p0) {");
                    }
                    if (method.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("            e." + method.getSimpleName() + "((" + firstParameterType + ") p0); return null;");
                    } else {
                        pw.println("            return e." + method.getSimpleName() + "((" + firstParameterType + ") p0);");
                    }
                    pw.println("        }");
                    return;
                }
                case COLLECTION_DELETE_BY_ID: {
                    String returnType = method.getReturnType().getKind() == TypeKind.VOID ? "Void" : method.getReturnType().toString();
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <K> " + returnType + " mapRemove(" + className + " e, K p0) {");
                    if (method.getReturnType().getKind() == TypeKind.VOID) {
                        pw.println("            e." + method.getSimpleName() + "((String) p0); return null;");
                    } else {
                        pw.println("            return e." + method.getSimpleName() + "((String) p0);");
                    }
                    pw.println("        }");
                    return;
                }
                case COLLECTION_GET_BY_ID: {
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <K> " + method.getReturnType() + " mapGet(" + className + " e, K key) {");
                    pw.println("            return e." + method.getSimpleName() + "((" + firstParameterType + ") key);");
                    pw.println("        }");
                    return;
                }
                case MAP_ADD: {
                    TypeMirror secondParameterType = method.getParameters().get(1).asType();
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <K, T> void mapPut(" + className + " e, K key, T value) {");
                    pw.println("            e." + method.getSimpleName() + "((" + firstParameterType + ") key, (" + secondParameterType + ") value);");
                    pw.println("        }");
                    return;
                }
                case MAP_GET: {
                    pw.println("        @SuppressWarnings(\"unchecked\") @Override public <K> " + method.getReturnType() + " mapGet(" + className + " e, K key) {");
                    pw.println("            return (" + method.getReturnType() + ") e." + method.getSimpleName() + "((" + firstParameterType + ") key);");
                    pw.println("        }");
                }
            }
        }
    }
}

