/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.keycloak.models.map.processor.Util;

enum FieldAccessorType {
    GETTER{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            Name methodName;
            Pattern getter = Pattern.compile("(get|is)" + Pattern.quote(fieldName));
            return getter.matcher(methodName = method.getSimpleName()).matches() && method.getParameters().isEmpty() && types.isSameType(fieldType, method.getReturnType());
        }
    }
    ,
    SETTER{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            String methodName = "set" + fieldName;
            return Objects.equals(methodName, method.getSimpleName().toString()) && method.getParameters().size() == 1 && types.isSameType(fieldType, method.getParameters().get(0).asType());
        }
    }
    ,
    COLLECTION_ADD{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            String fieldNameSingular = Util.pluralToSingular(fieldName);
            String methodName = "add" + fieldNameSingular;
            List<TypeMirror> res = Util.getGenericsDeclaration(fieldType);
            return Objects.equals(methodName, method.getSimpleName().toString()) && res.size() == 1 && types.isSameType(res.get(0), method.getParameters().get(0).asType());
        }
    }
    ,
    COLLECTION_DELETE{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            String fieldNameSingular = Util.pluralToSingular(fieldName);
            String removeFromCollection = "remove" + fieldNameSingular;
            List<TypeMirror> res = Util.getGenericsDeclaration(fieldType);
            return Objects.equals(removeFromCollection, method.getSimpleName().toString()) && method.getParameters().size() == 1 && types.isSameType(res.get(0), method.getParameters().get(0).asType());
        }
    }
    ,
    MAP_ADD{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            String fieldNameSingular = Util.pluralToSingular(fieldName);
            String methodName = "set" + fieldNameSingular;
            List<TypeMirror> res = Util.getGenericsDeclaration(fieldType);
            return Objects.equals(methodName, method.getSimpleName().toString()) && res.size() == 2 && types.isSameType(res.get(0), method.getParameters().get(0).asType()) && types.isSameType(res.get(1), method.getParameters().get(1).asType());
        }
    }
    ,
    MAP_GET{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            String fieldNameSingular = Util.pluralToSingular(fieldName);
            String methodName = "get" + fieldNameSingular;
            List<TypeMirror> res = Util.getGenericsDeclaration(fieldType);
            return Objects.equals(methodName, method.getSimpleName().toString()) && res.size() == 2 && types.isSameType(res.get(0), method.getParameters().get(0).asType());
        }
    }
    ,
    UNKNOWN{

        @Override
        public boolean is(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
            return true;
        }
    };


    public abstract boolean is(ExecutableElement var1, String var2, Types var3, TypeMirror var4);

    public static Optional<ExecutableElement> getMethod(FieldAccessorType type, HashSet<ExecutableElement> methods, String fieldName, Types types, TypeMirror fieldType) {
        return methods.stream().filter(ee -> type.is((ExecutableElement)ee, fieldName, types, fieldType)).findAny();
    }

    public static FieldAccessorType determineType(ExecutableElement method, String fieldName, Types types, TypeMirror fieldType) {
        for (FieldAccessorType fat : FieldAccessorType.values()) {
            if (!fat.is(method, fieldName, types, fieldType)) continue;
            return fat;
        }
        return UNKNOWN;
    }
}

