/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.processor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import org.keycloak.models.map.annotations.IgnoreForEntityImplementationGenerator;

public class Util {
    private static final HashSet<String> SET_TYPES = new HashSet<String>(Arrays.asList(Set.class.getCanonicalName(), TreeSet.class.getCanonicalName(), HashSet.class.getCanonicalName(), LinkedHashSet.class.getCanonicalName()));
    private static final HashSet<String> MAP_TYPES = new HashSet<String>(Arrays.asList(Map.class.getCanonicalName(), HashMap.class.getCanonicalName()));

    public static List<TypeMirror> getGenericsDeclaration(TypeMirror fieldType) {
        final LinkedList<TypeMirror> res = new LinkedList<TypeMirror>();
        fieldType.accept(new SimpleTypeVisitor8<Void, List<TypeMirror>>(){

            @Override
            public Void visitDeclared(DeclaredType t, List<TypeMirror> p) {
                List<? extends TypeMirror> typeArguments = t.getTypeArguments();
                res.addAll(typeArguments);
                return null;
            }
        }, res);
        return res;
    }

    public static String methodParameters(List<? extends VariableElement> parameters) {
        return parameters.stream().map(p -> p.asType() + " " + p.getSimpleName()).collect(Collectors.joining(", "));
    }

    public static boolean isSetType(TypeElement typeElement) {
        Name name = typeElement.getQualifiedName();
        return SET_TYPES.contains(name.toString());
    }

    public static boolean isMapType(TypeElement typeElement) {
        Name name = typeElement.getQualifiedName();
        return MAP_TYPES.contains(name.toString());
    }

    public static boolean isNotIgnored(Element el) {
        do {
            IgnoreForEntityImplementationGenerator a;
            if ((a = el.getAnnotation(IgnoreForEntityImplementationGenerator.class)) == null) continue;
            return false;
        } while ((el = el.getEnclosingElement()) != null);
        return true;
    }

    protected static Optional<ExecutableElement> findParentMethodImplementation(List<? extends Element> allParentMembers, ExecutableElement method) {
        return allParentMembers.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).filter(ee -> Objects.equals(ee.toString(), method.toString())).filter(ee -> !ee.getModifiers().contains((Object)Modifier.ABSTRACT)).findAny();
    }

    public static String singularToPlural(String word) {
        return word.endsWith("y") ? word.substring(0, word.length() - 1) + "ies" : word + "s";
    }

    public static String pluralToSingular(String word) {
        return word.endsWith("ies") ? word.substring(0, word.length() - 3) + "y" : (word.endsWith("s") ? word.substring(0, word.length() - 1) : word);
    }
}

