/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.Base32;

public class OTPPolicy
implements Serializable {
    protected static final Logger logger = Logger.getLogger(OTPPolicy.class);
    protected String type;
    protected String algorithm;
    protected int initialCounter;
    protected int digits;
    protected int lookAheadWindow;
    protected int period;
    private static final Map<String, String> algToKeyUriAlg = new HashMap<String, String>();
    public static OTPPolicy DEFAULT_POLICY;

    public OTPPolicy() {
    }

    public OTPPolicy(String type, String algorithm, int initialCounter, int digits, int lookAheadWindow, int period) {
        this.type = type;
        this.algorithm = algorithm;
        this.initialCounter = initialCounter;
        this.digits = digits;
        this.lookAheadWindow = lookAheadWindow;
        this.period = period;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public int getInitialCounter() {
        return this.initialCounter;
    }

    public void setInitialCounter(int initialCounter) {
        this.initialCounter = initialCounter;
    }

    public int getDigits() {
        return this.digits;
    }

    public void setDigits(int digits) {
        this.digits = digits;
    }

    public int getLookAheadWindow() {
        return this.lookAheadWindow;
    }

    public void setLookAheadWindow(int lookAheadWindow) {
        this.lookAheadWindow = lookAheadWindow;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public String getKeyURI(RealmModel realm, UserModel user, String secret) {
        try {
            String displayName = realm.getDisplayName() != null && !realm.getDisplayName().isEmpty() ? realm.getDisplayName() : realm.getName();
            String uri = "otpauth://" + this.type + "/" + URLEncoder.encode(user.getUsername(), "UTF-8") + "?secret=" + Base32.encode(secret.getBytes()) + "&digits=" + this.digits + "&algorithm=" + algToKeyUriAlg.get(this.algorithm);
            uri = uri + "&issuer=" + URLEncoder.encode(displayName, "UTF-8");
            if (this.type.equals("hotp")) {
                uri = uri + "&counter=" + this.initialCounter;
            }
            if (this.type.equals("totp")) {
                uri = uri + "&period=" + this.period;
            }
            return uri;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        algToKeyUriAlg.put("HmacSHA1", "SHA1");
        algToKeyUriAlg.put("HmacSHA256", "SHA256");
        algToKeyUriAlg.put("HmacSHA512", "SHA512");
        DEFAULT_POLICY = new OTPPolicy("totp", "HmacSHA1", 0, 6, 1, 30);
    }
}

