/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.keycloak.hash.PasswordHashProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserCredentialValueModel;
import org.keycloak.models.UserModel;

public class PasswordPolicy
implements Serializable {
    public static final String INVALID_PASSWORD_MIN_LENGTH_MESSAGE = "invalidPasswordMinLengthMessage";
    public static final String INVALID_PASSWORD_MIN_DIGITS_MESSAGE = "invalidPasswordMinDigitsMessage";
    public static final String INVALID_PASSWORD_MIN_LOWER_CASE_CHARS_MESSAGE = "invalidPasswordMinLowerCaseCharsMessage";
    public static final String INVALID_PASSWORD_MIN_UPPER_CASE_CHARS_MESSAGE = "invalidPasswordMinUpperCaseCharsMessage";
    public static final String INVALID_PASSWORD_MIN_SPECIAL_CHARS_MESSAGE = "invalidPasswordMinSpecialCharsMessage";
    public static final String INVALID_PASSWORD_NOT_USERNAME = "invalidPasswordNotUsernameMessage";
    public static final String INVALID_PASSWORD_REGEX_PATTERN = "invalidPasswordRegexPatternMessage";
    public static final String INVALID_PASSWORD_HISTORY = "invalidPasswordHistoryMessage";
    private List<Policy> policies;
    private String policyString;

    public PasswordPolicy(String policyString) {
        if (policyString == null || policyString.length() == 0) {
            this.policyString = null;
            this.policies = Collections.emptyList();
        } else {
            this.policyString = policyString;
            this.policies = PasswordPolicy.parse(policyString);
        }
    }

    private static List<Policy> parse(String policyString) {
        String[] policies;
        LinkedList<Policy> list = new LinkedList<Policy>();
        for (String policy : policies = policyString.split(" and ")) {
            String name;
            policy = policy.trim();
            String arg = null;
            int i = policy.indexOf(40);
            if (i == -1) {
                name = policy.trim();
            } else {
                name = policy.substring(0, i).trim();
                arg = policy.substring(i + 1, policy.length() - 1);
            }
            if (name.equals("length")) {
                list.add(new Length(arg));
                continue;
            }
            if (name.equals("digits")) {
                list.add(new Digits(arg));
                continue;
            }
            if (name.equals("lowerCase")) {
                list.add(new LowerCase(arg));
                continue;
            }
            if (name.equals("upperCase")) {
                list.add(new UpperCase(arg));
                continue;
            }
            if (name.equals("specialChars")) {
                list.add(new SpecialChars(arg));
                continue;
            }
            if (name.equals("notUsername")) {
                list.add(new NotUsername(arg));
                continue;
            }
            if (name.equals("hashAlgorithm")) {
                list.add(new HashAlgorithm(arg));
                continue;
            }
            if (name.equals("hashIterations")) {
                list.add(new HashIterations(arg));
                continue;
            }
            if (name.equals("regexPattern")) {
                Pattern.compile(arg);
                list.add(new RegexPatterns(arg));
                continue;
            }
            if (name.equals("passwordHistory")) {
                list.add(new PasswordHistory(arg));
                continue;
            }
            if (name.equals("forceExpiredPasswordChange")) {
                list.add(new ForceExpiredPasswordChange(arg));
                continue;
            }
            throw new IllegalArgumentException("Unsupported policy");
        }
        return list;
    }

    public String getHashAlgorithm() {
        if (this.policies == null) {
            return "pbkdf2";
        }
        for (Policy p : this.policies) {
            if (!(p instanceof HashAlgorithm)) continue;
            return ((HashAlgorithm)p).algorithm;
        }
        return "pbkdf2";
    }

    public int getHashIterations() {
        if (this.policies == null) {
            return -1;
        }
        for (Policy p : this.policies) {
            if (!(p instanceof HashIterations)) continue;
            return ((HashIterations)p).iterations;
        }
        return -1;
    }

    public int getExpiredPasswords() {
        if (this.policies == null) {
            return -1;
        }
        for (Policy p : this.policies) {
            if (!(p instanceof PasswordHistory)) continue;
            return ((PasswordHistory)p).passwordHistoryPolicyValue;
        }
        return -1;
    }

    public int getDaysToExpirePassword() {
        if (this.policies == null) {
            return -1;
        }
        for (Policy p : this.policies) {
            if (!(p instanceof ForceExpiredPasswordChange)) continue;
            return ((ForceExpiredPasswordChange)p).daysToExpirePassword;
        }
        return -1;
    }

    public Error validate(KeycloakSession session, UserModel user, String password) {
        for (Policy p : this.policies) {
            Error error = p.validate(session, user, password);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    public Error validate(KeycloakSession session, String user, String password) {
        for (Policy p : this.policies) {
            Error error = p.validate(session, user, password);
            if (error == null) continue;
            return error;
        }
        return null;
    }

    private static int intArg(String policy, int defaultValue, String arg) {
        if (arg == null) {
            return defaultValue;
        }
        return Integer.parseInt(arg);
    }

    private static String stringArg(String policy, String defaultValue, String arg) {
        if (arg == null) {
            return defaultValue;
        }
        return arg;
    }

    public String toString() {
        return this.policyString;
    }

    private static class ForceExpiredPasswordChange
    implements Policy {
        private static final String NAME = "forceExpiredPasswordChange";
        private int daysToExpirePassword;

        public ForceExpiredPasswordChange(String arg) {
            this.daysToExpirePassword = PasswordPolicy.intArg(NAME, 365, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            return null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return null;
        }
    }

    private static class PasswordHistory
    implements Policy {
        private static final String NAME = "passwordHistory";
        private int passwordHistoryPolicyValue;

        public PasswordHistory(String arg) {
            this.passwordHistoryPolicyValue = PasswordPolicy.intArg(NAME, 3, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String user, String password) {
            return null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            if (this.passwordHistoryPolicyValue != -1) {
                PasswordHashProvider hashProvider;
                UserCredentialValueModel cred = this.getCredentialValueModel(user, "password");
                if (cred != null && (hashProvider = session.getProvider(PasswordHashProvider.class, cred.getAlgorithm())).verify(password, cred)) {
                    return new Error(PasswordPolicy.INVALID_PASSWORD_HISTORY, new Object[]{this.passwordHistoryPolicyValue});
                }
                List<UserCredentialValueModel> passwordExpiredCredentials = this.getCredentialValueModels(user, this.passwordHistoryPolicyValue - 1, "password-history");
                for (UserCredentialValueModel credential : passwordExpiredCredentials) {
                    PasswordHashProvider hashProvider2 = session.getProvider(PasswordHashProvider.class, cred.getAlgorithm());
                    if (!hashProvider2.verify(password, credential)) continue;
                    return new Error(PasswordPolicy.INVALID_PASSWORD_HISTORY, new Object[]{this.passwordHistoryPolicyValue});
                }
            }
            return null;
        }

        private UserCredentialValueModel getCredentialValueModel(UserModel user, String credType) {
            for (UserCredentialValueModel model : user.getCredentialsDirectly()) {
                if (!model.getType().equals(credType)) continue;
                return model;
            }
            return null;
        }

        private List<UserCredentialValueModel> getCredentialValueModels(UserModel user, int expiredPasswordsPolicyValue, String credType) {
            ArrayList<UserCredentialValueModel> credentialModels = new ArrayList<UserCredentialValueModel>();
            for (UserCredentialValueModel model : user.getCredentialsDirectly()) {
                if (!model.getType().equals(credType)) continue;
                credentialModels.add(model);
            }
            Collections.sort(credentialModels, new Comparator<UserCredentialValueModel>(){

                @Override
                public int compare(UserCredentialValueModel credFirst, UserCredentialValueModel credSecond) {
                    if (credFirst.getCreatedDate() > credSecond.getCreatedDate()) {
                        return -1;
                    }
                    if (credFirst.getCreatedDate() < credSecond.getCreatedDate()) {
                        return 1;
                    }
                    return 0;
                }
            });
            if (credentialModels.size() > expiredPasswordsPolicyValue) {
                return credentialModels.subList(0, expiredPasswordsPolicyValue);
            }
            return credentialModels;
        }
    }

    private static class RegexPatterns
    implements Policy {
        private static final String NAME = "regexPattern";
        private String regexPattern;

        public RegexPatterns(String arg) {
            this.regexPattern = arg;
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            Pattern pattern = Pattern.compile(this.regexPattern);
            Matcher matcher = pattern.matcher(password);
            if (!matcher.matches()) {
                return new Error(PasswordPolicy.INVALID_PASSWORD_REGEX_PATTERN, new Object[]{this.regexPattern});
            }
            return null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class SpecialChars
    implements Policy {
        private static final String NAME = "specialChars";
        private int min;

        public SpecialChars(String arg) {
            this.min = PasswordPolicy.intArg(NAME, 1, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (Character.isLetterOrDigit(c)) continue;
                ++count;
            }
            return count < this.min ? new Error(PasswordPolicy.INVALID_PASSWORD_MIN_SPECIAL_CHARS_MESSAGE, new Object[]{this.min}) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class UpperCase
    implements Policy {
        private static final String NAME = "upperCase";
        private int min;

        public UpperCase(String arg) {
            this.min = PasswordPolicy.intArg(NAME, 1, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isUpperCase(c)) continue;
                ++count;
            }
            return count < this.min ? new Error(PasswordPolicy.INVALID_PASSWORD_MIN_UPPER_CASE_CHARS_MESSAGE, new Object[]{this.min}) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class LowerCase
    implements Policy {
        private static final String NAME = "lowerCase";
        private int min;

        public LowerCase(String arg) {
            this.min = PasswordPolicy.intArg(NAME, 1, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isLowerCase(c)) continue;
                ++count;
            }
            return count < this.min ? new Error(PasswordPolicy.INVALID_PASSWORD_MIN_LOWER_CASE_CHARS_MESSAGE, new Object[]{this.min}) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class Digits
    implements Policy {
        private static final String NAME = "digits";
        private int min;

        public Digits(String arg) {
            this.min = PasswordPolicy.intArg(NAME, 1, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            int count = 0;
            for (char c : password.toCharArray()) {
                if (!Character.isDigit(c)) continue;
                ++count;
            }
            return count < this.min ? new Error(PasswordPolicy.INVALID_PASSWORD_MIN_DIGITS_MESSAGE, new Object[]{this.min}) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class Length
    implements Policy {
        private static final String NAME = "length";
        private int min;

        public Length(String arg) {
            this.min = PasswordPolicy.intArg(NAME, 8, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            return password.length() < this.min ? new Error(PasswordPolicy.INVALID_PASSWORD_MIN_LENGTH_MESSAGE, new Object[]{this.min}) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class NotUsername
    implements Policy {
        private static final String NAME = "notUsername";

        public NotUsername(String arg) {
        }

        @Override
        public Error validate(KeycloakSession session, String username, String password) {
            return username.equals(password) ? new Error(PasswordPolicy.INVALID_PASSWORD_NOT_USERNAME, new Object[0]) : null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return this.validate(session, user.getUsername(), password);
        }
    }

    private static class HashIterations
    implements Policy {
        private static final String NAME = "hashIterations";
        private int iterations;

        public HashIterations(String arg) {
            this.iterations = PasswordPolicy.intArg(NAME, 1, arg);
        }

        @Override
        public Error validate(KeycloakSession session, String user, String password) {
            return null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return null;
        }
    }

    private static class HashAlgorithm
    implements Policy {
        private static final String NAME = "hashAlgorithm";
        private String algorithm;

        public HashAlgorithm(String arg) {
            this.algorithm = PasswordPolicy.stringArg(NAME, "pbkdf2", arg);
        }

        @Override
        public Error validate(KeycloakSession session, String user, String password) {
            return null;
        }

        @Override
        public Error validate(KeycloakSession session, UserModel user, String password) {
            return null;
        }
    }

    public static class Error {
        private String message;
        private Object[] parameters;

        private Error(String message, Object ... parameters) {
            this.message = message;
            this.parameters = parameters;
        }

        public String getMessage() {
            return this.message;
        }

        public Object[] getParameters() {
            return this.parameters;
        }
    }

    private static interface Policy
    extends Serializable {
        public Error validate(KeycloakSession var1, UserModel var2, String var3);

        public Error validate(KeycloakSession var1, String var2, String var3);
    }
}

