/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.List;
import org.keycloak.migration.MigrationProvider;
import org.keycloak.migration.ModelVersion;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public class MigrateTo1_6_0 {
    public static final ModelVersion VERSION = new ModelVersion("1.6.0");

    public void migrate(KeycloakSession session) {
        MigrationProvider provider = session.getProvider(MigrationProvider.class);
        List<ProtocolMapperModel> builtinMappers = provider.getBuiltinMappers("openid-connect");
        ProtocolMapperModel localeMapper = null;
        for (ProtocolMapperModel m : builtinMappers) {
            if (!m.getName().equals("locale")) continue;
            localeMapper = m;
        }
        if (localeMapper == null) {
            throw new RuntimeException("Can't find default locale mapper");
        }
        List<RealmModel> realms = session.realms().getRealms();
        for (RealmModel realm : realms) {
            ClientModel clientModel;
            ClientModel adminConsoleClient;
            realm.setOfflineSessionIdleTimeout(2592000);
            if (realm.getRole("offline_access") == null) {
                for (RoleModel roleModel : realm.getRoles()) {
                    roleModel.setScopeParamRequired(false);
                }
                for (ClientModel clientModel2 : realm.getClients()) {
                    for (RoleModel clientRole : clientModel2.getRoles()) {
                        clientRole.setScopeParamRequired(false);
                    }
                }
                KeycloakModelUtils.setupOfflineTokens(realm);
                RoleModel role = realm.getRole("offline_access");
                for (UserModel user : session.userStorage().getUsers(realm, true)) {
                    user.grantRole(role);
                }
            }
            if ((adminConsoleClient = realm.getClientByClientId("security-admin-console")) != null && !this.localeMapperAdded(adminConsoleClient)) {
                adminConsoleClient.addProtocolMapper(localeMapper);
            }
            if ((clientModel = realm.getMasterAdminClient()).getRole(AdminRoles.CREATE_CLIENT) != null) continue;
            RoleModel role = clientModel.addRole(AdminRoles.CREATE_CLIENT);
            role.setDescription("${role_" + AdminRoles.CREATE_CLIENT + "}");
            role.setScopeParamRequired(false);
            realm.getRole(AdminRoles.ADMIN).addCompositeRole(role);
        }
    }

    private boolean localeMapperAdded(ClientModel adminConsoleClient) {
        return adminConsoleClient.getProtocolMapperByName("openid-connect", "locale") != null;
    }
}

