/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserFederationProvider;
import org.keycloak.models.UserFederationProviderFactory;
import org.keycloak.models.UserFederationProviderModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;

public class UserFederationManager
implements UserProvider {
    protected KeycloakSession session;

    public UserFederationManager(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles) {
        UserModel user = this.session.userStorage().addUser(realm, id, username, addDefaultRoles);
        return this.registerWithFederation(realm, user);
    }

    protected UserFederationProvider getFederationProvider(UserFederationProviderModel model) {
        UserFederationProviderFactory factory = (UserFederationProviderFactory)this.session.getKeycloakSessionFactory().getProviderFactory(UserFederationProvider.class, model.getProviderName());
        return factory.getInstance(this.session, model);
    }

    @Override
    public UserModel addUser(RealmModel realm, String username) {
        UserModel user = this.session.userStorage().addUser(realm, username);
        return this.registerWithFederation(realm, user);
    }

    protected UserModel registerWithFederation(RealmModel realm, UserModel user) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            if (!fed.synchronizeRegistrations()) continue;
            user.setFederationLink(federation.getId());
            return fed.register(realm, user);
        }
        return user;
    }

    protected UserFederationProvider getFederationLink(RealmModel realm, UserModel user) {
        if (user.getFederationLink() == null) {
            return null;
        }
        for (UserFederationProviderModel fed : realm.getUserFederationProviders()) {
            if (!fed.getId().equals(user.getFederationLink())) continue;
            return this.getFederationProvider(fed);
        }
        return null;
    }

    @Override
    public boolean removeUser(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            return link.removeUser(realm, user);
        }
        return this.session.userStorage().removeUser(realm, user);
    }

    protected void validateUser(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null && !link.isValid(user)) {
            this.deleteInvalidUser(realm, user);
            throw new IllegalStateException("Federated user no longer valid");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteInvalidUser(RealmModel realm, UserModel user) {
        KeycloakSession tx = this.session.getKeycloakSessionFactory().create();
        try {
            tx.getTransaction().begin();
            RealmModel realmModel = tx.realms().getRealm(realm.getId());
            UserModel deletedUser = tx.userStorage().getUserById(user.getId(), realmModel);
            tx.userStorage().removeUser(realmModel, deletedUser);
            tx.getTransaction().commit();
        }
        finally {
            tx.close();
        }
    }

    protected boolean isValid(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            return link.isValid(user);
        }
        return true;
    }

    protected UserModel validateAndProxyUser(RealmModel realm, UserModel user) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            if (this.isValid(realm, user)) {
                return link.proxy(user);
            }
            this.deleteInvalidUser(realm, user);
            return null;
        }
        return user;
    }

    @Override
    public void addSocialLink(RealmModel realm, UserModel user, SocialLinkModel socialLink) {
        this.validateUser(realm, user);
        this.session.userStorage().addSocialLink(realm, user, socialLink);
    }

    @Override
    public boolean removeSocialLink(RealmModel realm, UserModel user, String socialProvider) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().removeSocialLink(realm, user, socialProvider);
    }

    @Override
    public UserModel getUserById(String id, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserById(id, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public UserModel getUserByUsername(String username, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByUsername(username, realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByUsername(realm, username);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserByEmail(String email, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserByEmail(email, realm);
        if (user != null && (user = this.validateAndProxyUser(realm, user)) != null) {
            return user;
        }
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            user = fed.getUserByEmail(realm, email);
            if (user == null) continue;
            return user;
        }
        return user;
    }

    @Override
    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        UserModel user = this.session.userStorage().getUserBySocialLink(socialLink, realm);
        if (user != null) {
            user = this.validateAndProxyUser(realm, user);
        }
        return user;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm) {
        return this.getUsers(realm, 0, 0x7FFFFFFE);
    }

    @Override
    public int getUsersCount(RealmModel realm) {
        return this.session.userStorage().getUsersCount(realm);
    }

    protected List<UserModel> query(PaginatedQuery pagedQuery, RealmModel realm, int firstResult, int maxResults) {
        LinkedList<UserModel> results = new LinkedList<UserModel>();
        if (maxResults <= 0) {
            return results;
        }
        int first = firstResult;
        int max = maxResults;
        List<UserModel> query;
        while ((query = pagedQuery.query(realm, first, max)) != null && query.size() != 0) {
            int added = 0;
            for (UserModel user : query) {
                if ((user = this.validateAndProxyUser(realm, user)) == null) continue;
                results.add(user);
                ++added;
            }
            if (results.size() == maxResults) {
                return results;
            }
            if (query.size() < max) {
                return results;
            }
            first = query.size();
            max -= added;
        }
        return results;
    }

    @Override
    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().getUsers(realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    void federationLoad(RealmModel realm, Map<String, String> attributes) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.searchByAttributes(attributes, realm, 30);
        }
    }

    @Override
    public List<UserModel> searchForUser(final String search, RealmModel realm, int firstResult, int maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int spaceIndex = search.lastIndexOf(32);
        if (spaceIndex > -1) {
            String firstName = search.substring(0, spaceIndex).trim();
            String lastName = search.substring(spaceIndex).trim();
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
        } else if (search.indexOf(64) > -1) {
            attributes.put("username", search.trim());
            attributes.put("email", search.trim());
        } else {
            attributes.put("lastName", search.trim());
            attributes.put("username", search.trim());
        }
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUser(search, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.searchForUserByAttributes(attributes, realm, 0, 0x7FFFFFFE);
    }

    @Override
    public List<UserModel> searchForUserByAttributes(final Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        this.federationLoad(realm, attributes);
        return this.query(new PaginatedQuery(){

            @Override
            public List<UserModel> query(RealmModel realm, int first, int max) {
                return UserFederationManager.this.session.userStorage().searchForUserByAttributes(attributes, realm, first, max);
            }
        }, realm, firstResult, maxResults);
    }

    @Override
    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getSocialLinks(user, realm);
    }

    @Override
    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        this.validateUser(realm, user);
        if (user == null) {
            throw new IllegalStateException("Federated user no longer valid");
        }
        return this.session.userStorage().getSocialLink(user, socialProvider, realm);
    }

    @Override
    public void preRemove(RealmModel realm) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm);
        }
        this.session.userStorage().preRemove(realm);
    }

    @Override
    public void preRemove(RealmModel realm, RoleModel role) {
        for (UserFederationProviderModel federation : realm.getUserFederationProviders()) {
            UserFederationProvider fed = this.getFederationProvider(federation);
            fed.preRemove(realm, role);
        }
        this.session.userStorage().preRemove(realm, role);
    }

    public void updateCredential(RealmModel realm, UserModel user, UserCredentialModel credential) {
        String error;
        if (credential.getType().equals("password") && realm.getPasswordPolicy() != null && (error = realm.getPasswordPolicy().validate(credential.getValue())) != null) {
            throw new ModelException(error);
        }
        user.updateCredential(credential);
    }

    @Override
    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            this.validateUser(realm, user);
            Set<String> supportedCredentialTypes = link.getSupportedCredentialTypes(user);
            if (supportedCredentialTypes.size() > 0) {
                ArrayList<UserCredentialModel> fedCreds = new ArrayList<UserCredentialModel>();
                ArrayList<UserCredentialModel> localCreds = new ArrayList<UserCredentialModel>();
                for (UserCredentialModel cred : input) {
                    if (supportedCredentialTypes.contains(cred.getType())) {
                        fedCreds.add(cred);
                        continue;
                    }
                    localCreds.add(cred);
                }
                if (!link.validCredentials(realm, user, fedCreds)) {
                    return false;
                }
                return this.session.userStorage().validCredentials(realm, user, localCreds);
            }
        }
        return this.session.userStorage().validCredentials(realm, user, input);
    }

    @Override
    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        UserFederationProvider link = this.getFederationLink(realm, user);
        if (link != null) {
            this.validateUser(realm, user);
            Set<String> supportedCredentialTypes = link.getSupportedCredentialTypes(user);
            if (supportedCredentialTypes.size() > 0) {
                ArrayList<UserCredentialModel> fedCreds = new ArrayList<UserCredentialModel>();
                ArrayList<UserCredentialModel> localCreds = new ArrayList<UserCredentialModel>();
                for (UserCredentialModel cred : input) {
                    if (supportedCredentialTypes.contains(cred.getType())) {
                        fedCreds.add(cred);
                        continue;
                    }
                    localCreds.add(cred);
                }
                if (!link.validCredentials(realm, user, fedCreds)) {
                    return false;
                }
                return this.session.userStorage().validCredentials(realm, user, localCreds);
            }
        }
        return this.session.userStorage().validCredentials(realm, user, input);
    }

    @Override
    public void close() {
    }

    static interface PaginatedQuery {
        public List<UserModel> query(RealmModel var1, int var2, int var3);
    }
}

