/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.cache.CacheUserProvider;

public class NoCacheUserProvider
implements CacheUserProvider {
    protected KeycloakSession session;
    protected UserProvider delegate;

    public NoCacheUserProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public boolean isEnabled() {
        return false;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public UserProvider getDelegate() {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.delegate = (UserProvider)this.session.getProvider(UserProvider.class);
        return this.delegate;
    }

    @Override
    public void registerUserInvalidation(RealmModel realm, String id) {
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return this.getDelegate().getUserById(id, realm);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        return this.getDelegate().getUserByUsername(username, realm);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return this.getDelegate().getUserByEmail(email, realm);
    }

    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        return this.getDelegate().getUserBySocialLink(socialLink, realm);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getDelegate().getUsers(realm);
    }

    public int getUsersCount(RealmModel realm) {
        return this.getDelegate().getUsersCount(realm);
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().getUsers(realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUser(search, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm, int firstResult, int maxResults) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm, firstResult, maxResults);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        return this.getDelegate().getSocialLinks(user, realm);
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        return this.getDelegate().getSocialLink(user, socialProvider, realm);
    }

    public UserModel addUser(RealmModel realm, String id, String username, boolean addDefaultRoles) {
        return this.getDelegate().addUser(realm, id, username, addDefaultRoles);
    }

    public UserModel addUser(RealmModel realm, String username) {
        return this.getDelegate().addUser(realm, username);
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        return this.getDelegate().removeUser(realm, user);
    }

    public void addSocialLink(RealmModel realm, UserModel user, SocialLinkModel socialLink) {
        this.getDelegate().addSocialLink(realm, user, socialLink);
    }

    public boolean removeSocialLink(RealmModel realm, UserModel user, String socialProvider) {
        return this.getDelegate().removeSocialLink(realm, user, socialProvider);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, List<UserCredentialModel> input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public boolean validCredentials(RealmModel realm, UserModel user, UserCredentialModel ... input) {
        return this.getDelegate().validCredentials(realm, user, input);
    }

    public void preRemove(RealmModel realm) {
        this.getDelegate().preRemove(realm);
    }

    public void preRemove(RealmModel realm, RoleModel role) {
        this.getDelegate().preRemove(realm, role);
    }
}

