/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.entities;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.models.RoleModel;

public class CachedRole {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final boolean composite;
    protected final Set<String> composites = new HashSet<String>();

    public CachedRole(RoleModel model) {
        this.composite = model.isComposite();
        this.description = model.getDescription();
        this.id = model.getId();
        this.name = model.getName();
        if (this.composite) {
            for (RoleModel child : model.getComposites()) {
                this.composites.add(child.getId());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isComposite() {
        return this.composite;
    }

    public Set<String> getComposites() {
        return this.composites;
    }
}

