/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.models.cache.KeycloakCache;
import org.keycloak.models.cache.entities.CachedApplication;
import org.keycloak.models.cache.entities.CachedOAuthClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;

public class SimpleCache
implements KeycloakCache {
    protected ConcurrentHashMap<String, CachedRealm> realmCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedRealm> realmCacheByName = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedApplication> applicationCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedOAuthClient> clientCache = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, CachedRole> roleCache = new ConcurrentHashMap();

    @Override
    public void clear() {
        this.realmCache.clear();
        this.realmCacheByName.clear();
        this.applicationCache.clear();
        this.clientCache.clear();
        this.roleCache.clear();
    }

    @Override
    public CachedRealm getCachedRealm(String id) {
        return this.realmCache.get(id);
    }

    @Override
    public void invalidateCachedRealm(CachedRealm realm) {
        this.realmCache.remove(realm.getId());
        this.realmCacheByName.remove(realm.getName());
    }

    @Override
    public void invalidateCachedRealmById(String id) {
        CachedRealm cached = this.realmCache.remove(id);
        if (cached != null) {
            this.realmCacheByName.remove(cached.getName());
        }
    }

    @Override
    public void addCachedRealm(CachedRealm realm) {
        this.realmCache.put(realm.getId(), realm);
        this.realmCacheByName.put(realm.getName(), realm);
    }

    @Override
    public CachedRealm getCachedRealmByName(String name) {
        return this.realmCacheByName.get(name);
    }

    @Override
    public CachedApplication getApplication(String id) {
        return this.applicationCache.get(id);
    }

    @Override
    public void invalidateApplication(CachedApplication app) {
        this.applicationCache.remove(app.getId());
    }

    @Override
    public void addCachedApplication(CachedApplication app) {
        this.applicationCache.put(app.getId(), app);
    }

    @Override
    public void invalidateCachedApplicationById(String id) {
        this.applicationCache.remove(id);
    }

    @Override
    public CachedOAuthClient getOAuthClient(String id) {
        return this.clientCache.get(id);
    }

    @Override
    public void invalidateOAuthClient(CachedOAuthClient client) {
        this.clientCache.remove(client.getId());
    }

    @Override
    public void addCachedOAuthClient(CachedOAuthClient client) {
        this.clientCache.put(client.getId(), client);
    }

    @Override
    public void invalidateCachedOAuthClientById(String id) {
        this.clientCache.remove(id);
    }

    @Override
    public CachedRole getRole(String id) {
        return this.roleCache.get(id);
    }

    @Override
    public void invalidateRole(CachedRole role) {
        this.roleCache.remove(role);
    }

    @Override
    public void invalidateRoleById(String id) {
        this.roleCache.remove(id);
    }

    @Override
    public void addCachedRole(CachedRole role) {
        this.roleCache.put(role.getId(), role);
    }

    @Override
    public void invalidateCachedRoleById(String id) {
        this.roleCache.remove(id);
    }
}

