/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UsernameLoginFailureModel;
import org.keycloak.models.cache.CacheKeycloakSession;
import org.keycloak.provider.ProviderSession;

public class NoCacheKeycloakSession
implements CacheKeycloakSession {
    protected ProviderSession providerSession;
    protected KeycloakSession sessionDelegate;
    protected KeycloakTransaction transactionDelegate;
    protected boolean transactionActive;
    protected boolean setRollbackOnly;

    public NoCacheKeycloakSession(ProviderSession providerSession) {
        this.providerSession = providerSession;
    }

    @Override
    public KeycloakSession getDelegate() {
        if (!this.transactionActive) {
            throw new IllegalStateException("Cannot access delegate without a transaction");
        }
        if (this.sessionDelegate != null) {
            return this.sessionDelegate;
        }
        this.sessionDelegate = (KeycloakSession)this.providerSession.getProvider(KeycloakSession.class);
        this.transactionDelegate = this.sessionDelegate.getTransaction();
        if (!this.transactionDelegate.isActive()) {
            this.transactionDelegate.begin();
            if (this.setRollbackOnly) {
                this.transactionDelegate.setRollbackOnly();
            }
        }
        return this.sessionDelegate;
    }

    @Override
    public void registerRealmInvalidation(String id) {
    }

    @Override
    public void registerApplicationInvalidation(String id) {
    }

    @Override
    public void registerRoleInvalidation(String id) {
    }

    @Override
    public void registerOAuthClientInvalidation(String id) {
    }

    public KeycloakTransaction getTransaction() {
        return new KeycloakTransaction(){

            public void begin() {
                NoCacheKeycloakSession.this.transactionActive = true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void commit() {
                if (NoCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                NoCacheKeycloakSession.this.sessionDelegate.getTransaction().commit();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void rollback() {
                NoCacheKeycloakSession.this.setRollbackOnly = true;
                if (NoCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                NoCacheKeycloakSession.this.sessionDelegate.getTransaction().rollback();
            }

            public void setRollbackOnly() {
                NoCacheKeycloakSession.this.setRollbackOnly = true;
                if (NoCacheKeycloakSession.this.sessionDelegate == null) {
                    return;
                }
                NoCacheKeycloakSession.this.sessionDelegate.getTransaction().setRollbackOnly();
                NoCacheKeycloakSession.this.setRollbackOnly = true;
            }

            public boolean getRollbackOnly() {
                return NoCacheKeycloakSession.this.setRollbackOnly;
            }

            public boolean isActive() {
                return NoCacheKeycloakSession.this.transactionActive;
            }
        };
    }

    public RealmModel createRealm(String name) {
        return this.getDelegate().createRealm(name);
    }

    public RealmModel createRealm(String id, String name) {
        return this.getDelegate().createRealm(id, name);
    }

    public RealmModel getRealm(String id) {
        return this.getDelegate().getRealm(id);
    }

    public RealmModel getRealmByName(String name) {
        return this.getDelegate().getRealmByName(name);
    }

    public UserModel getUserById(String id, RealmModel realm) {
        return this.getDelegate().getUserById(id, realm);
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        return this.getDelegate().getUserByUsername(username, realm);
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        return this.getDelegate().getUserByEmail(email, realm);
    }

    public List<RealmModel> getRealms() {
        return this.getDelegate().getRealms();
    }

    public boolean removeRealm(String id) {
        return this.getDelegate().removeRealm(id);
    }

    public void removeAllData() {
        this.getDelegate().removeAllData();
    }

    public void close() {
        if (this.sessionDelegate != null) {
            this.sessionDelegate.close();
        }
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink, RealmModel realm) {
        return this.getDelegate().getUserBySocialLink(socialLink, realm);
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return this.getDelegate().getUsers(realm);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.getDelegate().searchForUser(search, realm);
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes, RealmModel realm) {
        return this.getDelegate().searchForUserByAttributes(attributes, realm);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user, RealmModel realm) {
        return this.getDelegate().getSocialLinks(user, realm);
    }

    public SocialLinkModel getSocialLink(UserModel user, String socialProvider, RealmModel realm) {
        return this.getDelegate().getSocialLink(user, socialProvider, realm);
    }

    public RoleModel getRoleById(String id, RealmModel realm) {
        return this.getDelegate().getRoleById(id, realm);
    }

    public ApplicationModel getApplicationById(String id, RealmModel realm) {
        return this.getDelegate().getApplicationById(id, realm);
    }

    public OAuthClientModel getOAuthClientById(String id, RealmModel realm) {
        return this.getDelegate().getOAuthClientById(id, realm);
    }

    public UsernameLoginFailureModel getUserLoginFailure(String username, RealmModel realm) {
        return this.getDelegate().getUserLoginFailure(username, realm);
    }

    public UsernameLoginFailureModel addUserLoginFailure(String username, RealmModel realm) {
        return this.getDelegate().addUserLoginFailure(username, realm);
    }

    public List<UsernameLoginFailureModel> getAllUserLoginFailures(RealmModel realm) {
        return this.getDelegate().getAllUserLoginFailures(realm);
    }

    public UserSessionModel createUserSession(RealmModel realm, UserModel user, String ipAddress) {
        return this.getDelegate().createUserSession(realm, user, ipAddress);
    }

    public UserSessionModel getUserSession(String id, RealmModel realm) {
        return this.getDelegate().getUserSession(id, realm);
    }

    public List<UserSessionModel> getUserSessions(UserModel user, RealmModel realm) {
        return this.getDelegate().getUserSessions(user, realm);
    }

    public Set<UserSessionModel> getUserSessions(RealmModel realm, ClientModel client) {
        return this.getDelegate().getUserSessions(realm, client);
    }

    public int getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getDelegate().getActiveUserSessions(realm, client);
    }

    public void removeUserSession(UserSessionModel session) {
        this.getDelegate().removeUserSession(session);
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.getDelegate().removeUserSessions(realm, user);
    }

    public void removeExpiredUserSessions(RealmModel realm) {
        this.getDelegate().removeExpiredUserSessions(realm);
    }

    public void removeUserSessions(RealmModel realm) {
        this.getDelegate().removeUserSessions(realm);
    }
}

