/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.cache.RealmCache;
import org.keycloak.models.cache.entities.CachedClient;
import org.keycloak.models.cache.entities.CachedRealm;
import org.keycloak.models.cache.entities.CachedRole;

public class InfinispanRealmCache
implements RealmCache {
    protected static final Logger logger = Logger.getLogger(InfinispanRealmCache.class);
    protected final Cache<String, Object> cache;
    protected final ConcurrentHashMap<String, String> realmLookup;
    protected volatile boolean enabled = true;

    public InfinispanRealmCache(Cache<String, Object> cache, ConcurrentHashMap<String, String> realmLookup) {
        this.cache = cache;
        this.realmLookup = realmLookup;
    }

    public void clear() {
        this.cache.clear();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.clear();
        this.enabled = enabled;
        this.clear();
    }

    public CachedRealm getCachedRealm(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.get(id, CachedRealm.class);
    }

    public void invalidateCachedRealm(CachedRealm realm) {
        logger.tracev("Invalidating realm {0}", (Object)realm.getId());
        this.cache.remove((Object)realm.getId());
        this.realmLookup.remove(realm.getName());
    }

    public void invalidateCachedRealmById(String id) {
        CachedRealm cached = (CachedRealm)this.cache.remove((Object)id);
        if (cached != null) {
            this.realmLookup.remove(cached.getName());
        }
    }

    public void addCachedRealm(CachedRealm realm) {
        if (!this.enabled) {
            return;
        }
        logger.tracev("Adding realm {0}", (Object)realm.getId());
        this.cache.put((Object)realm.getId(), (Object)realm);
        this.realmLookup.put(realm.getName(), realm.getId());
    }

    public CachedRealm getCachedRealmByName(String name) {
        if (!this.enabled) {
            return null;
        }
        String id = this.realmLookup.get(name);
        return id != null ? this.getCachedRealm(id) : null;
    }

    public CachedClient getApplication(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.get(id, CachedClient.class);
    }

    public void invalidateApplication(CachedClient app) {
        logger.tracev("Removing application {0}", (Object)app.getId());
        this.cache.remove((Object)app.getId());
    }

    public void addCachedClient(CachedClient app) {
        if (!this.enabled) {
            return;
        }
        logger.tracev("Adding application {0}", (Object)app.getId());
        this.cache.put((Object)app.getId(), (Object)app);
    }

    public void invalidateCachedApplicationById(String id) {
        logger.tracev("Removing application {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public CachedRole getRole(String id) {
        if (!this.enabled) {
            return null;
        }
        return this.get(id, CachedRole.class);
    }

    public void invalidateRole(CachedRole role) {
        logger.tracev("Removing role {0}", (Object)role.getId());
        this.cache.remove((Object)role);
    }

    public void invalidateRoleById(String id) {
        logger.tracev("Removing role {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    public void addCachedRole(CachedRole role) {
        if (!this.enabled) {
            return;
        }
        logger.tracev("Adding role {0}", (Object)role.getId());
        this.cache.put((Object)role.getId(), (Object)role);
    }

    public void invalidateCachedRoleById(String id) {
        logger.tracev("Removing role {0}", (Object)id);
        this.cache.remove((Object)id);
    }

    private <T> T get(String id, Class<T> type) {
        Object o = this.cache.get((Object)id);
        return o != null && type.isInstance(o) ? (T)type.cast(o) : null;
    }
}

