/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.keycloak.freemarker.Theme;

public class FolderTheme
implements Theme {
    private String parentName;
    private String importName;
    private File themeDir;
    private Theme.Type type;
    private final Properties properties;

    public FolderTheme(File themeDir, Theme.Type type) throws IOException {
        this.themeDir = themeDir;
        this.type = type;
        this.properties = new Properties();
        File propertiesFile = new File(themeDir, "theme.properties");
        if (propertiesFile.isFile()) {
            this.properties.load(new FileInputStream(propertiesFile));
            this.parentName = this.properties.getProperty("parent");
            this.importName = this.properties.getProperty("import");
        }
    }

    public String getName() {
        return this.themeDir.getName();
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getImportName() {
        return this.importName;
    }

    public Theme.Type getType() {
        return this.type;
    }

    public URL getTemplate(String name) throws IOException {
        File file = new File(this.themeDir, name);
        return file.isFile() ? file.toURI().toURL() : null;
    }

    public InputStream getTemplateAsStream(String name) throws IOException {
        URL url = this.getTemplate(name);
        return url != null ? url.openStream() : null;
    }

    public URL getResource(String path) throws IOException {
        File file;
        if (File.separatorChar != '/') {
            path = path.replace('/', File.separatorChar);
        }
        return (file = new File(this.themeDir, "/resources/" + path)).isFile() ? file.toURI().toURL() : null;
    }

    public InputStream getResourceAsStream(String path) throws IOException {
        URL url = this.getResource(path);
        return url != null ? url.openStream() : null;
    }

    public Properties getMessages() throws IOException {
        Properties m = new Properties();
        File file = new File(this.themeDir, "messages" + File.separator + "messages.properties");
        if (file.isFile()) {
            m.load(new FileInputStream(file));
        }
        return m;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

