/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.singlefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportSessionTask;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.util.JsonSerialization;

public class SingleFileImportProvider
implements ImportProvider {
    private static final Logger logger = Logger.getLogger(SingleFileImportProvider.class);
    private File file;

    public SingleFileImportProvider(File file) {
        this.file = file;
    }

    public void importModel(KeycloakSessionFactory factory, final Strategy strategy) throws IOException {
        logger.infof("Full importing from file %s", (Object)this.file.getAbsolutePath());
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)factory, (KeycloakSessionTask)new ExportImportSessionTask(){

            protected void runExportImportTask(KeycloakSession session) throws IOException {
                FileInputStream is = new FileInputStream(SingleFileImportProvider.this.file);
                ImportUtils.importFromStream((KeycloakSession)session, (ObjectMapper)JsonSerialization.mapper, (InputStream)is, (Strategy)strategy);
            }
        });
    }

    public void importRealm(KeycloakSessionFactory factory, String realmName, Strategy strategy) throws IOException {
        this.importModel(factory, strategy);
    }

    public void close() {
    }
}

