/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.dir;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.ImportProvider;
import org.keycloak.exportimport.Strategy;
import org.keycloak.exportimport.util.ExportImportJob;
import org.keycloak.exportimport.util.ExportImportUtils;
import org.keycloak.exportimport.util.ImportUtils;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.util.JsonSerialization;

public class DirImportProvider
implements ImportProvider {
    private static final Logger logger = Logger.getLogger(DirImportProvider.class);
    private final File rootDirectory;

    public DirImportProvider() {
        String tempDir = System.getProperty("java.io.tmpdir");
        this.rootDirectory = new File(tempDir + "/keycloak-export");
        if (!this.rootDirectory.exists()) {
            throw new IllegalStateException("Directory " + this.rootDirectory + " doesn't exists");
        }
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public DirImportProvider(File rootDirectory) {
        this.rootDirectory = rootDirectory;
        logger.infof("Importing from directory %s", (Object)this.rootDirectory.getAbsolutePath());
    }

    public void importModel(KeycloakSessionFactory factory, Strategy strategy) throws IOException {
        File[] realmFiles = this.rootDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("-realm.json");
            }
        });
        ArrayList<String> realmNames = new ArrayList<String>();
        for (File file : realmFiles) {
            String fileName = file.getName();
            String realmName = fileName.substring(0, fileName.length() - 11);
            if (Config.getAdminRealm().equals(realmName)) {
                realmNames.add(0, realmName);
                continue;
            }
            realmNames.add(realmName);
        }
        for (String realmName : realmNames) {
            this.importRealm(factory, realmName, strategy);
        }
    }

    public void importRealm(KeycloakSessionFactory factory, final String realmName, final Strategy strategy) throws IOException {
        File realmFile = new File(this.rootDirectory + File.separator + realmName + "-realm.json");
        File[] userFiles = this.rootDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(realmName) && name.endsWith(".json") && name.substring(realmName.length()).contains("-users-");
            }
        });
        FileInputStream is = new FileInputStream(realmFile);
        final RealmRepresentation realmRep = (RealmRepresentation)JsonSerialization.readValue((InputStream)is, RealmRepresentation.class);
        ExportImportUtils.runJobInTransaction((KeycloakSessionFactory)factory, (ExportImportJob)new ExportImportJob(){

            public void run(KeycloakSession session) throws IOException {
                ImportUtils.importRealm((KeycloakSession)session, (RealmRepresentation)realmRep, (Strategy)strategy);
            }
        });
        for (File userFile : userFiles) {
            final FileInputStream fis = new FileInputStream(userFile);
            ExportImportUtils.runJobInTransaction((KeycloakSessionFactory)factory, (ExportImportJob)new ExportImportJob(){

                public void run(KeycloakSession session) throws IOException {
                    ImportUtils.importUsersFromStream((KeycloakSession)session, (String)realmName, (ObjectMapper)JsonSerialization.mapper, (InputStream)fis);
                }
            });
        }
    }

    public void close() {
    }
}

