/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.exportimport.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.exportimport.Strategy;
import org.keycloak.models.AdminRoles;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RealmProvider;
import org.keycloak.models.RoleModel;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public class ImportUtils {
    private static final Logger logger = Logger.getLogger(ImportUtils.class);

    public static RealmModel importRealm(KeycloakSession session, RealmRepresentation rep, Strategy strategy) {
        String realmName = rep.getRealm();
        RealmProvider model = session.realms();
        RealmModel realm = model.getRealmByName(realmName);
        if (realm != null) {
            if (strategy == Strategy.IGNORE_EXISTING) {
                logger.infof("Realm '%s' already exists. Import skipped", (Object)realmName);
                return realm;
            }
            logger.infof("Realm '%s' already exists. Removing it before import", (Object)realmName);
            if (Config.getAdminRealm().equals(realm.getId())) {
                for (RealmModel currRealm : model.getRealms()) {
                    currRealm.setMasterAdminApp(null);
                }
            }
            model.removeRealm(realm.getId());
        }
        realm = rep.getId() != null ? model.createRealm(rep.getId(), realmName) : model.createRealm(realmName);
        RepresentationToModel.importRealm((KeycloakSession)session, (RealmRepresentation)rep, (RealmModel)realm);
        ImportUtils.refreshMasterAdminApps(model, realm);
        if (System.getProperty("keycloak.migration.action") != null) {
            logger.infof("Realm '%s' imported", (Object)realmName);
        }
        return realm;
    }

    private static void refreshMasterAdminApps(RealmProvider model, RealmModel realm) {
        String adminRealmId = Config.getAdminRealm();
        if (adminRealmId.equals(realm.getId())) {
            RealmModel adminRealm = realm;
            for (RealmModel currentRealm : model.getRealms()) {
                ApplicationModel masterApp = adminRealm.getApplicationByName(KeycloakModelUtils.getMasterRealmAdminApplicationName((RealmModel)currentRealm));
                if (masterApp != null) {
                    currentRealm.setMasterAdminApp(masterApp);
                    continue;
                }
                ImportUtils.setupMasterAdminManagement(model, currentRealm);
            }
        } else {
            RealmModel adminRealm = model.getRealm(adminRealmId);
            ApplicationModel masterApp = adminRealm.getApplicationByName(KeycloakModelUtils.getMasterRealmAdminApplicationName((RealmModel)realm));
            if (masterApp != null) {
                realm.setMasterAdminApp(masterApp);
            } else {
                ImportUtils.setupMasterAdminManagement(model, realm);
            }
        }
    }

    public static void setupMasterAdminManagement(RealmProvider model, RealmModel realm) {
        RoleModel adminRole;
        RealmModel adminRealm;
        if (realm.getName().equals(Config.getAdminRealm())) {
            adminRealm = realm;
            adminRole = realm.addRole(AdminRoles.ADMIN);
            RoleModel createRealmRole = realm.addRole(AdminRoles.CREATE_REALM);
            adminRole.addCompositeRole(createRealmRole);
            createRealmRole.setDescription("${role_" + AdminRoles.CREATE_REALM + "}");
        } else {
            adminRealm = model.getRealmByName(Config.getAdminRealm());
            adminRole = adminRealm.getRole(AdminRoles.ADMIN);
        }
        adminRole.setDescription("${role_" + AdminRoles.ADMIN + "}");
        ApplicationModel realmAdminApp = KeycloakModelUtils.createApplication((RealmModel)adminRealm, (String)KeycloakModelUtils.getMasterRealmAdminApplicationName((RealmModel)realm));
        realmAdminApp.setBearerOnly(true);
        realm.setMasterAdminApp(realmAdminApp);
        for (String r : AdminRoles.ALL_REALM_ROLES) {
            RoleModel role = realmAdminApp.addRole(r);
            role.setDescription("${role_" + r + "}");
            adminRole.addCompositeRole(role);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importFromStream(KeycloakSession session, ObjectMapper mapper, InputStream is, Strategy strategy) throws IOException {
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonParser parser = factory.createJsonParser(is);){
            parser.nextToken();
            if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                parser.nextToken();
                ArrayList<RealmRepresentation> realmReps = new ArrayList<RealmRepresentation>();
                while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    RealmRepresentation realmRep = (RealmRepresentation)parser.readValueAs(RealmRepresentation.class);
                    parser.nextToken();
                    if (Config.getAdminRealm().equals(realmRep.getRealm())) {
                        realmReps.add(0, realmRep);
                        continue;
                    }
                    realmReps.add(realmRep);
                }
                for (RealmRepresentation realmRep : realmReps) {
                    ImportUtils.importRealm(session, realmRep, strategy);
                }
            } else if (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                RealmRepresentation realmRep = (RealmRepresentation)parser.readValueAs(RealmRepresentation.class);
                ImportUtils.importRealm(session, realmRep, strategy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void importUsersFromStream(KeycloakSession session, String realmName, ObjectMapper mapper, InputStream is) throws IOException {
        RealmProvider model = session.realms();
        JsonFactory factory = mapper.getJsonFactory();
        try (JsonParser parser = factory.createJsonParser(is);){
            parser.nextToken();
            while (parser.nextToken() == JsonToken.FIELD_NAME) {
                if ("realm".equals(parser.getText())) {
                    parser.nextToken();
                    String currRealmName = parser.getText();
                    if (currRealmName.equals(realmName)) continue;
                    throw new IllegalStateException("Trying to import users into invalid realm. Realm name: " + realmName + ", Expected realm name: " + currRealmName);
                }
                if (!"users".equals(parser.getText())) continue;
                parser.nextToken();
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    parser.nextToken();
                }
                ArrayList<UserRepresentation> userReps = new ArrayList<UserRepresentation>();
                while (parser.getCurrentToken() == JsonToken.START_OBJECT) {
                    UserRepresentation user = (UserRepresentation)parser.readValueAs(UserRepresentation.class);
                    userReps.add(user);
                    parser.nextToken();
                }
                ImportUtils.importUsers(session, model, realmName, userReps);
                if (parser.getCurrentToken() != JsonToken.END_ARRAY) continue;
                parser.nextToken();
            }
        }
    }

    private static void importUsers(KeycloakSession session, RealmProvider model, String realmName, List<UserRepresentation> userReps) {
        RealmModel realm = model.getRealmByName(realmName);
        Map apps = realm.getApplicationNameMap();
        for (UserRepresentation user : userReps) {
            RepresentationToModel.createUser((KeycloakSession)session, (RealmModel)realm, (UserRepresentation)user, (Map)apps);
        }
    }
}

