/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.config.MultiOption;
import org.keycloak.config.Option;
import org.keycloak.config.OptionCategory;

public class OptionBuilder<T> {
    private final Class<T> type;
    private final Class<T> auxiliaryType;
    private final String key;
    private OptionCategory category;
    private boolean hidden;
    private boolean build;
    private String description;
    private Optional<T> defaultValue;
    private List<String> expectedValues;

    public OptionBuilder(String key, Class<T> type) {
        this.type = type;
        this.auxiliaryType = null;
        this.key = key;
        this.category = OptionCategory.GENERAL;
        this.hidden = false;
        this.build = false;
        this.description = null;
        this.defaultValue = Boolean.class.equals(type) ? Optional.of(Boolean.FALSE) : Optional.empty();
        this.expectedValues = new ArrayList<String>();
        if (Boolean.class.equals(type)) {
            this.expectedStringValues(Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }

    public OptionBuilder(String key, Class<T> type, Class<T> auxiliaryType) {
        this.type = type;
        this.auxiliaryType = auxiliaryType;
        this.key = key;
        this.category = OptionCategory.GENERAL;
        this.hidden = false;
        this.build = false;
        this.description = null;
        this.defaultValue = Boolean.class.equals(type) ? Optional.of(Boolean.FALSE) : Optional.empty();
        this.expectedValues = new ArrayList<String>();
        if (Boolean.class.equals(type)) {
            this.expectedStringValues(Boolean.TRUE.toString(), Boolean.FALSE.toString());
        }
    }

    public OptionBuilder<T> category(OptionCategory category) {
        this.category = category;
        return this;
    }

    public OptionBuilder<T> hidden() {
        this.hidden = true;
        return this;
    }

    public OptionBuilder<T> buildTime(boolean build) {
        this.build = build;
        return this;
    }

    public OptionBuilder<T> description(String description) {
        this.description = description;
        return this;
    }

    public OptionBuilder<T> defaultValue(Optional<T> defaultV) {
        this.defaultValue = defaultV;
        return this;
    }

    public OptionBuilder<T> defaultValue(T defaultV) {
        this.defaultValue = Optional.ofNullable(defaultV);
        return this;
    }

    public OptionBuilder<T> expectedStringValues(List<String> expected) {
        this.expectedValues.clear();
        this.expectedValues.addAll(expected);
        return this;
    }

    public OptionBuilder<T> expectedStringValues(String ... expected) {
        this.expectedValues.clear();
        this.expectedValues.addAll(Arrays.asList(expected));
        return this;
    }

    public OptionBuilder<T> expectedValues(List<T> expected) {
        this.expectedValues.clear();
        this.expectedValues.addAll(expected.stream().map(v -> v.toString()).collect(Collectors.toList()));
        return this;
    }

    public OptionBuilder<T> expectedValues(T ... expected) {
        this.expectedValues.clear();
        this.expectedValues.addAll(Arrays.asList(expected).stream().map(v -> v.toString()).collect(Collectors.toList()));
        return this;
    }

    public Option<T> build() {
        if (this.auxiliaryType != null) {
            return new MultiOption(this.type, this.auxiliaryType, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues);
        }
        return new Option<T>(this.type, this.key, this.category, this.hidden, this.build, this.description, this.defaultValue, this.expectedValues);
    }
}

