/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.File;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractGlobalOptionsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCredentialsCmd;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.config.ConfigHandler;
import org.keycloak.client.registration.cli.config.FileConfigHandler;
import org.keycloak.client.registration.cli.config.InMemoryConfigHandler;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;

public abstract class AbstractAuthOptionsCmd
extends AbstractGlobalOptionsCmd {
    static final String DEFAULT_CLIENT = "admin-cli";
    @Option(name="config", description="Path to the config file (~/.keycloak/kcreg.config by default)", hasValue=true)
    protected String config;
    @Option(name="no-config", description="No configuration file should be used, no authentication info is loaded or saved", hasValue=false)
    protected boolean noconfig;
    @Option(name="server", description="Server endpoint url (e.g. 'http://localhost:8080/auth')", hasValue=true)
    protected String server;
    @Option(name="realm", description="Realm name to authenticate against", hasValue=true)
    protected String realm;
    @Option(name="client", description="Realm name to authenticate against", hasValue=true)
    protected String clientId;
    @Option(name="user", description="Username to login with", hasValue=true)
    protected String user;
    @Option(name="password", description="Password to login with (prompted for if not specified and --user is used)", hasValue=true)
    protected String password;
    @Option(name="secret", description="Secret to authenticate the client (prompted for if no --user or --keystore is specified)", hasValue=true)
    protected String secret;
    @Option(name="keystore", description="Path to a keystore containing private key", hasValue=true)
    protected String keystore;
    @Option(name="storepass", description="Keystore password (prompted for if not specified and --keystore is used)", hasValue=true)
    protected String storePass;
    @Option(name="keypass", description="Key password (prompted for if not specified and --keystore is used without --storepass, \n                             otherwise defaults to keystore password)", hasValue=true)
    protected String keyPass;
    @Option(name="alias", description="Alias of the key inside a keystore (defaults to the value of ClientId)", hasValue=true)
    protected String alias;
    @Option(name="truststore", description="Path to a truststore", hasValue=true)
    protected String trustStore;
    @Option(name="trustpass", description="Truststore password (prompted for if not specified and --truststore is used)", hasValue=true)
    protected String trustPass;
    @Option(shortName=116, name="token", description="Initial / Registration access token to use)", hasValue=true)
    protected String token;

    protected void initFromParent(AbstractAuthOptionsCmd parent) {
        super.initFromParent(parent);
        this.noconfig = parent.noconfig;
        this.config = parent.config;
        this.server = parent.server;
        this.realm = parent.realm;
        this.clientId = parent.clientId;
        this.user = parent.user;
        this.password = parent.password;
        this.secret = parent.secret;
        this.keystore = parent.keystore;
        this.storePass = parent.storePass;
        this.keyPass = parent.keyPass;
        this.alias = parent.alias;
        this.trustStore = parent.trustStore;
        this.trustPass = parent.trustPass;
        this.token = parent.token;
    }

    protected void applyDefaultOptionValues() {
        if (this.clientId == null) {
            this.clientId = DEFAULT_CLIENT;
        }
    }

    protected boolean noOptions() {
        return this.server == null && this.realm == null && this.clientId == null && this.secret == null && this.user == null && this.password == null && this.keystore == null && this.storePass == null && this.keyPass == null && this.alias == null && this.trustStore == null && this.trustPass == null && this.token == null && this.config == null;
    }

    @Override
    protected void processGlobalOptions() {
        super.processGlobalOptions();
        if (this.config != null && this.noconfig) {
            throw new RuntimeException("Options --config and --no-config are mutually exclusive");
        }
        if (!this.noconfig) {
            FileConfigHandler.setConfigFile(this.config != null ? this.config : ConfigUtil.DEFAULT_CONFIG_FILE_PATH);
            ConfigUtil.setHandler(new FileConfigHandler());
        } else {
            InMemoryConfigHandler handler = new InMemoryConfigHandler();
            ConfigData data = new ConfigData();
            this.initConfigData(data);
            handler.setConfigData(data);
            ConfigUtil.setHandler(handler);
        }
    }

    protected void setupTruststore(ConfigData configData, CommandInvocation invocation) {
        if (!configData.getServerUrl().startsWith("https:")) {
            return;
        }
        String truststore = this.trustStore;
        if (truststore == null) {
            truststore = configData.getTruststore();
        }
        if (truststore != null) {
            String pass = this.trustPass;
            if (pass == null) {
                pass = configData.getTrustpass();
            }
            if (pass == null) {
                pass = IoUtil.readSecret("Enter truststore password: ", invocation);
            }
            try {
                HttpUtil.setTruststore(new File(truststore), pass);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load truststore: " + truststore, e);
            }
        }
    }

    protected ConfigData ensureAuthInfo(ConfigData config, CommandInvocation commandInvocation) {
        if (this.requiresLogin()) {
            ConfigHandler old = ConfigUtil.getHandler();
            try {
                this.applyDefaultOptionValues();
                this.initConfigData(config);
                ConfigUtil.setupInMemoryHandler(config);
                ConfigCredentialsCmd login = new ConfigCredentialsCmd();
                login.initFromParent(this);
                login.init(config);
                login.process(commandInvocation);
                ConfigData configData = ConfigUtil.loadConfig();
                return configData;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                ConfigUtil.setHandler(old);
            }
        }
        ConfigUtil.checkAuthInfo(config);
        this.applyDefaultOptionValues();
        return ConfigUtil.loadConfig();
    }

    protected boolean requiresLogin() {
        return this.user != null || this.password != null || this.secret != null || this.keystore != null || this.keyPass != null || this.storePass != null || this.alias != null;
    }

    protected ConfigData copyWithServerInfo(ConfigData config) {
        ConfigData result = config.deepcopy();
        if (this.server != null) {
            result.setServerUrl(this.server);
        }
        if (this.realm != null) {
            result.setRealm(this.realm);
        }
        ConfigUtil.checkServerInfo(result);
        return result;
    }

    private void initConfigData(ConfigData data) {
        if (this.server != null) {
            data.setServerUrl(this.server);
        }
        if (this.realm != null) {
            data.setRealm(this.realm);
        }
        if (this.trustStore != null) {
            data.setTruststore(this.trustStore);
        }
        RealmConfigData rdata = data.sessionRealmConfigData();
        if (this.clientId != null) {
            rdata.setClientId(this.clientId);
        }
        if (this.secret != null) {
            rdata.setSecret(this.secret);
        }
    }

    protected void checkUnsupportedOptions(String ... options) {
        if (options.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of argument required");
        }
        for (int i = 0; i < options.length; ++i) {
            String value;
            String name = options[i];
            if ((value = options[++i]) == null) continue;
            throw new IllegalArgumentException("Unsupported option: " + name);
        }
    }

    protected static String booleanOptionForCheck(boolean value) {
        return value ? "true" : null;
    }
}

