/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.Validator;
import org.keycloak.validate.ValidatorConfig;
import org.keycloak.validate.ValidatorFactory;
import org.keycloak.validate.validators.DoubleValidator;
import org.keycloak.validate.validators.EmailValidator;
import org.keycloak.validate.validators.IntegerValidator;
import org.keycloak.validate.validators.LengthValidator;
import org.keycloak.validate.validators.LocalDateValidator;
import org.keycloak.validate.validators.NotBlankValidator;
import org.keycloak.validate.validators.NotEmptyValidator;
import org.keycloak.validate.validators.OptionsValidator;
import org.keycloak.validate.validators.PatternValidator;
import org.keycloak.validate.validators.UriValidator;
import org.keycloak.validate.validators.ValidatorConfigValidator;

public class Validators {
    private static final Map<String, SimpleValidator> INTERNAL_VALIDATORS;
    private final KeycloakSession session;

    public Validators(KeycloakSession session) {
        this.session = session;
    }

    public Validator validator(String id) {
        return Validators.validator(this.session, id);
    }

    public ValidatorFactory validatorFactory(String id) {
        return Validators.validatorFactory(this.session, id);
    }

    public ValidationResult validateConfig(String id, ValidatorConfig config) {
        return Validators.validateConfig(this.session, id, config);
    }

    public static Validator getInternalValidatorById(String id) {
        return INTERNAL_VALIDATORS.get(id);
    }

    public static ValidatorFactory getInternalValidatorFactoryById(String id) {
        return INTERNAL_VALIDATORS.get(id);
    }

    public static Map<String, Validator> getInternalValidators() {
        return Collections.unmodifiableMap(INTERNAL_VALIDATORS);
    }

    public static NotBlankValidator notBlankValidator() {
        return NotBlankValidator.INSTANCE;
    }

    public static NotEmptyValidator notEmptyValidator() {
        return NotEmptyValidator.INSTANCE;
    }

    public static LengthValidator lengthValidator() {
        return LengthValidator.INSTANCE;
    }

    public static UriValidator uriValidator() {
        return UriValidator.INSTANCE;
    }

    public static EmailValidator emailValidator() {
        return EmailValidator.INSTANCE;
    }

    public static PatternValidator patternValidator() {
        return PatternValidator.INSTANCE;
    }

    public static DoubleValidator doubleValidator() {
        return DoubleValidator.INSTANCE;
    }

    public static IntegerValidator integerValidator() {
        return IntegerValidator.INSTANCE;
    }

    public static LocalDateValidator dateValidator() {
        return LocalDateValidator.INSTANCE;
    }

    public static OptionsValidator optionsValidator() {
        return OptionsValidator.INSTANCE;
    }

    public static ValidatorConfigValidator validatorConfigValidator() {
        return ValidatorConfigValidator.INSTANCE;
    }

    public static Validator validator(KeycloakSession session, String id) {
        Validator validator = Validators.getInternalValidatorById(id);
        if (validator != null) {
            return validator;
        }
        if (session == null) {
            return null;
        }
        return session.getProvider(Validator.class, id);
    }

    public static ValidatorFactory validatorFactory(KeycloakSession session, String id) {
        ValidatorFactory factory = Validators.getInternalValidatorFactoryById(id);
        if (factory != null) {
            return factory;
        }
        if (session == null) {
            return null;
        }
        KeycloakSessionFactory sessionFactory = session.getKeycloakSessionFactory();
        return (ValidatorFactory)sessionFactory.getProviderFactory(Validator.class, id);
    }

    public static ValidationResult validateConfig(KeycloakSession session, String id, ValidatorConfig config) {
        ValidatorFactory validatorFactory = Validators.validatorFactory(session, id);
        if (validatorFactory != null) {
            return validatorFactory.validateConfig(session, config);
        }
        return ValidationResult.OK;
    }

    static {
        List<SimpleValidator> list = Arrays.asList(LengthValidator.INSTANCE, NotEmptyValidator.INSTANCE, UriValidator.INSTANCE, EmailValidator.INSTANCE, NotBlankValidator.INSTANCE, PatternValidator.INSTANCE, DoubleValidator.INSTANCE, IntegerValidator.INSTANCE, ValidatorConfigValidator.INSTANCE, OptionsValidator.INSTANCE);
        INTERNAL_VALIDATORS = list.stream().collect(Collectors.toMap(ProviderFactory::getId, v -> v));
    }
}

