/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.cl.Option;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.common.EndpointType;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.util.AuthUtil;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.util.JsonSerialization;

@CommandDefinition(name="get", description="[ARGUMENTS]")
public class GetCmd
extends AbstractAuthOptionsCmd {
    @Option(shortName=99, name="compressed", description="Print full stack trace when exiting with error", hasValue=false)
    private boolean compressed = false;
    @Option(shortName=101, name="endpoint", description="Endpoint type to use", hasValue=true)
    private String endpoint;
    @Arguments
    private List<String> args;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            EndpointType regType;
            this.processGlobalOptions();
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            if (this.args == null || this.args.isEmpty()) {
                throw new RuntimeException("CLIENT not specified");
            }
            if (this.args.size() > 1) {
                throw new RuntimeException("Invalid option: " + this.args.get(1));
            }
            String clientId = this.args.get(0);
            EndpointType endpointType = regType = this.endpoint != null ? EndpointType.of(this.endpoint) : EndpointType.DEFAULT;
            if (clientId.startsWith("-")) {
                IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", clientId);
            }
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            if (this.token == null) {
                this.token = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), clientId);
            }
            this.setupTruststore(config, commandInvocation);
            String auth = this.token;
            if (auth == null) {
                config = this.ensureAuthInfo(config, commandInvocation);
                if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                    auth = AuthUtil.ensureToken(config);
                }
            }
            auth = auth != null ? "Bearer " + auth : null;
            String server = config.getServerUrl();
            String realm = config.getRealm();
            InputStream response = HttpUtil.doGet(server + "/realms/" + realm + "/clients-registrations/" + regType.getEndpoint() + "/" + HttpUtil.urlencode(clientId), "application/json", auth);
            try {
                String json = IoUtil.readFully(response);
                Object result = null;
                switch (regType) {
                    case DEFAULT: {
                        ClientRepresentation client = JsonSerialization.readValue(json, ClientRepresentation.class);
                        result = client;
                        ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
                        break;
                    }
                    case OIDC: {
                        OIDCClientRepresentation client = JsonSerialization.readValue(json, OIDCClientRepresentation.class);
                        result = client;
                        ConfigUtil.saveMergeConfig(cfg -> ConfigUtil.setRegistrationToken(cfg.ensureRealmConfigData(server, realm), client.getClientId(), client.getRegistrationAccessToken()));
                        break;
                    }
                    case INSTALL: {
                        result = JsonSerialization.readValue(json, AdapterConfig.class);
                        break;
                    }
                    case SAML2: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected type: " + (Object)((Object)regType));
                    }
                }
                if (!this.compressed && result != null) {
                    json = JsonSerialization.writeValueAsPrettyString(result);
                }
                IoUtil.printOut(json);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to process HTTP response", e);
            }
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    @Override
    protected String help() {
        return GetCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " get CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to retrieve a client configuration description for a specified client. If registration access token");
        out.println("is specified or is available in configuration file, then it is used. Otherwise, current active session is used.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    -t, --token TOKEN     Registration access token to use");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    CLIENT                ClientId of the client to display");
        out.println("    -c, --compressed      Don't pretty print the output");
        out.println("    -e, --endpoint TYPE   Endpoint type to use - one of: 'default', 'oidc', 'install'");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Get configuration in default format:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get my_client");
        out.println();
        out.println("Get configuration in OIDC format:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get my_client -e oidc");
        out.println();
        out.println("Get adapter configuration for the client:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " get my_client -e install");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

