/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.jboss.aesh.cl.Arguments;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.config.ConfigData;
import org.keycloak.client.registration.cli.util.AuthUtil;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.HttpUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;

@CommandDefinition(name="delete", description="CLIENT [GLOBAL_OPTIONS]")
public class DeleteCmd
extends AbstractAuthOptionsCmd {
    @Arguments
    private List<String> args;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            this.processGlobalOptions();
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            if (this.args == null || this.args.isEmpty()) {
                throw new RuntimeException("CLIENT not specified");
            }
            if (this.args.size() > 1) {
                throw new RuntimeException("Invalid option: " + this.args.get(1));
            }
            String clientId = this.args.get(0);
            if (clientId.startsWith("-")) {
                IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", clientId);
            }
            String regType = "default";
            ConfigData config = ConfigUtil.loadConfig();
            config = this.copyWithServerInfo(config);
            if (this.token == null) {
                this.token = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), clientId);
            }
            this.setupTruststore(config, commandInvocation);
            String auth = this.token;
            if (auth == null) {
                config = this.ensureAuthInfo(config, commandInvocation);
                if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                    auth = AuthUtil.ensureToken(config);
                }
            }
            auth = auth != null ? "Bearer " + auth : null;
            String server = config.getServerUrl();
            String realm = config.getRealm();
            HttpUtil.doDelete(server + "/realms/" + realm + "/clients-registrations/" + regType + "/" + HttpUtil.urlencode(clientId), auth);
            ConfigUtil.saveMergeConfig(cfg -> cfg.ensureRealmConfigData(server, realm).getClients().remove(clientId));
            CommandResult commandResult = CommandResult.SUCCESS;
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    @Override
    protected String help() {
        return DeleteCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " delete CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to delete a specific client configuration. If registration access token is specified or is available in ");
        out.println("configuration file, then it is used. Otherwise, current active session is used.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                    Print full stack trace when exiting with error");
        out.println("    --config              Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println("    --truststore PATH     Path to a truststore containing trusted certificates");
        out.println("    --trustpass PASSWORD  Truststore password (prompted for if not specified and --truststore is used)");
        out.println("    --token TOKEN         Registration access token to use");
        out.println("    CREDENTIALS OPTIONS   Same set of options as accepted by '" + OsUtil.CMD + " config credentials' in order to establish");
        out.println("                          an authenticated sessions. This allows on-the-fly transient authentication that does");
        out.println("                          not touch a config file.");
        out.println();
        out.println("  Command specific options:");
        out.println("    CLIENT                ClientId of the client to delete");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Delete a client:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " delete my_client");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

