/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCmd;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;

@CommandDefinition(name="truststore", description="PATH [ARGUMENTS]")
public class ConfigTruststoreCmd
extends AbstractAuthOptionsCmd
implements Command {
    private ConfigCmd parent;
    private boolean delete;

    protected void initFromParent(ConfigCmd parent) {
        this.parent = parent;
        super.initFromParent(parent);
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            CommandResult commandResult = this.process(commandInvocation);
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        String pass;
        String store;
        ArrayList<String> args = new ArrayList<String>();
        Iterator<String> it = this.parent.args.iterator();
        it.next();
        block7: while (it.hasNext()) {
            String arg;
            switch (arg = it.next()) {
                case "-d": 
                case "--delete": {
                    this.delete = true;
                    continue block7;
                }
            }
            args.add(arg);
        }
        if (args.size() > 1) {
            throw new RuntimeException("Invalid option: " + (String)args.get(1));
        }
        String truststore = null;
        if (args.size() > 0) {
            truststore = (String)args.get(0);
        }
        this.checkUnsupportedOptions("--server", this.server, "--realm", this.realm, "--client", this.clientId, "--user", this.user, "--password", this.password, "--secret", this.secret, "--truststore", this.trustStore, "--keystore", this.keystore, "--keypass", this.keyPass, "--alias", this.alias);
        this.processGlobalOptions();
        if (!this.delete) {
            if (truststore == null) {
                throw new RuntimeException("No truststore specified");
            }
            if (!new File(truststore).isFile()) {
                throw new RuntimeException("Truststore file not found: " + truststore);
            }
            if ("-".equals(this.trustPass)) {
                this.trustPass = IoUtil.readSecret("Enter truststore password: ", commandInvocation);
            }
            store = truststore;
            pass = this.trustPass;
        } else {
            if (truststore != null) {
                throw new RuntimeException("Option --delete is mutually exclusive with specifying a TRUSTSTORE");
            }
            if (this.trustPass != null) {
                throw new RuntimeException("Options --trustpass and --delete are mutually exclusive");
            }
            store = null;
            pass = null;
        }
        ConfigUtil.saveMergeConfig(config -> {
            config.setTruststore(store);
            config.setTrustpass(pass);
        });
        return CommandResult.SUCCESS;
    }

    @Override
    protected String help() {
        return ConfigTruststoreCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWOD] [ARGUMENTS]");
        out.println();
        out.println("Command to configure a global truststore to use when using https to connect to Keycloak server.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println();
        out.println("  Command specific options:");
        out.println("    TRUSTSTORE              Path to truststore file");
        out.println("    --trustpass PASSWORD    Truststore password to unlock truststore (prompted for if set to '-')");
        out.println("    -d, --delete            Remove truststore configuration");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Specify a truststore - you will be prompted for truststore password every time it is used:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config truststore " + OsUtil.OS_ARCH.path("~/.keycloak/truststore.jks"));
        out.println();
        out.println("Specify a truststore, and password - truststore will automatically without prompting for password:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config truststore --storepass " + OsUtil.OS_ARCH.envVar("PASSWORD") + " " + OsUtil.OS_ARCH.path("~/.keycloak/truststore.jks"));
        out.println();
        out.println("Remove truststore configuration:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config truststore --delete");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

