/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.aesh.cl.CommandDefinition;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.console.command.CommandException;
import org.jboss.aesh.console.command.CommandResult;
import org.jboss.aesh.console.command.invocation.CommandInvocation;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import org.keycloak.client.registration.cli.commands.ConfigCmd;
import org.keycloak.client.registration.cli.config.RealmConfigData;
import org.keycloak.client.registration.cli.util.ConfigUtil;
import org.keycloak.client.registration.cli.util.IoUtil;
import org.keycloak.client.registration.cli.util.OsUtil;

@CommandDefinition(name="initial-token", description="[--server SERVER] --realm REALM [--delete | TOKEN] [ARGUMENTS]")
public class ConfigInitialTokenCmd
extends AbstractAuthOptionsCmd
implements Command {
    private ConfigCmd parent;
    private boolean delete;
    private boolean keepDomain;

    protected void initFromParent(ConfigCmd parent) {
        this.parent = parent;
        super.initFromParent(parent);
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            if (this.printHelp()) {
                CommandResult commandResult = CommandResult.SUCCESS;
                return commandResult;
            }
            CommandResult commandResult = this.process(commandInvocation);
            return commandResult;
        }
        finally {
            commandInvocation.stop();
        }
    }

    public CommandResult process(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        String token;
        ArrayList<String> args = new ArrayList<String>();
        Iterator<String> it = this.parent.args.iterator();
        it.next();
        block10: while (it.hasNext()) {
            String arg;
            switch (arg = it.next()) {
                case "-d": 
                case "--delete": {
                    this.delete = true;
                    continue block10;
                }
                case "-k": 
                case "--keep-domain": {
                    this.keepDomain = true;
                    continue block10;
                }
            }
            args.add(arg);
        }
        if (args.size() > 1) {
            throw new RuntimeException("Invalid option: " + (String)args.get(1));
        }
        String string = token = args.size() == 1 ? (String)args.get(0) : null;
        if (this.realm == null) {
            throw new RuntimeException("Realm not specified");
        }
        if (token != null && token.startsWith("-")) {
            IoUtil.warnfOut("You're using what looks like an OPTION as TOKEN: %s", token);
        }
        this.checkUnsupportedOptions("--client", this.clientId, "--user", this.user, "--password", this.password, "--secret", this.secret, "--keystore", this.keystore, "--storepass", this.storePass, "--keypass", this.keyPass, "--alias", this.alias, "--truststore", this.trustStore, "--trustpass", this.keyPass);
        if (!this.delete && token == null) {
            token = IoUtil.readSecret("Enter Initial Access Token: ", commandInvocation);
        }
        this.processGlobalOptions();
        String initialToken = token;
        ConfigUtil.saveMergeConfig(config -> {
            if (!this.keepDomain && !this.delete) {
                config.setServerUrl(this.server);
                config.setRealm(this.realm);
            }
            if (this.delete) {
                RealmConfigData rdata = config.getRealmConfigData(this.server, this.realm);
                if (rdata != null) {
                    rdata.setInitialToken(null);
                }
            } else {
                RealmConfigData rdata = config.ensureRealmConfigData(this.server, this.realm);
                rdata.setInitialToken(initialToken);
            }
        });
        return CommandResult.SUCCESS;
    }

    @Override
    protected String help() {
        return ConfigInitialTokenCmd.usage();
    }

    public static String usage() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + OsUtil.CMD + " config initial-token --server SERVER --realm REALM [--delete | TOKEN] [ARGUMENTS]");
        out.println();
        out.println("Command to configure an initial access token to be used with '" + OsUtil.CMD + " create' command. Even if an ");
        out.println("authenticated session exists as a result of '" + OsUtil.CMD + " config credentials' its access token will not");
        out.println("be used - initial access token will be used instead. By default, current server, and realm will");
        out.println("be set to the new values thus subsequent commands will use these values as default.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to the config file (" + ConfigUtil.DEFAULT_CONFIG_FILE_STRING + " by default)");
        out.println();
        out.println("  Command specific options:");
        out.println("    --server SERVER         Server endpoint url (e.g. 'http://localhost:8080/auth')");
        out.println("    --realm REALM           Realm name to use");
        out.println("    -k, --keep-domain       Don't overwrite default server and realm");
        out.println("    -d, --delete            Indicates that initial access token should be removed");
        out.println("    TOKEN                   Initial access token (prompted for if not specified, unless -d is used)");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Specify initial access token for server, and realm. Token is passed via env variable:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config initial-token --server http://localhost:9080/auth --realm master " + OsUtil.OS_ARCH.envVar("TOKEN"));
        out.println();
        out.println("Remove initial access token:");
        out.println("  " + OsUtil.PROMPT + " " + OsUtil.CMD + " config initial-token --server http://localhost:9080/auth --realm master --delete");
        out.println();
        out.println();
        out.println("Use '" + OsUtil.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

